/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.geotools.resources.XArray;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

final class Resampler2D
extends GridCoverage2D {
    private static final long serialVersionUID = -8593569923766544474L;
    private static final PixelOrientation CORNER = PixelOrientation.CENTER;
    private static final int EMPIRICAL_ADJUSTMENT_STEPS = 16;
    private static final double EPS = 1.0E-6;
    private static final Level LOGGING_LEVEL = Level.FINE;

    private Resampler2D(GridCoverage2D source, PlanarImage image, GridGeometry2D geometry, GridSampleDimension[] sampleDimensions, Hints hints) {
        super((CharSequence)source.getName(), image, geometry, sampleDimensions, new GridCoverage2D[]{source}, null, hints);
    }

    private static GridCoverage2D create(GridCoverage2D source, PlanarImage image, GridGeometry2D geometry, ViewType finalView, Hints hints) {
        GridSampleDimension[] sampleDimensions;
        switch (finalView) {
            case PHOTOGRAPHIC: {
                sampleDimensions = null;
                break;
            }
            default: {
                sampleDimensions = source.getSampleDimensions();
            }
        }
        GridCoverage2D coverage = new Resampler2D(source, image, geometry, sampleDimensions, hints);
        coverage = coverage.view(finalView);
        return coverage;
    }

    public static GridCoverage2D reproject(GridCoverage2D sourceCoverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG, Interpolation interpolation, Hints hints) throws FactoryException, TransformException {
        String operation;
        double[] background;
        ImageLayout layout;
        LinearTransform allSteps;
        MathTransform step3;
        LinearTransform step2;
        MathTransform step1;
        GridGeometry2D sourceGG;
        boolean automaticGR;
        boolean automaticGG;
        CoordinateReferenceSystem sourceCRS = sourceCoverage.getCoordinateReferenceSystem();
        if (targetCRS == null) {
            targetCRS = sourceCRS;
        }
        if (targetGG == null) {
            automaticGG = true;
            automaticGR = true;
        } else {
            boolean bl = automaticGR = !targetGG.isDefined(4);
            if (!automaticGR || targetGG.isDefined(8)) {
                automaticGG = false;
            } else if (targetGG.isDefined(2)) {
                MathTransform2D gridToCRS;
                Envelope envelope = targetGG.getEnvelope();
                sourceGG = sourceCoverage.getGridGeometry();
                switch (envelope.getDimension()) {
                    case 2: {
                        gridToCRS = sourceGG.getGridToCRS2D(CORNER);
                        break;
                    }
                    default: {
                        gridToCRS = sourceGG.getGridToCRS(CORNER);
                    }
                }
                targetGG = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)gridToCRS, envelope, null);
                automaticGG = false;
            } else {
                targetGG = null;
                automaticGG = true;
            }
        }
        GridCoverage2D targetCoverage = Resampler2D.existingCoverage(sourceCoverage, targetCRS, targetGG);
        if (targetCoverage != null) {
            return targetCoverage;
        }
        sourceGG = sourceCoverage.getGridGeometry();
        CoordinateReferenceSystem compatibleSourceCRS = Resampler2D.compatibleSourceCRS(sourceCoverage.getCoordinateReferenceSystem2D(), sourceCRS, targetCRS);
        ViewType processingView = CoverageUtilities.preferredViewForOperation(sourceCoverage, interpolation, false, (RenderingHints)hints);
        ViewType finalView = CoverageUtilities.preferredViewAfterOperation(sourceCoverage);
        sourceCoverage = sourceCoverage.view(processingView);
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
        assert (sourceCoverage.getCoordinateReferenceSystem() == sourceCRS) : sourceCoverage;
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
        MathTransformFactory mtFactory = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getMathTransformFactory() : ReferencingFactoryFinder.getMathTransformFactory(hints);
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            if (!targetGG.isDefined(8)) {
                step1 = sourceGG.getGridToCRS(CORNER);
                step2 = IdentityTransform.create(step1.getTargetDimensions());
                step3 = step1.inverse();
                allSteps = IdentityTransform.create(step1.getSourceDimensions());
                targetGG = new GridGeometry2D((GridEnvelope)targetGG.getGridRange(), step1, targetCRS);
            } else {
                step1 = targetGG.getGridToCRS(CORNER);
                step2 = IdentityTransform.create(step1.getTargetDimensions());
                step3 = sourceGG.getGridToCRS(CORNER).inverse();
                allSteps = mtFactory.createConcatenatedTransform(step1, step3);
                if (!targetGG.isDefined(4)) {
                    Envelope gridRange = Resampler2D.toEnvelope((GridEnvelope)sourceGG.getGridRange());
                    gridRange = CRS.transform(allSteps.inverse(), gridRange);
                    targetGG = new GridGeometry2D(new GeneralGridRange(gridRange, PixelInCell.CELL_CORNER), step1, targetCRS);
                }
            }
        } else {
            if (sourceCRS == null) {
                throw new CannotReprojectException(Errors.format((int)140));
            }
            CoordinateOperation operation2 = factory.createOperation(sourceCRS, targetCRS);
            boolean force2D = sourceCRS != compatibleSourceCRS;
            step2 = factory.createOperation(targetCRS, compatibleSourceCRS).getMathTransform();
            step3 = (force2D ? sourceGG.getGridToCRS2D(CORNER) : sourceGG.getGridToCRS(CORNER)).inverse();
            Envelope sourceEnvelope = sourceCoverage.getEnvelope();
            GeneralEnvelope targetEnvelope = CRS.transform(operation2, sourceEnvelope);
            targetEnvelope.setCoordinateReferenceSystem(targetCRS);
            if (targetGG == null) {
                GeneralGridRange targetGR = force2D ? new GeneralGridRange(sourceGG.getGridRange2D()) : sourceGG.getGridRange();
                targetGG = new GridGeometry2D(targetGR, targetEnvelope);
                step1 = targetGG.getGridToCRS(CORNER);
            } else if (!targetGG.isDefined(8)) {
                targetGG = new GridGeometry2D((GridEnvelope)targetGG.getGridRange(), targetEnvelope);
                step1 = targetGG.getGridToCRS(CORNER);
            } else {
                step1 = targetGG.getGridToCRS(CORNER);
                if (!targetGG.isDefined(4)) {
                    GeneralEnvelope gridRange = CRS.transform(step1.inverse(), (Envelope)targetEnvelope);
                    targetGG = new GridGeometry2D(new GeneralGridRange(gridRange, PixelInCell.CELL_CENTER), step1, targetCRS);
                }
            }
            allSteps = step1.equals(step3.inverse()) ? step2 : mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1, (MathTransform)step2), step3);
        }
        MathTransform2D allSteps2D = Resampler2D.toMathTransform2D(allSteps, mtFactory, targetGG);
        if (!(allSteps2D instanceof MathTransform2D)) {
            throw new TransformException(Errors.format((int)101));
        }
        RenderingHints targetHints = processingView.getRenderingHints((RenderedImage)sourceImage);
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        layout = (layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT)) != null ? (ImageLayout)layout.clone() : new ImageLayout();
        GridRange2D sourceBB = sourceGG.getGridRange2D();
        GridRange2D targetBB = targetGG.getGridRange2D();
        if (Resampler2D.isBoundsUndefined(layout, false)) {
            layout.setMinX(targetBB.x);
            layout.setMinY(targetBB.y);
            layout.setWidth(targetBB.width);
            layout.setHeight(targetBB.height);
        }
        if (Resampler2D.isBoundsUndefined(layout, true)) {
            Dimension size = new Dimension(layout.getWidth((RenderedImage)sourceImage), layout.getHeight((RenderedImage)sourceImage));
            size = ImageUtilities.toTileSize(size);
            layout.setTileGridXOffset(layout.getMinX((RenderedImage)sourceImage));
            layout.setTileGridYOffset(layout.getMinY((RenderedImage)sourceImage));
            layout.setTileWidth(size.width);
            layout.setTileHeight(size.height);
        }
        if ((background = CoverageUtilities.getBackgroundValues(sourceCoverage)) != null && background.length != 0 && !automaticGR) {
            Object borderExtender = XArray.allEquals((double[])background, (double)0.0) ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(background);
            hints.put((Object)JAI.KEY_BORDER_EXTENDER, borderExtender);
        }
        if (ViewType.PHOTOGRAPHIC.equals((Object)processingView)) {
            layout.unsetValid(768);
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        ParameterBlock paramBlk = new ParameterBlock().addSource(sourceImage);
        if (allSteps.isIdentity() || allSteps instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((Object)allSteps), 1.0E-6)) {
            sourceCoverage = sourceCoverage.view(ViewType.NATIVE);
            sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
            paramBlk.removeSources();
            paramBlk.addSource(sourceImage);
            if (targetBB.equals(sourceBB)) {
                sourceCoverage = sourceCoverage.view(finalView);
                sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
                return Resampler2D.create(sourceCoverage, sourceImage, targetGG, ViewType.SAME, hints);
            }
            if (sourceBB.contains(targetBB)) {
                operation = "Crop";
                paramBlk.add(Float.valueOf(targetBB.x)).add(Float.valueOf(targetBB.y)).add(Float.valueOf(targetBB.width)).add(Float.valueOf(targetBB.height));
            } else {
                operation = "Mosaic";
                paramBlk.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY).add(null).add(null).add(null).add(background);
            }
        } else if ((automaticGR || targetBB.equals(sourceBB)) && allSteps instanceof AffineTransform) {
            if (automaticGG) {
                MathTransform mtr = sourceGG.getGridToCRS(CORNER);
                mtr = mtFactory.createConcatenatedTransform(mtr, step2.inverse());
                targetGG = new GridGeometry2D((GridEnvelope)sourceGG.getGridRange(), mtr, targetCRS);
                return Resampler2D.create(sourceCoverage, sourceImage, targetGG, finalView, hints);
            }
            operation = "Affine";
            AffineTransform affine = (AffineTransform)allSteps.inverse();
            paramBlk.add(affine).add(interpolation).add(background);
        } else {
            Warp warp;
            boolean forceAdapter = false;
            switch (sourceImage.getSampleModel().getTransferType()) {
                case 4: 
                case 5: {
                    Envelope source = CRS.transform(sourceGG.getEnvelope(), targetCRS);
                    Envelope target = CRS.transform(targetGG.getEnvelope(), targetCRS);
                    source = targetGG.reduce(source);
                    target = targetGG.reduce(target);
                    if (new GeneralEnvelope(source).contains(target, true)) break;
                    if (interpolation != null && !(interpolation instanceof InterpolationNearest)) {
                        return Resampler2D.reproject(sourceCoverage, targetCRS, targetGG, null, hints);
                    }
                    forceAdapter = true;
                }
            }
            MathTransform2D transform = allSteps2D;
            InternationalString name = sourceCoverage.getName();
            operation = "Warp";
            if (forceAdapter) {
                warp = WarpTransform2D.getWarp((CharSequence)name, transform);
            } else {
                GridRange2D imageBB = layout.getMinX((RenderedImage)sourceImage) == targetBB.x && layout.getMinY((RenderedImage)sourceImage) == targetBB.y && layout.getWidth((RenderedImage)sourceImage) == targetBB.width && layout.getHeight((RenderedImage)sourceImage) == targetBB.height ? targetBB : null;
                warp = Resampler2D.createWarp((CharSequence)name, sourceBB, imageBB, transform, mtFactory);
            }
            paramBlk.add(warp).add(interpolation).add(background);
        }
        RenderedOp targetImage = Resampler2D.getJAI(hints).createNS(operation, paramBlk, targetHints);
        Locale locale = sourceCoverage.getLocale();
        GridRange targetGR = targetGG.getGridRange();
        int[] lower = targetGR.getLow().getCoordinateValues();
        int[] upper = targetGR.getHigh().getCoordinateValues();
        int i = 0;
        while (i < upper.length) {
            int n = i++;
            upper[n] = upper[n] + 1;
        }
        lower[targetGG.gridDimensionX] = targetImage.getMinX();
        lower[targetGG.gridDimensionY] = targetImage.getMinY();
        upper[targetGG.gridDimensionX] = targetImage.getMaxX();
        upper[targetGG.gridDimensionY] = targetImage.getMaxY();
        GeneralGridRange actualGR = new GeneralGridRange(lower, upper);
        if (!targetGR.equals(actualGR)) {
            MathTransform gridToCRS = targetGG.getGridToCRS(CORNER);
            targetGG = new GridGeometry2D(actualGR, gridToCRS, targetCRS);
            if (!automaticGR) {
                Resampler2D.log(Loggings.getResources((Locale)locale).getLogRecord(Level.WARNING, 0, (Object)sourceCoverage.getName().toString(locale)));
            }
        }
        targetCoverage = Resampler2D.create(sourceCoverage, (PlanarImage)targetImage, targetGG, finalView, hints);
        assert (CRS.equalsIgnoreMetadata(targetCoverage.getCoordinateReferenceSystem(), targetCRS)) : targetGG;
        assert (targetCoverage.getGridGeometry().getGridRange2D().equals(targetImage.getBounds())) : targetGG;
        if (AbstractProcessor.LOGGER.isLoggable(LOGGING_LEVEL)) {
            Object[] objectArray = new Object[11];
            objectArray[0] = sourceCoverage.getName().toString(locale);
            objectArray[1] = sourceCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[2] = sourceImage.getWidth();
            objectArray[3] = sourceImage.getHeight();
            objectArray[4] = targetCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[5] = targetImage.getWidth();
            objectArray[6] = targetImage.getHeight();
            objectArray[7] = targetImage.getOperationName();
            objectArray[8] = sourceCoverage == sourceCoverage.view(ViewType.GEOPHYSICS) ? 1 : 0;
            objectArray[9] = ImageUtilities.getInterpolationName(interpolation);
            objectArray[10] = background != null ? (background.length == 1 ? (Double.isNaN(background[0]) ? "NaN" : Double.valueOf(background[0])) : XArray.toString((Object)background, (Locale)locale)) : "No background used";
            Resampler2D.log(Loggings.getResources((Locale)locale).getLogRecord(LOGGING_LEVEL, 3, (Object)objectArray));
        }
        return targetCoverage;
    }

    private static GridCoverage2D existingCoverage(GridCoverage2D coverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG) {
        while (!Resampler2D.equivalent(coverage.getGridGeometry(), targetGG) || !CRS.equalsIgnoreMetadata(targetCRS, coverage.getCoordinateReferenceSystem()) && !CRS.equalsIgnoreMetadata(targetCRS, coverage.getCoordinateReferenceSystem2D())) {
            if (!(coverage instanceof Resampler2D)) {
                return null;
            }
            List<GridCoverage> sources = coverage.getSources();
            assert (sources.size() == 1) : sources;
            coverage = (GridCoverage2D)sources.get(0);
        }
        return coverage;
    }

    private static JAI getJAI(Hints hints) {
        Object property;
        if (hints != null && (property = hints.get((Object)Hints.JAI_INSTANCE)) instanceof JAI) {
            return (JAI)property;
        }
        return JAI.getDefaultInstance();
    }

    private static boolean isBoundsUndefined(ImageLayout layout, boolean tile) {
        int mask = tile ? 240 : 15;
        return (layout.getValidMask() & mask) == 0;
    }

    private static CoordinateReferenceSystem compatibleSourceCRS(CoordinateReferenceSystem sourceCRS2D, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        int dim2D = sourceCRS2D.getCoordinateSystem().getDimension();
        return targetCRS.getCoordinateSystem().getDimension() == dim2D && sourceCRS.getCoordinateSystem().getDimension() > dim2D ? sourceCRS2D : sourceCRS;
    }

    private static MathTransform2D toMathTransform2D(MathTransform transform, MathTransformFactory mtFactory, GridGeometry2D sourceGG) throws FactoryException {
        DimensionFilter filter = new DimensionFilter(mtFactory);
        filter.addSourceDimension(sourceGG.axisDimensionX);
        filter.addSourceDimension(sourceGG.axisDimensionY);
        MathTransform candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        filter.addTargetDimension(sourceGG.axisDimensionX);
        filter.addTargetDimension(sourceGG.axisDimensionY);
        candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        throw new FactoryException(Errors.format((int)101));
    }

    private static boolean equivalent(GridGeometry2D sourceGG, GridGeometry2D targetGG) {
        if (targetGG == null || targetGG.equals(sourceGG)) {
            return true;
        }
        if (targetGG.isDefined(4) && sourceGG.isDefined(4) && !targetGG.getGridRange().equals(sourceGG.getGridRange())) {
            return false;
        }
        return !targetGG.isDefined(8) || !sourceGG.isDefined(8) || targetGG.getGridToCRS().equals(sourceGG.getGridToCRS());
    }

    private static Envelope toEnvelope(GridEnvelope gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLow(i);
            upper[i] = gridRange.getHigh(i) + 1;
        }
        return new GeneralEnvelope(lower, upper);
    }

    private static Warp createWarp(CharSequence name, Rectangle sourceBB, Rectangle targetBB, MathTransform2D allSteps2D, MathTransformFactory mtFactory) throws FactoryException {
        MathTransform2D transform = allSteps2D;
        Object actualBB = null;
        boolean step = false;
        if (actualBB != null) {
            double scaleX = 1.0 - (double)sourceBB.width / (double)actualBB.width;
            double scaleY = 1.0 - (double)sourceBB.height / (double)actualBB.height;
            double translateX = sourceBB.x - actualBB.x;
            double translateY = sourceBB.y - actualBB.y;
            double factor = (double)step / 16.0;
            AffineTransform2D adjustment = new AffineTransform2D(1.0 - scaleX * factor, 0.0, 0.0, 1.0 - scaleY * factor, translateX * factor, translateY * factor);
            transform = (MathTransform2D)mtFactory.createConcatenatedTransform((MathTransform)allSteps2D, (MathTransform)adjustment);
        }
        Object warp = transform instanceof AffineTransform ? new WarpAffine((AffineTransform)transform) : WarpTransform2D.getWarp(name, transform);
        return warp;
    }

    private static void log(LogRecord record) {
        record.setSourceClassName("Resample");
        record.setSourceMethodName("doOperation");
        Logger logger = AbstractProcessor.LOGGER;
        record.setLoggerName(logger.getName());
        logger.log(record);
    }
}

