/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.gui.input.InputComponent;
import jams.gui.input.JCalendarButton;
import jams.gui.input.JTimeButton;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CalendarInput
extends JPanel
implements InputComponent {
    private JTextField dateText;
    private JTextField timeText;
    private JPanel datePanel;
    private JPanel timePanel;
    private ValueChangeListener l;
    private JCalendarButton dateButton;
    private JTimeButton timeButton;
    private String oldDateString;
    private static DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private static DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 3);
    private Color oldColor;

    public CalendarInput() {
        this(true);
        timeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateTimeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
    }

    public CalendarInput(boolean doLayout) {
        this.createPanels();
        if (doLayout) {
            GridBagLayout gbl = new GridBagLayout();
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(gbl);
            GUIHelper.addGBComponent(this, gbl, this.datePanel, 1, 1, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this, gbl, this.timePanel, 11, 1, 1, 1, 0.0, 0.0);
            this.dateText.setToolTipText(JAMS.i18n("Date"));
            this.timeText.setToolTipText(JAMS.i18n("Time"));
        }
    }

    public void createPanels() {
        dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateTimeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.datePanel = new JPanel();
        this.dateText = new JTextField();
        this.dateText.setPreferredSize(new Dimension(100, 20));
        this.dateText.setBorder(BorderFactory.createEtchedBorder());
        this.datePanel.add(this.dateText);
        this.dateButton = new JCalendarButton();
        this.dateButton.setText("");
        this.dateButton.setPreferredSize(new Dimension(20, 20));
        this.dateButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Calendar.gif")));
        this.dateButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Date) {
                    CalendarInput.this.setDate((Date)evt.getNewValue());
                }
            }
        });
        this.dateText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String dateString = CalendarInput.this.getDateText().getText();
                Date date = null;
                try {
                    if (!StringTools.isEmptyString(dateString)) {
                        date = dateFormat.parse(dateString);
                    }
                }
                catch (Exception e) {
                    date = null;
                }
                CalendarInput.this.setDate(date);
            }
        });
        this.datePanel.add(this.dateButton);
        this.timePanel = new JPanel();
        this.timeText = new JTextField();
        this.timeText.setPreferredSize(new Dimension(80, 20));
        this.timeText.setBorder(BorderFactory.createEtchedBorder());
        this.timePanel.add(this.timeText);
        this.timeButton = new JTimeButton();
        this.timeButton.setText("");
        this.timeButton.setPreferredSize(new Dimension(20, 20));
        this.timeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Time.gif")));
        this.timeButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Date) {
                    CalendarInput.this.setTime((Date)evt.getNewValue());
                }
            }
        });
        this.timeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String timeString = CalendarInput.this.getTimeText().getText();
                Date time = null;
                try {
                    if (!StringTools.isEmptyString(timeString)) {
                        time = timeFormat.parse(timeString);
                    }
                }
                catch (Exception e) {
                    time = null;
                }
                CalendarInput.this.setTime(time);
            }
        });
        this.timePanel.add(this.timeButton);
    }

    public void setDate(Date date) {
        String dateString = this.oldDateString;
        if (date != null) {
            this.oldDateString = dateString = dateFormat.format(date);
        }
        this.dateText.setText(dateString);
        this.dateButton.setTargetDate(date);
    }

    public void setTime(Date time) {
        String timeString = "";
        if (time != null) {
            timeString = timeFormat.format(time);
        }
        this.timeText.setText(timeString);
        this.timeButton.setTargetDate(time);
    }

    @Override
    public String getValue() {
        try {
            Date dateTime = dateTimeFormat.parse(this.dateText.getText() + " " + this.timeText.getText());
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            cal.setTime(dateTime);
            return cal.toString();
        }
        catch (ParseException pe) {
            return "";
        }
    }

    public Attribute.Calendar getCalendarValue() {
        try {
            Date dateTime = dateTimeFormat.parse(this.dateText.getText() + " " + this.timeText.getText());
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            cal.setTime(dateTime);
            return cal;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    @Override
    public void setValue(String value) {
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        if (!StringTools.isEmptyString(value)) {
            cal.setValue(value);
        }
        this.setValue(cal);
    }

    public void setValue(Attribute.Calendar calendar) {
        Date d = calendar.getTime();
        TimeZone oldZone = timeFormat.getTimeZone();
        timeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        String dateString = dateFormat.format(d);
        String timeString = timeFormat.format(d);
        this.oldDateString = dateString;
        this.dateText.setText(dateString);
        this.timeText.setText(timeString);
        timeFormat.setTimeZone(oldZone);
        try {
            this.timeButton.setTargetDate(timeFormat.parse(timeString));
            this.dateButton.setTargetDate(dateFormat.parse(dateString));
        }
        catch (ParseException ex) {
            // empty catch block
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateText.setEnabled(enabled);
        this.timeText.setEnabled(enabled);
        this.dateButton.setEnabled(enabled);
        this.timeButton.setEnabled(enabled);
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public boolean verify() {
        try {
            if (StringTools.isEmptyString(this.getValue())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.dateText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.timeText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.getBackground();
            this.setBackground(new Color(255, 0, 0));
        } else {
            this.setBackground(this.oldColor);
        }
    }

    public static void main(String[] args) {
        CalendarInput tii = new CalendarInput();
        Attribute.Calendar c = DefaultDataFactory.getDataFactory().createCalendar();
        c.setValue("1996-11-01 23:30");
        tii.setValue(c.toString());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(tii.getComponent());
        frame.pack();
        frame.setVisible(true);
    }

    public JPanel getDatePanel() {
        return this.datePanel;
    }

    public JPanel getTimePanel() {
        return this.timePanel;
    }

    public JTextField getDateText() {
        return this.dateText;
    }

    public JTextField getTimeText() {
        return this.timeText;
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }
}

