/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMColorChooser;
import com.bbn.openmap.tools.icon.IconPartList;
import com.bbn.openmap.tools.icon.OMIconFactory;
import com.bbn.openmap.tools.icon.OpenMapAppPartCollection;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ColorPropertyEditor
extends PropertyEditorSupport {
    JButton button = new JButton("Select color...");
    public static final String title = "Select color...";
    protected int icon_width = 20;
    protected int icon_height = 20;

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color startingColor;
                try {
                    startingColor = ColorFactory.parseColor(ColorPropertyEditor.this.getAsText(), true);
                }
                catch (NumberFormatException nfe) {
                    startingColor = OMColor.clear;
                }
                Color color = OMColorChooser.showDialog(ColorPropertyEditor.this.button, ColorPropertyEditor.title, startingColor);
                if (color == null) {
                    color = startingColor;
                }
                ColorPropertyEditor.this.setValue(color);
            }
        });
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        panel.setLayout(gridbag);
        gridbag.setConstraints(this.button, c);
        panel.add(this.button);
        return panel;
    }

    public ImageIcon getIconForPaint(Paint paint, boolean fill) {
        if (paint == null) {
            paint = Color.black;
        }
        DrawingAttributes da = new DrawingAttributes();
        da.setLinePaint(paint);
        da.setStroke(new BasicStroke(2.0f));
        if (fill) {
            da.setFillPaint(paint);
        }
        OpenMapAppPartCollection collection = OpenMapAppPartCollection.getInstance();
        IconPartList parts = new IconPartList();
        if (paint instanceof Color || paint == OMColor.clear) {
            Color color = (Color)paint;
            Color opaqueColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
            DrawingAttributes opaqueDA = new DrawingAttributes();
            opaqueDA.setLinePaint(opaqueColor);
            opaqueDA.setStroke(new BasicStroke(2.0f));
            if (fill) {
                opaqueDA.setFillPaint(opaqueColor);
            }
            parts.add(collection.get("LR_TRI", opaqueDA));
            parts.add(collection.get("UL_TRI", da));
        } else {
            parts.add(collection.get("BIG_BOX", da));
        }
        return OMIconFactory.getIcon(this.icon_width, this.icon_height, parts);
    }

    public void setValue(Object someObj) {
        if (someObj == null) {
            this.setButtonForColor(Color.black);
        } else if (someObj instanceof Color) {
            this.setButtonForColor((Color)someObj);
        } else if (someObj instanceof String) {
            Color color = OMColor.clear;
            try {
                color = ColorFactory.parseColor((String)someObj, true);
            }
            catch (NumberFormatException nfe) {
                Debug.output("ColorPropertyEditor.setValue problem with color: " + someObj + "\n" + nfe.getMessage());
            }
            this.setButtonForColor(color);
        }
    }

    protected void setButtonForColor(Color color) {
        this.button.setIcon(this.getIconForPaint(color, true));
        String val = Integer.toHexString(color.getRGB());
        if (val.equals("0")) {
            val = "00000000";
        }
        this.button.setText(val);
    }

    public String getAsText() {
        return this.button.getText();
    }

    public void actionPerformed(ActionEvent e) {
    }
}

