/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

public abstract class SwingWorker {
    private Object value;
    private boolean interrupted = false;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
        this.interrupted = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                t.interrupt();
                this.interrupted = true;
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block5: {
                    block4: {
                        Object value = null;
                        try {
                            value = SwingWorker.this.construct();
                            Object var3_2 = null;
                            if (Thread.currentThread().isInterrupted()) break block4;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (!Thread.currentThread().isInterrupted()) {
                                SwingWorker.this.setValue(value);
                            } else {
                                SwingWorker.this.setValue(null);
                            }
                            Thread fT = new Thread(doFinished);
                            fT.start();
                            SwingWorker.this.threadVar.clear();
                            throw throwable;
                        }
                        SwingWorker.this.setValue(value);
                        break block5;
                    }
                    SwingWorker.this.setValue(null);
                }
                Thread fT = new Thread(doFinished);
                fT.start();
                SwingWorker.this.threadVar.clear();
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    public void execute() {
        this.start();
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

