/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.drawing;

import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.util.Debug;
import java.util.Hashtable;
import java.util.Iterator;

public class DrawingToolRequestorList
implements DrawingToolRequestor {
    protected String name;
    protected Hashtable table = new Hashtable();

    public void add(OMGraphic omg, DrawingToolRequestor dtr) {
        if (Debug.debugging("drawingtool")) {
            Debug.output("DTRL.add(" + omg.getClass().getName() + ")");
        }
        this.table.put(omg, dtr);
    }

    public void remove(OMGraphic omg) {
        this.table.remove(omg);
    }

    public void clear() {
        this.table.clear();
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (omg instanceof OMGraphicList) {
            if (Debug.debugging("drawingtool")) {
                Debug.output("DTRL.drawingComplete(list)");
            }
            Iterator it = ((OMGraphicList)omg).iterator();
            while (it.hasNext()) {
                OMGraphic omgi = (OMGraphic)it.next();
                DrawingToolRequestor dtr = (DrawingToolRequestor)this.table.get(omgi);
                if (dtr == null) continue;
                if (Debug.debugging("drawingtool")) {
                    Debug.output("  notifying requestor for list member " + omgi.getClass().getName());
                }
                dtr.drawingComplete(omgi, action);
            }
        } else {
            DrawingToolRequestor dtr = (DrawingToolRequestor)this.table.get(omg);
            if (dtr != null) {
                if (Debug.debugging("drawingtool")) {
                    Debug.output("  notifying requestor for " + omg.getClass().getName());
                }
                dtr.drawingComplete(omg, action);
            }
        }
        if (Debug.debugging("drawingtool")) {
            Debug.output("DTRL.drawingComplete complete");
        }
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

