/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.tools.beanbox.BeanBox;
import com.bbn.openmap.tools.beanbox.BeanBoxHandler;
import com.bbn.openmap.tools.beanbox.BeanPanel;
import com.bbn.openmap.tools.beanbox.GenericPropertySheet;
import com.bbn.openmap.tools.dnd.ComponentDragGestureListener;
import com.bbn.openmap.tools.dnd.DefaultDnDCatcher;
import com.bbn.openmap.tools.dnd.DefaultTransferableObject;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class BeanBoxDnDCatcher
extends DefaultDnDCatcher
implements SoloMapComponent,
BeanContextChild,
BeanContextMembershipListener,
PropertyChangeListener,
Serializable,
ProjectionListener,
LayerListener,
ActionListener {
    private Vector transferData;
    private Point dropLocation;
    protected Object selectedBean = null;
    protected ByteArrayOutputStream serBean = null;
    protected Point selectedBeanLocation = null;
    protected BeanBox selectedBeanBox = null;
    protected Layer selectedBeanLayer = null;
    Object cutBean = null;
    protected HashMap beanInfoMap = null;
    static /* synthetic */ Class class$com$bbn$openmap$tools$beanbox$BeanPanel;

    public BeanBoxDnDCatcher() {
        this(new DragSource());
    }

    public BeanBoxDnDCatcher(DragSource ds) {
        this(ds, null);
    }

    public BeanBoxDnDCatcher(DragSource ds, Component c) {
        this(ds, c, 2);
    }

    public BeanBoxDnDCatcher(DragSource ds, Component c, int act) {
        this(ds, c, act, null);
    }

    public BeanBoxDnDCatcher(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
        this.dragSource = this.getDragSource();
        this.dragGestureListener = new ComponentDragGestureListener(this, this);
        this.setSourceActions(2);
        this.beanInfoMap = new HashMap();
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapBean) {
            ((MapBean)someObj).addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.getModifiers() == 2 && evt.getKeyCode() == 67) {
                        BeanBoxDnDCatcher.this.copySelectedBean();
                    } else if (evt.getModifiers() == 2 && evt.getKeyCode() == 86) {
                        BeanBoxDnDCatcher.this.pasteSelectedBean();
                    } else if (evt.getModifiers() == 2 && evt.getKeyCode() == 88) {
                        BeanBoxDnDCatcher.this.cutSelectedBean();
                    } else if (evt.getKeyCode() == 27) {
                        BeanBoxDnDCatcher.this.unCutSelectedBean();
                    } else if (evt.getKeyCode() == 127) {
                        BeanBoxDnDCatcher.this.deleteSelectedBean();
                    }
                }
            });
        }
    }

    protected void copySelectedBean() {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> copySelectedBean");
        }
        if (this.selectedBean == null || this.selectedBeanLocation == null) {
            this.clearSelection();
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBean=" + this.selectedBean);
            }
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBeanLocation=" + this.selectedBeanLocation);
            }
            return;
        }
        try {
            this.serBean = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(this.serBean);
            oos.writeObject(this.selectedBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearSelection();
            if (Debug.debugging("beanbox")) {
                Debug.output("Exit> copySelectedBean");
            }
            return;
        }
        this.cutBean = null;
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> copySelectedBean");
        }
    }

    protected void pasteSelectedBean() {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> pasteSelectedBean");
        }
        if (this.serBean == null) {
            this.clearSelection();
            if (Debug.debugging("beanbox")) {
                Debug.output("Exit> pasteSelectedBean");
            }
            return;
        }
        BeanInfo beanInfo = (BeanInfo)this.beanInfoMap.get(this.selectedBean.getClass().getName());
        if (beanInfo == null) {
            System.out.println("ERROR> BBDnDC::pasteSelectedBean: no cached BeanInfo found for bean " + this.selectedBean);
            this.clearSelection();
            return;
        }
        if (this.cutBean != null) {
            this.selectedBeanBox.removeBean(this.selectedBean);
        }
        Object deserBean = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.serBean.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            deserBean = ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearSelection();
            if (Debug.debugging("beanbox")) {
                Debug.output("Exit> pasteSelectedBean");
            }
            return;
        }
        this.transferData = new Vector();
        this.transferData.add(deserBean);
        this.transferData.add(beanInfo);
        this.transferData.add(new Boolean(false));
        this.dropLocation = this.selectedBeanLocation;
        this.showPopUp(this.selectedBeanLayer);
        this.cutBean = null;
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> pasteSelectedBean");
        }
    }

    protected void cutSelectedBean() {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> cutSelectedBean");
        }
        if (this.selectedBean == null || this.selectedBeanLocation == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBean=" + this.selectedBean);
            }
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBeanLocation=" + this.selectedBeanLocation);
            }
            this.clearSelection();
            return;
        }
        try {
            this.serBean = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(this.serBean);
            oos.writeObject(this.selectedBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearSelection();
            if (Debug.debugging("beanbox")) {
                Debug.output("Exit> copySelectedBean");
            }
            return;
        }
        this.cutBean = this.selectedBean;
        this.selectedBeanBox.showCut(this.selectedBean);
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> cutSelectedBean");
        }
    }

    protected void unCutSelectedBean() {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> unCutSelectedBean");
        }
        if (this.selectedBean == null || this.selectedBeanLocation == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBean=" + this.selectedBean);
            }
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBeanLocation=" + this.selectedBeanLocation);
            }
            this.clearSelection();
            return;
        }
        this.selectedBeanBox.showUnCut(this.selectedBean);
        this.clearSelection();
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> unCutSelectedBean");
        }
    }

    private void clearSelection() {
        this.cutBean = null;
        this.selectedBean = null;
        this.selectedBeanLocation = null;
        this.selectedBeanBox = null;
        this.selectedBeanLayer = null;
        this.serBean = null;
    }

    protected void deleteSelectedBean() {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> deleteSelectedBean");
        }
        if (this.selectedBean == null || this.selectedBeanLocation == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBean=" + this.selectedBean);
            }
            if (Debug.debugging("beanbox")) {
                Debug.output("selectedBeanLocation=" + this.selectedBeanLocation);
            }
            return;
        }
        this.selectedBeanBox.removeBean(this.selectedBean);
        this.cutBean = null;
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> deleteSelectedBean");
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> drop");
        }
        dtde.acceptDrop(2);
        this.extractTransferData(dtde);
        this.extractDropLocation(dtde);
        if (this.transferData == null || this.dropLocation == null) {
            return;
        }
        Component parent = ((DropTarget)dtde.getSource()).getComponent();
        dtde.dropComplete(true);
        this.showPopUp(parent);
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> drop");
        }
    }

    private void showPopUp(Component parent) {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> showPopUp");
        }
        JPopupMenu popup = new JPopupMenu();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Available Drop Targets:");
        titledBorder.setTitleColor(Color.gray);
        popup.setBorder(titledBorder);
        CompoundBorder compoundborder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Enumeration keys = this.layers.keys();
        while (keys.hasMoreElements()) {
            String layerName = keys.nextElement().toString();
            Layer omlayer = (Layer)this.layers.get(layerName);
            if (!omlayer.isVisible()) continue;
            JMenuItem menuItem = new JMenuItem(layerName);
            menuItem.setHorizontalTextPosition(0);
            menuItem.setBorder(compoundborder);
            menuItem.addActionListener(this);
            popup.add(menuItem);
        }
        popup.addSeparator();
        JMenuItem menuItem = new JMenuItem("CANCEL");
        menuItem.setForeground(Color.red);
        menuItem.setHorizontalTextPosition(0);
        menuItem.setBorder(compoundborder);
        popup.add(menuItem);
        popup.setPreferredSize(new Dimension(150, (popup.getComponentCount() + 1) * 25));
        if (Debug.debugging("beanbox")) {
            Debug.output("showing popup");
        }
        popup.show(parent, this.dropLocation.x, this.dropLocation.y);
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> showPopUp");
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> mouseClicked");
        }
        Point srcLocation = evt.getPoint();
        Enumeration keys = this.layers.keys();
        while (keys.hasMoreElements()) {
            String layerName = keys.nextElement().toString();
            this.selectedBeanLayer = (Layer)this.layers.get(layerName);
            if (!this.selectedBeanLayer.isVisible()) continue;
            this.selectedBeanBox = ((BeanBoxHandler)((Object)this.selectedBeanLayer)).getBeanBox();
            if (this.selectedBeanBox == null) continue;
            this.selectedBean = this.selectedBeanBox.getBeanAtLocation(srcLocation);
            if (this.selectedBean == null) continue;
            break;
        }
        if (this.selectedBean == null) {
            this.clearSelection();
            return;
        }
        this.selectedBeanLocation = srcLocation;
        this.selectedBeanBox.showSelected(this.selectedBean);
        if (Debug.debugging("beanbox")) {
            Debug.output("selectedBean=" + this.selectedBean);
        }
        if (evt.getModifiers() != 16) {
            GenericPropertySheet propertySheet = new GenericPropertySheet(this.selectedBean, 575, 20, null, this.selectedBeanBox);
            propertySheet.setVisible(true);
        }
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> mouseClicked");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source;
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> actionPerformed");
        }
        if (!((source = evt.getSource()) instanceof JMenuItem)) {
            return;
        }
        JMenuItem mi = (JMenuItem)source;
        String name = mi.getText();
        Layer targetLayer = (Layer)this.layers.get(name);
        if (targetLayer == null) {
            System.out.println("ERROR> BBDnDC::actionPerformed: no layer found with name " + name);
            return;
        }
        BeanBox targetBeanBox = ((BeanBoxHandler)((Object)targetLayer)).getBeanBox();
        Object bean = this.transferData.get(0);
        BeanInfo beanInfo = (BeanInfo)this.transferData.get(1);
        Boolean wasBeanMoved = (Boolean)this.transferData.get(2);
        if (wasBeanMoved.booleanValue()) {
            String sourceLayerName = (String)this.transferData.get(3);
            if (sourceLayerName.equals(targetLayer.getName())) {
                targetBeanBox.relocateBean(bean, beanInfo, this.dropLocation);
            } else {
                Layer sourceLayer = (Layer)this.layers.get(sourceLayerName);
                BeanBox sourceBeanBox = ((BeanBoxHandler)((Object)sourceLayer)).getBeanBox();
                sourceBeanBox.removeBean(bean);
                Vector object = new Vector();
                object.add(bean);
                object.add(beanInfo);
                object.add(this.dropLocation);
                targetBeanBox.addBean(object);
            }
        } else {
            Vector object = new Vector();
            object.add(bean);
            object.add(beanInfo);
            object.add(this.dropLocation);
            targetBeanBox.addBean(object);
        }
    }

    public void setLayers(Layer[] allLayers) {
        this.layers.clear();
        for (int i = 0; i < allLayers.length; ++i) {
            new DropTarget(allLayers[i], 2, this);
            if (!(allLayers[i] instanceof BeanBoxHandler)) continue;
            Debug.message("DnDCatcher", "Layers changed");
            this.layers.put(allLayers[i].getName(), allLayers[i]);
        }
    }

    public void startDragAction(DragGestureEvent dge, DragSourceListener dsl) {
        if (Debug.debugging("beanbox")) {
            Debug.output("Enter> startDragAction");
        }
        Object selectedBean = null;
        BeanBox selectedBeanBox = null;
        Layer selectedLayer = null;
        Point srcLocation = dge.getDragOrigin();
        Enumeration keys = this.layers.keys();
        while (keys.hasMoreElements()) {
            String layerName = keys.nextElement().toString();
            Layer omLayer = (Layer)this.layers.get(layerName);
            BeanBox beanBox = ((BeanBoxHandler)((Object)omLayer)).getBeanBox();
            selectedBean = beanBox.getBeanAtLocation(srcLocation);
            if (selectedBean == null) continue;
            selectedBeanBox = beanBox;
            selectedLayer = omLayer;
            break;
        }
        if (Debug.debugging("beanbox")) {
            Debug.output("selectedBean=" + selectedBean);
        }
        if (selectedBean == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("Exit> startDragAction");
            }
            return;
        }
        Image dragImage = selectedBeanBox.getDragImage(selectedBean);
        super.setCursor(dragImage, DragSource.DefaultMoveDrop);
        BeanInfo beanInfo = selectedBeanBox.getBeanInfoForBean(selectedBean.getClass().getName());
        Vector<Object> beanTransferData = new Vector<Object>();
        beanTransferData.add(selectedBean);
        beanTransferData.add(beanInfo);
        beanTransferData.add(new Boolean(true));
        beanTransferData.add(selectedLayer.getName());
        this.dragSource.startDrag(dge, super.getCursor(DragSource.DefaultMoveDrop), new DefaultTransferableObject(beanTransferData), dsl);
        if (Debug.debugging("beanbox")) {
            Debug.output("Exit> startDragAction");
        }
    }

    private void extractTransferData(DropTargetDropEvent dtde) {
        if (dtde == null) {
            System.out.println("ERROR> BDnDC::getTransferData(): dropEvent is null");
            return;
        }
        Transferable tr = dtde.getTransferable();
        try {
            this.transferData = (Vector)tr.getTransferData(DefaultTransferableObject.OBJECT_FLAVOR);
            if (this.transferData.size() >= 2) {
                Object bean = this.transferData.get(0);
                BeanInfo beanInfo = (BeanInfo)this.transferData.get(1);
                this.beanInfoMap.put(bean.getClass().getName(), beanInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractDropLocation(DropTargetDropEvent dtde) {
        if (dtde == null) {
            System.out.println("ERROR> BDnDC::getTransferData(): dropEvent is null");
            return;
        }
        this.dropLocation = dtde.getLocation();
    }

    private static void setDefaultIcon() {
        URL url;
        if (BeanPanel.defaultBeanIcon == null && (url = (class$com$bbn$openmap$tools$beanbox$BeanPanel == null ? (class$com$bbn$openmap$tools$beanbox$BeanPanel = BeanBoxDnDCatcher.class$("com.bbn.openmap.tools.beanbox.BeanPanel")) : class$com$bbn$openmap$tools$beanbox$BeanPanel).getResource("bluebean.gif")) != null) {
            BeanPanel.defaultBeanIcon = new ImageIcon(url);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BeanBoxDnDCatcher.setDefaultIcon();
    }
}

