/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMAbstractLine;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMArrowHead;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.PolyAddNodeState;
import com.bbn.openmap.omGraphics.editable.PolyDeleteNodeState;
import com.bbn.openmap.omGraphics.editable.PolyStateMachine;
import com.bbn.openmap.omGraphics.editable.PolyUndefinedState;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class EditableOMPoly
extends EditableOMAbstractLine {
    protected ArrayList polyGrabPoints;
    protected OffsetGrabPoint gpo;
    protected OffsetGrabPoint gpm;
    protected OMPoly poly;
    protected boolean manualEnclosed = false;
    public static int OFFSET_POINT_INDEX = -1;
    JToggleButton polygonButton = null;
    JButton addButton = null;
    JButton deleteButton = null;
    static /* synthetic */ Class class$com$bbn$openmap$omGraphics$EditableOMPoly;

    public EditableOMPoly() {
        this.createGraphic(null);
    }

    public EditableOMPoly(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMPoly(OMPoly omp) {
        this.setGraphic(omp);
    }

    public void init() {
        Debug.message("eomg", "EditableOMPoly.init()");
        this.setStateMachine(new PolyStateMachine(this));
        this.gPoints = new GrabPoint[1];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMPoly) {
            this.poly = (OMPoly)graphic;
            this.poly.setDoShapes(true);
            this.stateMachine.setSelected();
            this.setGrabPoints(this.poly);
        } else {
            this.createGraphic(null);
        }
    }

    public boolean evaluateEnclosed() {
        this.deletePoint();
        boolean enclosed = false;
        if (this.isEnclosed()) {
            this.enclose(true);
            enclosed = true;
        }
        return enclosed;
    }

    protected boolean syncEnclosed() {
        try {
            OffsetGrabPoint gb0 = (OffsetGrabPoint)this.polyGrabPoints.get(0);
            OffsetGrabPoint ogb = (OffsetGrabPoint)this.polyGrabPoints.get(this.polyGrabPoints.size() - 1);
            if (gb0.getX() == ogb.getX() && gb0.getY() == ogb.getY()) {
                gb0.addGrabPoint(ogb);
                ogb.addGrabPoint(gb0);
                return true;
            }
        }
        catch (ClassCastException cce) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected boolean unsyncEnclosed() {
        try {
            OffsetGrabPoint gb0 = (OffsetGrabPoint)this.polyGrabPoints.get(0);
            OffsetGrabPoint ogb = (OffsetGrabPoint)this.polyGrabPoints.get(this.polyGrabPoints.size() - 1);
            if (gb0.getX() == ogb.getX() && gb0.getY() == ogb.getY()) {
                gb0.removeGrabPoint(ogb);
                ogb.removeGrabPoint(gb0);
                return true;
            }
        }
        catch (ClassCastException cce) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public void enclose(boolean e) {
        this.setEnclosed(e);
        if (this.polyGrabPoints == null) {
            return;
        }
        OffsetGrabPoint gb0 = (OffsetGrabPoint)this.polyGrabPoints.get(0);
        if (e) {
            if (!this.syncEnclosed()) {
                OffsetGrabPoint ogb = new OffsetGrabPoint(gb0.getX(), gb0.getY());
                this.addPoint(ogb);
                this.syncEnclosed();
                this.repaint();
            }
        } else if (this.unsyncEnclosed()) {
            this.deletePoint();
            this.repaint();
        }
    }

    public void setEnclosed(boolean set) {
        this.manualEnclosed = set;
    }

    public boolean isEnclosed() {
        return this.manualEnclosed;
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 1;
        int lineType = 3;
        if (ga != null) {
            renderType = ga.getRenderType();
            lineType = ga.getLineType();
        }
        if (Debug.debugging("eomg")) {
            Debug.output("EditableOMPoly.createGraphic(): rendertype = " + renderType);
        }
        if (lineType == 0) {
            lineType = 3;
            ga.setLineType(3);
        }
        this.poly = (OMPoly)this.createGraphic(renderType, lineType);
        if (ga != null) {
            ga.setRenderType(this.poly.getRenderType());
            ga.setTo(this.poly, true);
        }
    }

    public OMGraphic createGraphic(int renderType, int lineType) {
        OMPoly g = null;
        switch (renderType) {
            case 1: {
                g = new OMPoly(new float[0], 1, lineType);
                break;
            }
            case 3: {
                g = new OMPoly(90.0f, -180.0f, new int[0], 0);
                break;
            }
            default: {
                g = new OMPoly(new int[0]);
            }
        }
        g.setDoShapes(true);
        return g;
    }

    public OMGraphic getGraphic() {
        return this.poly;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
        this.gpm = null;
    }

    public GrabPoint getMovingPoint(MouseEvent e) {
        GrabPoint gb = super.getMovingPoint(e);
        int lastPointIndex = this.polyGrabPoints.size() - 1;
        if (gb != null && gb == (GrabPoint)this.polyGrabPoints.get(lastPointIndex) && this.isEnclosed()) {
            gb = (GrabPoint)this.polyGrabPoints.get(0);
            this.setMovingPoint(gb);
        }
        return gb;
    }

    public void assertGrabPoints() {
        if (this.polyGrabPoints == null) {
            this.polyGrabPoints = new ArrayList();
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
        }
    }

    protected GrabPoint createGrabPoint(int x, int y, int index, int last) {
        if (index == 0 || index == last && this.isEnclosed()) {
            return new OffsetGrabPoint(x, y);
        }
        return new GrabPoint(x, y);
    }

    public void setGrabPoints(OMGraphic graphic) {
        if (!(graphic instanceof OMPoly)) {
            return;
        }
        this.assertGrabPoints();
        this.polyGrabPoints.clear();
        this.gpo.clear();
        OMPoly poly = (OMPoly)graphic;
        boolean ntr = poly.getNeedToRegenerate();
        int renderType = poly.getRenderType();
        Point p = new Point();
        if (!ntr) {
            if (renderType == 1) {
                Debug.message("eomg", "EditableOMPoly: modifying lat/lon line");
                if (this.projection != null) {
                    float[] ll = poly.getLatLonArray();
                    OffsetGrabPoint gb = null;
                    for (int i = 0; i < ll.length; i += 2) {
                        this.projection.forward(ll[i], ll[i + 1], p, true);
                        gb = new OffsetGrabPoint((int)p.getX(), (int)p.getY());
                        this.polyGrabPoints.add(gb);
                    }
                }
            } else if (renderType == 3) {
                Debug.message("eomg", "EditableOMPoly: modifying offset poly");
                int npts = poly.xs.length;
                if (this.projection != null) {
                    this.projection.forward(poly.lat, poly.lon, p, true);
                    this.gpo.set((int)p.getX(), (int)p.getY());
                    if (poly.coordMode == 0) {
                        for (int i = 0; i < npts; ++i) {
                            int x = poly.xs[i] + p.x;
                            int y = poly.ys[i] + p.y;
                            OffsetGrabPoint gb = new OffsetGrabPoint(x, y);
                            this.polyGrabPoints.add(gb);
                        }
                    } else {
                        int lastX = p.x;
                        int lastY = p.y;
                        for (int i = 0; i < npts; ++i) {
                            int x = poly.xs[i] + lastX;
                            int y = poly.ys[i] + lastY;
                            OffsetGrabPoint gb = new OffsetGrabPoint(x, y);
                            this.polyGrabPoints.add(gb);
                            lastX += x;
                            lastY += y;
                        }
                    }
                }
            } else {
                int npts = poly.xs.length;
                Debug.message("eomg", "EditableOMPoly: modifying x/y poly");
                for (int i = 0; i < npts; ++i) {
                    OffsetGrabPoint gb = new OffsetGrabPoint(poly.xs[i], poly.ys[i]);
                    this.polyGrabPoints.add(gb);
                }
            }
            this.setEnclosed(this.syncEnclosed() || this.isEnclosed());
            this.addPolyGrabPointsToOGP(this.gpo);
        } else {
            Debug.message("eomg", "EditableOMPoly.setGrabPoints: graphic needs to be regenerated ");
        }
    }

    public void setGrabPoints() {
        GrabPoint gb;
        int i;
        LatLonPoint llp = new LatLonPoint();
        int renderType = this.poly.getRenderType();
        if (renderType == 1) {
            if (this.projection != null) {
                float[] floats = new float[this.polyGrabPoints.size() * 2];
                for (i = 0; i < this.polyGrabPoints.size(); ++i) {
                    gb = (GrabPoint)this.polyGrabPoints.get(i);
                    this.projection.inverse(gb.getX(), gb.getY(), llp);
                    floats[2 * i] = llp.radlat_;
                    floats[2 * i + 1] = llp.radlon_;
                }
                this.poly.setLocation(floats, 1);
            } else {
                Debug.message("eomg", "EditableOMPoly.setGrabPoints: projection is null, can't figure out LATLON points for poly.");
            }
        } else if (renderType == 3) {
            if (this.projection != null) {
                this.projection.inverse(this.gpo.getX(), this.gpo.getY(), llp);
            } else {
                Debug.message("eomg", "EditableOMPoly.setGrabPoints: projection is null, can't figure out LATLON points for poly offset.");
            }
        }
        if (renderType == 2 || renderType == 3) {
            int[] ints = new int[this.polyGrabPoints.size() * 2];
            if (renderType == 3 && this.gpo != null) {
                GrabPoint previous = this.gpo;
                for (i = 0; i < this.polyGrabPoints.size(); ++i) {
                    gb = (GrabPoint)this.polyGrabPoints.get(i);
                    if (this.poly.coordMode == 1) {
                        ints[2 * i] = gb.getX() - previous.getX();
                        ints[2 * i + 1] = gb.getY() - previous.getY();
                        previous = gb;
                        continue;
                    }
                    ints[2 * i] = gb.getX() - this.gpo.getX();
                    ints[2 * i + 1] = gb.getY() - this.gpo.getY();
                }
                this.poly.setLocation(llp.radlat_, llp.radlon_, 1, ints);
            } else {
                for (i = 0; i < this.polyGrabPoints.size(); ++i) {
                    gb = (GrabPoint)this.polyGrabPoints.get(i);
                    ints[2 * i] = gb.getX();
                    ints[2 * i + 1] = gb.getY();
                }
                this.poly.setLocation(ints);
            }
        }
    }

    public int addMovingPoint(int x, int y) {
        int position = this.addPoint(x, y);
        this.setMovingPoint((GrabPoint)this.polyGrabPoints.get(position));
        return position;
    }

    public int addPoint(int x, int y) {
        return this.addPoint(x, y, Integer.MAX_VALUE);
    }

    public int addPoint(int x, int y, int position) {
        return this.addPoint(new OffsetGrabPoint(x, y), position);
    }

    public int addPoint(GrabPoint gp) {
        return this.addPoint(gp, Integer.MAX_VALUE);
    }

    public int addPoint(GrabPoint gp, int position) {
        if (gp == null) {
            return -1;
        }
        int x = gp.getX();
        int y = gp.getY();
        int renderType = this.poly.getRenderType();
        if (renderType == 1) {
            Debug.message("eomg", "EditableOMPoly: adding point to lat/lon poly");
            if (this.projection != null) {
                float[] ll = this.poly.getLatLonArray();
                int actualPosition = position == Integer.MAX_VALUE ? ll.length : position * 2;
                LatLonPoint llpnt = this.projection.inverse(x, y);
                if (Debug.debugging("eomp")) {
                    Debug.output("EditableOMPoly: adding point to lat/lon poly at " + x + ", " + y + ": " + llpnt + ", at the end of ");
                    for (int j = 0; j < ll.length; j += 2) {
                        Debug.output(ll[j] + ", " + ll[j + 1]);
                    }
                }
                float[] newll = new float[ll.length + 2];
                if (actualPosition >= ll.length) {
                    if (ll.length != 0) {
                        System.arraycopy(ll, 0, newll, 0, ll.length);
                    }
                    newll[ll.length] = llpnt.radlat_;
                    newll[ll.length + 1] = llpnt.radlon_;
                    position = ll.length / 2;
                } else if (actualPosition <= 0) {
                    System.arraycopy(ll, 0, newll, 2, ll.length);
                    newll[0] = llpnt.radlat_;
                    newll[1] = llpnt.radlon_;
                    position = 0;
                } else {
                    newll[actualPosition] = llpnt.radlat_;
                    newll[actualPosition + 1] = llpnt.radlon_;
                    System.arraycopy(ll, 0, newll, 0, actualPosition);
                    System.arraycopy(ll, actualPosition, newll, actualPosition + 2, ll.length - actualPosition);
                }
                this.poly.setLocation(newll, 1);
            }
        } else if (renderType == 2) {
            Debug.message("eomg", "EditableOMPoly: adding point to x/y poly");
            int currentLength = this.poly.xs.length;
            int[] newxs = new int[currentLength + 1];
            int[] newys = new int[currentLength + 1];
            if (position >= currentLength) {
                System.arraycopy(this.poly.xs, 0, newxs, 0, currentLength);
                System.arraycopy(this.poly.ys, 0, newys, 0, currentLength);
                newxs[currentLength] = x;
                newys[currentLength] = y;
                position = currentLength;
            } else if (position <= 0) {
                System.arraycopy(this.poly.xs, 0, newxs, 1, currentLength);
                System.arraycopy(this.poly.ys, 0, newys, 1, currentLength);
                newxs[0] = x;
                newys[0] = y;
                position = 0;
            } else {
                newxs[position] = x;
                newys[position] = y;
                System.arraycopy(this.poly.xs, 0, newxs, 0, position);
                System.arraycopy(this.poly.xs, position, newxs, position + 1, currentLength - position);
                System.arraycopy(this.poly.ys, 0, newys, 0, position);
                System.arraycopy(this.poly.ys, position, newys, position + 1, currentLength - position);
            }
            this.poly.setLocation(newxs, newys);
        } else {
            int offsetY;
            int offsetX;
            Debug.message("eomg", "EditableOMPoly: adding point to offset poly");
            int currentLength = this.poly.xs.length;
            int[] newxs = new int[currentLength + 1];
            int[] newys = new int[currentLength + 1];
            if (position >= currentLength) {
                position = currentLength;
                System.arraycopy(this.poly.xs, 0, newxs, 0, currentLength);
                System.arraycopy(this.poly.ys, 0, newys, 0, currentLength);
            } else if (position <= 0) {
                position = 0;
                System.arraycopy(this.poly.xs, 0, newxs, 1, currentLength);
                System.arraycopy(this.poly.ys, 0, newys, 1, currentLength);
            } else {
                System.arraycopy(this.poly.xs, 0, newxs, 0, position);
                System.arraycopy(this.poly.xs, position, newxs, position + 1, currentLength - position);
                System.arraycopy(this.poly.ys, 0, newys, 0, position);
                System.arraycopy(this.poly.ys, position, newys, position + 1, currentLength - position);
            }
            if (this.gpo.getX() == -1 && this.gpo.getY() == -1) {
                offsetX = this.projection.getWidth() / 2;
                offsetY = this.projection.getHeight() / 2;
            } else {
                offsetX = this.gpo.getX();
                offsetY = this.gpo.getY();
            }
            if (this.poly.coordMode == 0 || position == 0) {
                newxs[position] = x - offsetX;
                newys[position] = y - offsetY;
            } else {
                newxs[position] = x - offsetX - newxs[position - 1];
                newys[position] = y - offsetY - newys[position - 1];
            }
            if (position == 0) {
                LatLonPoint llpnt = this.projection.inverse(offsetX, offsetY);
                this.poly.lat = llpnt.radlat_;
                this.poly.lon = llpnt.radlon_;
            }
            this.poly.setLocation(this.poly.lat, this.poly.lon, 1, newxs, newys);
        }
        OMArrowHead omah = this.poly.getArrowHead();
        this.poly.setArrowHead(null);
        this.poly.regenerate(this.projection);
        this.poly.setArrowHead(omah);
        this.polyGrabPoints.add(position, gp);
        if (this.gpo != null) {
            this.gpo.addGrabPoint(gp);
        }
        return position;
    }

    public void deletePoint() {
        this.deletePoint(Integer.MAX_VALUE);
    }

    public void deletePoint(int position) {
        int renderType = this.poly.getRenderType();
        boolean needToHookUp = false;
        if (position <= 0 && this.isEnclosed()) {
            this.enclose(false);
            needToHookUp = true;
        }
        if (renderType == 1) {
            Debug.message("eomg", "EditableOMPoly: adding point to lat/lon poly");
            if (this.projection != null) {
                int actualPosition;
                float[] ll = this.poly.getLatLonArray();
                float[] newll = new float[ll.length - 2];
                int n = actualPosition = position == Integer.MAX_VALUE ? ll.length : position * 2;
                if (actualPosition >= ll.length) {
                    System.arraycopy(ll, 0, newll, 0, ll.length - 2);
                    position = (ll.length - 2) / 2;
                } else if (actualPosition <= 0) {
                    System.arraycopy(ll, 2, newll, 0, ll.length - 2);
                    position = 0;
                } else {
                    System.arraycopy(ll, 0, newll, 0, actualPosition);
                    System.arraycopy(ll, actualPosition + 2, newll, actualPosition, ll.length - actualPosition - 2);
                }
                this.poly.setLocation(newll, 1);
            }
        } else {
            Debug.message("eomg", "EditableOMPoly: adding point to x/y or offset poly");
            int currentLength = this.poly.xs.length;
            int[] newxs = new int[currentLength - 1];
            int[] newys = new int[currentLength - 1];
            if (position >= currentLength) {
                System.arraycopy(this.poly.xs, 0, newxs, 0, currentLength - 1);
                System.arraycopy(this.poly.ys, 0, newys, 0, currentLength - 1);
                position = currentLength - 1;
            } else if (position <= 0) {
                System.arraycopy(this.poly.xs, 1, newxs, 0, currentLength - 1);
                System.arraycopy(this.poly.ys, 1, newys, 0, currentLength - 1);
                position = 0;
            } else {
                System.arraycopy(this.poly.xs, 0, newxs, 0, position);
                System.arraycopy(this.poly.xs, position + 1, newxs, position, currentLength - position - 1);
                System.arraycopy(this.poly.ys, 0, newys, 0, position);
                System.arraycopy(this.poly.ys, position + 1, newys, position, currentLength - position - 1);
            }
            if (this.poly.getRenderType() == 3) {
                this.poly.setLocation(this.poly.lat, this.poly.lon, 1, newxs, newys);
            } else {
                this.poly.setLocation(newxs, newys);
            }
        }
        if (this.projection != null) {
            this.poly.regenerate(this.projection);
        }
        GrabPoint gp = (GrabPoint)this.polyGrabPoints.remove(position);
        if (this.gpo != null && gp != null) {
            this.gpo.removeGrabPoint(gp);
        }
        if (needToHookUp) {
            this.enclose(true);
        }
    }

    public void move(MouseEvent e) {
        if (this.poly.getRenderType() == 3) {
            this.gpm = new OffsetGrabPoint(e.getX(), e.getY());
            this.gpm.clear();
        } else {
            this.gpm = this.gpo;
            this.gpm.clear();
            this.gpm.set(e.getX(), e.getY());
        }
        this.addPolyGrabPointsToOGP(this.gpm);
        this.movingPoint = this.gpm;
    }

    protected void addPolyGrabPointsToOGP(OffsetGrabPoint ogp) {
        if (ogp == null) {
            return;
        }
        int count = 0;
        Iterator gps = this.polyGrabPoints.iterator();
        while (gps.hasNext()) {
            GrabPoint gb = (GrabPoint)gps.next();
            ogp.addGrabPoint(gb);
            ++count;
        }
        ogp.updateOffsets();
    }

    public boolean generate(Projection proj) {
        Debug.message("eomg", "EditableOMPoly.generate()");
        if (this.poly != null) {
            this.poly.generate(proj);
        }
        Iterator gps = this.polyGrabPoints.iterator();
        while (gps.hasNext()) {
            GrabPoint gb = (GrabPoint)gps.next();
            if (gb == null) continue;
            gb.generate(proj);
        }
        if (this.gpo != null) {
            this.gpo.generate(proj);
            this.gpo.updateOffsets();
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMPoly.regenerate()");
        if (this.poly != null) {
            this.poly.generate(proj);
            this.setGrabPoints(this.poly);
        }
        Iterator gps = this.polyGrabPoints.iterator();
        while (gps.hasNext()) {
            GrabPoint gb = (GrabPoint)gps.next();
            if (gb == null) continue;
            gb.generate(proj);
        }
        if (this.gpo != null) {
            this.gpo.generate(proj);
            this.gpo.updateOffsets();
        }
    }

    public void render(Graphics graphics) {
        Debug.message("eomg", "EditableOMPoly.render()");
        State state = this.getStateMachine().getState();
        if (this.poly == null || state instanceof PolyUndefinedState) {
            Debug.message("eomg", "EditableOMPoly.render: null or undefined poly.");
            return;
        }
        this.poly.setVisible(true);
        this.poly.render(graphics);
        this.poly.setVisible(false);
        if (state instanceof GraphicSelectedState || state instanceof PolyAddNodeState || state instanceof PolyDeleteNodeState) {
            Iterator gps = this.polyGrabPoints.iterator();
            while (gps.hasNext()) {
                GrabPoint gb = (GrabPoint)gps.next();
                if (gb == null) continue;
                gb.setVisible(true);
                this.poly.render(graphics);
                gb.render(graphics);
                gb.setVisible(false);
            }
        }
        if ((state instanceof GraphicSelectedState || state instanceof GraphicEditState) && this.gpo != null && this.poly.getRenderType() == 3) {
            this.gpo.setVisible(true);
            this.gpo.render(graphics);
            this.gpo.setVisible(false);
        }
    }

    public boolean setGrabPoints(GrabPoint[] points) {
        this.gPoints = new GrabPoint[points.length + 1];
        System.arraycopy(this.gPoints, 0, points, 0, points.length);
        this.gPoints[points.length] = this.gpo;
        return true;
    }

    public GrabPoint[] getGrabPoints() {
        int size = this.polyGrabPoints.size();
        if (this.gPoints.length != size + 1 || size > 0 && !this.gPoints[0].equals(this.polyGrabPoints.get(0))) {
            Debug.message("eomg", "EditableOMPoly.getGrabPoints(): recreating grab points");
            this.gPoints = new GrabPoint[size + 1];
            int counter = 0;
            Iterator obj = this.polyGrabPoints.iterator();
            while (obj.hasNext()) {
                this.gPoints[counter++] = (GrabPoint)obj.next();
            }
            this.gPoints[counter] = this.gpo;
        }
        return this.gPoints;
    }

    public boolean setGrabPoint(GrabPoint gb, int index) {
        if (index == OFFSET_POINT_INDEX) {
            this.gpo = (OffsetGrabPoint)gb;
            return true;
        }
        return super.setGrabPoint(gb, index);
    }

    public int whichGrabPoint(GrabPoint gp) {
        GrabPoint[] points = this.getGrabPoints();
        for (int i = 0; i < points.length; ++i) {
            if (gp != points[i]) continue;
            if (gp == this.gpo) {
                return OFFSET_POINT_INDEX;
            }
            return i;
        }
        return points.length;
    }

    public GrabPoint getGrabPoint(int index) {
        if (index == OFFSET_POINT_INDEX) {
            return this.gpo;
        }
        return super.getGrabPoint(index);
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMPoly.getGUI");
        if (graphicAttributes != null) {
            JMenu ahm = this.getArrowHeadMenu();
            graphicAttributes.setLineMenuAdditions(new JMenu[]{ahm});
            Component gaGUI = graphicAttributes.getGUI();
            ((JComponent)gaGUI).add(this.getPolyGUI());
            return gaGUI;
        }
        return this.getPolyGUI();
    }

    public void enablePolygonButton(boolean enable) {
        if (this.polygonButton != null) {
            this.polygonButton.setEnabled(enable);
        }
    }

    public void enablePolygonEditButtons(boolean enable) {
        if (this.addButton != null) {
            this.addButton.setEnabled(enable);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(enable);
        }
    }

    public JToolBar getPolyGUI() {
        return this.getPolyGUI(true, true, true);
    }

    public JToolBar getPolyGUI(boolean includeEnclose, boolean includeAdd, boolean includeDelete) {
        ImageIcon imageIcon;
        URL url;
        GridBagToolBar buttonBox = new GridBagToolBar();
        if (this.polygonButton == null) {
            url = this.getImageURL("enclosepoly.gif");
            imageIcon = new ImageIcon(url);
            this.polygonButton = new JToggleButton(imageIcon);
            this.polygonButton.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMPoly == null ? (class$com$bbn$openmap$omGraphics$EditableOMPoly = EditableOMPoly.class$("com.bbn.openmap.omGraphics.EditableOMPoly")) : class$com$bbn$openmap$omGraphics$EditableOMPoly, "polygonButton.tooltip", "Automatically link first and last nodes"));
        }
        this.polygonButton.setSelected(this.isEnclosed());
        this.polygonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditableOMPoly.this.getStateMachine().getState() instanceof GraphicSelectedState) {
                    EditableOMPoly.this.enclose(((JToggleButton)e.getSource()).isSelected());
                } else {
                    EditableOMPoly.this.setEnclosed(((JToggleButton)e.getSource()).isSelected());
                }
            }
        });
        if (includeEnclose) {
            ((Container)buttonBox).add(this.polygonButton);
        }
        if (this.addButton == null) {
            url = this.getImageURL("addpoint.gif");
            imageIcon = new ImageIcon(url);
            this.addButton = new JButton(imageIcon);
            this.addButton.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMPoly == null ? (class$com$bbn$openmap$omGraphics$EditableOMPoly = EditableOMPoly.class$("com.bbn.openmap.omGraphics.EditableOMPoly")) : class$com$bbn$openmap$omGraphics$EditableOMPoly, "addButton.tooltip", "Add a node to the polygon"));
        }
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PolyStateMachine)EditableOMPoly.this.stateMachine).setAddNode();
                EditableOMPoly.this.enablePolygonEditButtons(false);
            }
        });
        this.addButton.setEnabled(false);
        if (includeAdd) {
            ((Container)buttonBox).add(this.addButton);
        }
        if (this.deleteButton == null) {
            url = this.getImageURL("deletepoint.gif");
            imageIcon = new ImageIcon(url);
            this.deleteButton = new JButton(imageIcon);
            this.deleteButton.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMPoly == null ? (class$com$bbn$openmap$omGraphics$EditableOMPoly = EditableOMPoly.class$("com.bbn.openmap.omGraphics.EditableOMPoly")) : class$com$bbn$openmap$omGraphics$EditableOMPoly, "deleteButton.tooltip", "Delete a node from the polygon"));
        }
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PolyStateMachine)EditableOMPoly.this.stateMachine).setDeleteNode();
                EditableOMPoly.this.enablePolygonEditButtons(false);
            }
        });
        this.deleteButton.setEnabled(false);
        if (includeDelete) {
            ((Container)buttonBox).add(this.deleteButton);
        }
        return buttonBox;
    }

    public URL getImageURL(String imageName) {
        return (class$com$bbn$openmap$omGraphics$EditableOMPoly == null ? (class$com$bbn$openmap$omGraphics$EditableOMPoly = EditableOMPoly.class$("com.bbn.openmap.omGraphics.EditableOMPoly")) : class$com$bbn$openmap$omGraphics$EditableOMPoly).getResource(imageName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

