/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.omGraphics.ColorRect;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorTracker
implements ActionListener,
ChangeListener,
Serializable {
    ColorRect preview;
    JColorChooser chooser;
    Color color;
    int transparency;
    private I18n i18n = Environment.getI18n();
    boolean isOK = false;
    static /* synthetic */ Class class$com$bbn$openmap$omGraphics$ColorTracker;

    public ColorTracker(JColorChooser c) {
        this.chooser = c;
        this.preview = new ColorRect(this.chooser.getColor());
    }

    public void actionPerformed(ActionEvent e) {
        this.color = this.chooser.getColor();
        this.setPreviewColor(this.color);
        this.isOK = true;
    }

    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof ColorSelectionModel)) {
            return;
        }
        this.setPreviewColor(((ColorSelectionModel)e.getSource()).getSelectedColor());
    }

    public void setPreviewColor(Color c) {
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.transparency);
        this.preview.setColor(c);
        this.preview.repaint();
        this.color = c;
    }

    public Color getColor() {
        if (!this.isOK) {
            return null;
        }
        if (this.color != null) {
            this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.transparency);
        }
        return this.color;
    }

    public JComponent getTransparancyAdjustment(int initialValue) {
        this.transparency = initialValue;
        this.setPreviewColor(this.preview.getColor());
        JPanel slidePanel = new JPanel();
        Box slideBox = Box.createHorizontalBox();
        JSlider opaqueSlide = new JSlider(0, 0, 255, initialValue);
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        String opaqueLabel = this.i18n.get(class$com$bbn$openmap$omGraphics$ColorTracker == null ? (class$com$bbn$openmap$omGraphics$ColorTracker = ColorTracker.class$("com.bbn.openmap.omGraphics.ColorTracker")) : class$com$bbn$openmap$omGraphics$ColorTracker, "opaque", "opaque");
        String clearLabel = this.i18n.get(class$com$bbn$openmap$omGraphics$ColorTracker == null ? (class$com$bbn$openmap$omGraphics$ColorTracker = ColorTracker.class$("com.bbn.openmap.omGraphics.ColorTracker")) : class$com$bbn$openmap$omGraphics$ColorTracker, "clear", "clear");
        if (opaqueLabel == null || opaqueLabel.length() == 0) {
            dict.put(new Integer(126), new JLabel(clearLabel));
        } else {
            dict.put(new Integer(50), new JLabel(clearLabel));
            dict.put(new Integer(200), new JLabel(opaqueLabel));
        }
        opaqueSlide.setLabelTable(dict);
        opaqueSlide.setPaintLabels(true);
        opaqueSlide.setMajorTickSpacing(50);
        opaqueSlide.setPaintTicks(true);
        opaqueSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (slider.getValueIsAdjusting()) {
                    ColorTracker.this.transparency = slider.getValue();
                }
                ColorTracker.this.setPreviewColor(ColorTracker.this.preview.getColor());
            }
        });
        this.preview.setPreferredSize(new Dimension(100, slideBox.getHeight()));
        slideBox.add(this.preview);
        slideBox.add(Box.createGlue());
        slideBox.add(opaqueSlide);
        slideBox.add(Box.createGlue());
        slidePanel.add(slideBox);
        slidePanel.setSize(new Dimension(50, 50));
        return slidePanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

