/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;

public class VPFFeatureCache
extends CacheHandler {
    public VPFFeatureCache() {
    }

    public VPFFeatureCache(int maxSize) {
        super(maxSize);
    }

    protected synchronized void addToCachedList(OMGraphic omg, String featureType, PrimitiveTable pt, String type) {
        String key = VPFFeatureCache.createTableCacheKey(featureType, pt.getTileDirectory().getPath());
        FeatureCacheGraphicList omgl = (FeatureCacheGraphicList)this.get(key);
        omgl.add(omg);
    }

    public static String createTableCacheKey(String featureType, String tilePath) {
        return featureType + "-" + tilePath;
    }

    public synchronized boolean loadCachedGraphicList(String featureType, String tilePath, OMGraphicList requestor) {
        String key = VPFFeatureCache.createTableCacheKey(featureType, tilePath);
        boolean exists = this.searchCache(key) != null;
        FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)this.get(key, VPFUtil.getTypeForFeatureCode(featureType));
        if (fcgl.getFeatureName() == null) {
            fcgl.setFeatureName(featureType);
        }
        requestor.add(fcgl);
        return exists;
    }

    public synchronized boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile, OMGraphicList requestor) {
        if (this.loadCachedGraphicList(currentFeature, currentTile.getPath(), requestor)) {
            if (Debug.debugging("vpf.cache")) {
                Debug.output("VPFFeatureCache: Loaded Cached List: " + VPFFeatureCache.createTableCacheKey(currentFeature, currentTile.getPath()));
            }
            return false;
        }
        return true;
    }

    public Object get(String key, String featureType) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(key, featureType);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public CacheObject load(String key) {
        return this.load(key, null);
    }

    public CacheObject load(String key, String featureType) {
        if (key != null) {
            return new VPFListCacheObject(key, FeatureCacheGraphicList.createForType(featureType));
        }
        return null;
    }

    public static class VPFListCacheObject
    extends CacheObject {
        public VPFListCacheObject(String id, OMGraphicList obj) {
            super(id, obj);
        }

        public void finalize() {
            ((OMGraphicList)this.obj).clear();
        }
    }
}

