/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import java.util.ArrayList;
import java.util.List;

public class NodeTable
extends PrimitiveTable {
    private final int coordColumn;
    private final int firstEdgeColumn;
    private final int containingFaceColumn;
    private final boolean isEntityNode;

    public NodeTable(CoverageTable cov, TileDirectory tile, boolean isEntityNode) throws FormatException {
        super(cov, tile, isEntityNode ? "end" : "cnd");
        this.isEntityNode = isEntityNode;
        this.coordColumn = this.whatColumn("coordinate");
        if (this.coordColumn == -1) {
            throw new FormatException("nodetable couldn't get coordinate column");
        }
        this.firstEdgeColumn = this.whatColumn("first_edge");
        this.containingFaceColumn = this.whatColumn("containing_face");
    }

    public int getFirstEdgeColumn() {
        return this.firstEdgeColumn;
    }

    public int getContainingFaceColumn() {
        return this.containingFaceColumn;
    }

    public void drawTile(VPFGraphicWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        float ll1lat = ll1.getLatitude();
        float ll1lon = ll1.getLongitude();
        float ll2lat = ll2.getLatitude();
        float ll2lon = ll2.getLongitude();
        try {
            ArrayList node = new ArrayList();
            while (this.parseRow(node)) {
                CoordFloatString coords = (CoordFloatString)node.get(this.coordColumn);
                float lat = coords.getYasFloat(0);
                float lon = coords.getXasFloat(0);
                if (!(lat > ll2lat) || !(lat < ll1lat) || !(lon > ll1lon) || !(lon < ll2lon)) continue;
                warehouse.createNode(this.covtable, this, node, lat, lon, this.isEntityNode);
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    public void drawFeature(VPFFeatureWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2, List node, String featureType) {
        if (warehouse == null) {
            return;
        }
        float ll1lat = ll1.getLatitude();
        float ll1lon = ll1.getLongitude();
        float ll2lat = ll2.getLatitude();
        float ll2lon = ll2.getLongitude();
        CoordFloatString coords = (CoordFloatString)node.get(this.coordColumn);
        float lat = coords.getYasFloat(0);
        float lon = coords.getXasFloat(0);
        if (lat > ll2lat && lat < ll1lat && lon > ll1lon && lon < ll2lon) {
            warehouse.createNode(this.covtable, this, node, lat, lon, this.isEntityNode, featureType);
        }
    }
}

