/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape.areas;

import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.util.Debug;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.net.URL;

public class PoliticalArea {
    public final String id;
    public String name = null;
    protected OMGeometryList geometry;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    public PoliticalArea(String identifier) {
        this(null, identifier);
    }

    public PoliticalArea(String name, String identifier) {
        this.id = identifier;
        this.name = name;
        this.geometry = new OMGeometryList();
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
        da.setTo(this.geometry);
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void setFillPaint(Paint c) {
        this.drawingAttributes.setFillPaint(c);
        this.drawingAttributes.setTo(this.geometry);
    }

    public Paint getFillPaint() {
        return this.drawingAttributes.getFillPaint();
    }

    public void setFillPattern(URL fillPatternURL) {
        TexturePaint texture = null;
        try {
            if (fillPatternURL != null) {
                BufferedImage bi = BufferedImageHelper.getBufferedImage(fillPatternURL, 0, 0, -1, -1);
                texture = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
            }
        }
        catch (InterruptedException ie) {
            Debug.error("PoliticalArea.setFillPattern(): error getting texture image - \n" + ie);
        }
        this.setFillPattern(texture);
    }

    public void setFillPattern(TexturePaint texture) {
        this.drawingAttributes.setFillPaint(texture);
        this.drawingAttributes.setTo(this.geometry);
    }

    public TexturePaint getFillPattern() {
        return this.drawingAttributes.getFillPattern();
    }

    public void setLinePaint(Paint c) {
        this.drawingAttributes.setLinePaint(c);
        this.drawingAttributes.setTo(this.geometry);
    }

    public Paint getLinePaint() {
        return this.drawingAttributes.getLinePaint();
    }

    public void setSelectPaint(Paint c) {
        this.drawingAttributes.setSelectPaint(c);
        this.drawingAttributes.setTo(this.geometry);
    }

    public Paint getSelectPaint() {
        return this.drawingAttributes.getSelectPaint();
    }

    public OMGeometryList getGeometry() {
        return this.geometry;
    }

    public void setGeometry(OMGeometryList v) {
        this.geometry = v;
        this.drawingAttributes.setTo(v);
    }

    public void addGraphic(OMGraphic g) {
        this.geometry.add((OMGeometry)g);
        this.drawingAttributes.setTo(g);
    }
}

