/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkBoundingPoly;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkLayer;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.UnknownHostException;

public class BufferedLinkLayer
extends LinkLayer {
    public BufferedLinkLayer() {
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    public BufferedLinkLayer(String host, int port, String propertiesURL) {
        super(host, port, propertiesURL);
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OMGraphicList prepare() {
        if (this.isCancelled()) {
            Debug.message("link", this.getName() + "|BufferedLinkLayer.prepare(): aborted.");
            return null;
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            System.err.println("Link Layer needs to be added to the MapBean before it can get graphics!");
            return new LinkOMGraphicList();
        }
        Debug.message("basic", this.getName() + "|BufferedLinkLayer.prepare(): doing it");
        OMGraphicList omGraphics = this.getList();
        if (omGraphics == null || omGraphics.size() == 0) {
            try {
                ClientLink l = this.linkManager.getLink(true);
                if (l == null) {
                    System.err.println("BufferedLinkLayer: unable to get link in prepare().");
                    return new LinkOMGraphicList();
                }
                ClientLink clientLink = l;
                synchronized (clientLink) {
                    omGraphics = this.getAllGraphics(l, projection);
                }
                this.linkManager.finLink();
            }
            catch (UnknownHostException uhe) {
                System.err.println("BufferedLinkLayer: unknown host!");
                omGraphics = new LinkOMGraphicList();
            }
            catch (IOException ioe) {
                System.err.println("BufferedLinkLayer: IOException contacting server for map request!");
                System.err.println(ioe);
                this.linkManager.resetLink();
                if (!this.quiet) {
                    this.fireRequestMessage("Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
                }
                System.err.println("BufferedLinkLayer: Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
                omGraphics = new LinkOMGraphicList();
            }
        } else {
            omGraphics.project(projection);
        }
        int size = 0;
        if (omGraphics != null) {
            size = omGraphics.size();
            if (Debug.debugging("basic")) {
                System.out.println(this.getName() + "|BufferedLinkLayer.prepare(): finished with " + size + " graphics");
            }
        } else {
            Debug.message("basic", this.getName() + "|BufferedLinkLayer.prepare(): finished with null graphics list");
        }
        return omGraphics;
    }

    protected LinkOMGraphicList getAllGraphics(ClientLink link, Projection proj) throws IOException {
        LinkGraphicList lgl;
        LinkBoundingPoly[] boundingPolys = new LinkBoundingPoly[]{new LinkBoundingPoly(-180.0f, -90.0f, 180.0f, 90.0f)};
        LinkMapRequest.write(proj.getCenter().getLatitude(), proj.getCenter().getLongitude(), proj.getScale(), proj.getHeight(), proj.getWidth(), boundingPolys, this.args, link);
        link.readAndParse(proj, this.currentGenerator);
        LinkActionRequest lar = link.getActionRequest();
        if (lar != null) {
            this.setGestureDescriptor(lar.getDescriptor());
        }
        if ((lgl = link.getGraphicList()) != null) {
            this.handleMessages(lgl.getProperties());
            return lgl.getGraphics();
        }
        Debug.message("link", "BufferedLinkLayer: getAllGraphics(): no graphic response.");
        return new LinkOMGraphicList();
    }
}

