/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.dted.DTEDConstants;
import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.dataAccess.dted.DTEDFrameCacheHandler;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DTEDFrameCacheLayer
extends OMGraphicHandlerLayer
implements ActionListener,
MapMouseListener,
Serializable,
DTEDConstants {
    protected transient DTEDFrameCacheHandler cache = new DTEDFrameCacheHandler(null);
    protected long minScale = 20000000L;
    protected boolean killCache = true;
    public static final String DTEDLevelProperty = "level";
    public static final String DTEDMinScaleProperty = "min.scale";
    public static final String DTEDKillCacheProperty = "kill.cache";
    private String level0Command = "setLevelTo0";
    private String level1Command = "setLevelTo1";
    private String level2Command = "setLevelTo2";
    DTEDLocation location = null;
    protected boolean firstProjectionWarningSent = false;
    protected Box palette = null;

    public DTEDFrameCacheLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public DTEDFrameCacheLayer(DTEDFrameCache dfc) {
        this();
        this.setFrameCache(dfc);
    }

    public void setFrameCache(DTEDFrameCache dfc) {
        if (this.cache != null) {
            this.cache.setFrameCache(dfc);
        }
    }

    public DTEDFrameCache getFrameCache() {
        if (this.cache != null) {
            return this.cache.getFrameCache();
        }
        return null;
    }

    protected void setDefaultValues() {
        this.setMaxScale(2.0E7f);
    }

    public void setProperties(Properties properties) {
        this.setProperties(null, properties);
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        this.setDtedLevel(PropUtils.intFromProperties(properties, prefix + DTEDLevelProperty, this.getDtedLevel()));
        this.cache.setProperties(prefix, properties);
    }

    public void removed(Container cont) {
        OMGraphicList rasters = this.getList();
        if (rasters != null) {
            rasters.clear();
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof DTEDFrameCache) {
            this.setFrameCache((DTEDFrameCache)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj == this.getFrameCache()) {
            this.setFrameCache(null);
        }
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList omGraphicList;
        Projection projection;
        if (this.isCancelled()) {
            Debug.message("dted", this.getName() + "|DTEDFrameCacheLayer.prepare(): aborted.");
            return null;
        }
        if (this.cache == null) {
            Debug.message("dted", this.getName() + "|DTEDFrameCacheLayer can't add anything to map because the DTEDFrameCache has not been set.");
        }
        if ((projection = this.getProjection()) == null) {
            Debug.output("DTED Layer needs to be added to the MapBean before it can draw images!");
            return new OMGraphicList();
        }
        if (!(projection instanceof EqualArc)) {
            if (!this.firstProjectionWarningSent) {
                this.fireRequestInfoLine("  DTED requires an Equal Arc projection (CADRG/LLXY) to view images.");
                Debug.output("DTEDFrameCacheLayer: DTED requires an Equal Arc projection (CADRG/LLXY) to view images.");
                this.firstProjectionWarningSent = true;
            }
            return new OMGraphicList();
        }
        Debug.message("basic", this.getName() + "|DTEDFrameCacheLayer.prepare(): doing it");
        if (Debug.debugging("dted")) {
            Debug.output(this.getName() + "|DTEDFrameCacheLayer.prepare(): " + "calling getRectangle " + " with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (projection.getScale() < this.maxScale) {
            omGraphicList = this.cache.getRectangle((EqualArc)projection);
        } else {
            this.fireRequestInfoLine("  The scale is too small for DTED viewing.");
            Debug.error("DTEDFrameCacheLayer: scale (1:" + projection.getScale() + ") is smaller than minimum (1:" + this.maxScale + ") allowed.");
            omGraphicList = new OMGraphicList();
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            Debug.message("basic", this.getName() + "|DTEDFrameCacheLayer.prepare(): finished with " + size + " graphics");
            omGraphicList.project(projection, true);
        } else {
            Debug.message("basic", this.getName() + "|DTEDFrameCacheLayer.prepare(): finished with null graphics list");
        }
        return omGraphicList;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.location != null) {
            this.location.render(g);
        }
        this.location = null;
    }

    public int getDtedLevel() {
        if (this.cache != null) {
            return this.cache.getDtedLevel();
        }
        return 0;
    }

    public void setDtedLevel(int level) {
        if (this.cache != null) {
            this.cache.setDtedLevel(level);
        }
    }

    public boolean getKillCache() {
        return this.killCache;
    }

    public void setKillCache(boolean kc) {
        this.killCache = kc;
    }

    public Component getGUI() {
        if (this.palette == null) {
            if (Debug.debugging("dted")) {
                Debug.output("DTEDFrameCacheLayer: creating DTED Palette.");
            }
            this.palette = Box.createVerticalBox();
            Box subbox1 = Box.createHorizontalBox();
            Box subbox3 = Box.createHorizontalBox();
            JPanel levelPanel = PaletteHelper.createPaletteJPanel("DTED Level");
            ButtonGroup levels = new ButtonGroup();
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DTEDFrameCacheLayer.this.cache != null) {
                        String ac = e.getActionCommand();
                        int newLevel = ac.equalsIgnoreCase(DTEDFrameCacheLayer.this.level2Command) ? 2 : (ac.equalsIgnoreCase(DTEDFrameCacheLayer.this.level1Command) ? 1 : 0);
                        DTEDFrameCacheLayer.this.setDtedLevel(newLevel);
                    }
                }
            };
            JRadioButton level0 = new JRadioButton("Level 0");
            level0.addActionListener(al);
            level0.setActionCommand(this.level0Command);
            JRadioButton level1 = new JRadioButton("Level 1");
            level1.addActionListener(al);
            level1.setActionCommand(this.level1Command);
            JRadioButton level2 = new JRadioButton("Level 2");
            level2.addActionListener(al);
            level2.setActionCommand(this.level2Command);
            levels.add(level0);
            levels.add(level1);
            levels.add(level2);
            switch (this.getDtedLevel()) {
                case 2: {
                    level2.setSelected(true);
                    break;
                }
                case 1: {
                    level1.setSelected(true);
                    break;
                }
                default: {
                    level0.setSelected(true);
                }
            }
            levelPanel.add(level0);
            levelPanel.add(level1);
            levelPanel.add(level2);
            JPanel viewPanel = PaletteHelper.createPaletteJPanel("View Type");
            viewPanel.add(this.cache.getGUI());
            JButton redraw = new JButton("Redraw DTED Layer");
            redraw.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DTEDFrameCacheLayer.this.doPrepare();
                }
            });
            subbox1.add(levelPanel);
            subbox1.add(viewPanel);
            this.palette.add(subbox1);
            subbox3.add(redraw);
            this.palette.add(subbox3);
        }
        return this.palette;
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] services = new String[]{SelectMouseMode.modeID};
        return services;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        Projection projection = this.getProjection();
        LatLonPoint ll = projection.inverse(e.getX(), e.getY());
        this.location = new DTEDLocation(e.getX(), e.getY());
        this.location.setElevation(this.cache.getElevation(ll.getLatitude(), ll.getLongitude()));
        this.location.generate(projection);
        this.repaint();
        return true;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    static class DTEDLocation {
        OMText text;
        OMRect dot;

        public DTEDLocation(int x, int y) {
            this.text = new OMText(x + 10, y, (String)null, (Font)null, 0);
            this.dot = new OMRect(x - 1, y - 1, x + 1, y + 1);
            this.text.setLinePaint(Color.red);
            this.dot.setLinePaint(Color.red);
        }

        public void setElevation(int elevation) {
            if (elevation < -100) {
                this.text.setData("No Data Here");
            } else {
                int elevation_ft = (int)((float)elevation * 3.28084f);
                this.text.setData(elevation + " m / " + elevation_ft + " ft");
            }
        }

        public void setLocation(int x, int y) {
            this.text.setX(x + 10);
            this.text.setY(y);
            this.dot.setLocation(x - 1, y - 1, x + 1, y + 1);
        }

        public void render(Graphics g) {
            this.text.render(g);
            this.dot.render(g);
        }

        public void generate(Projection proj) {
            this.text.generate(proj);
            this.dot.generate(proj);
        }
    }
}

