/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.event.OverviewMapStatusListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Properties;

public class OverviewMapAreaLayer
extends Layer
implements OverviewMapStatusListener {
    protected float overviewScale;
    protected OMPoly poly;
    protected Projection sourceMapProjection;
    protected DrawingAttributes areaAttributes = DrawingAttributes.getDefaultClone();

    public void projectionChanged(ProjectionEvent pEvent) {
        LatLonPoint tmpllp;
        int i;
        if (this.sourceMapProjection == null) {
            return;
        }
        Projection proj = pEvent.getProjection();
        this.overviewScale = proj.getScale();
        boolean cylindrical = this.sourceMapProjection instanceof Cylindrical;
        if (this.poly == null) {
            this.poly = new OMPoly();
            this.areaAttributes.setTo(this.poly);
            this.poly.setLineType(cylindrical ? 1 : 3);
        }
        ArrayList<LatLonPoint> l = new ArrayList<LatLonPoint>();
        int width = this.sourceMapProjection.getWidth();
        int height = this.sourceMapProjection.getHeight();
        float xinc = (float)width / 10.0f;
        float yinc = (float)height / 10.0f;
        LatLonPoint center = this.sourceMapProjection.getCenter();
        boolean northPoleVisible = this.isVisible(new LatLonPoint(90.0f, 0.0f));
        boolean southPoleVisible = this.isVisible(new LatLonPoint(-90.0f, 0.0f));
        for (i = 0; i <= 10; ++i) {
            tmpllp = this.sourceMapProjection.inverse((int)(xinc * (float)i), 0);
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 0; i <= 10; ++i) {
            tmpllp = this.sourceMapProjection.inverse(width, (int)(yinc * (float)i));
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 10; i >= 0; --i) {
            tmpllp = this.sourceMapProjection.inverse((int)(xinc * (float)i), height);
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 10; i >= 0; --i) {
            tmpllp = this.sourceMapProjection.inverse(0, (int)(yinc * (float)i));
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        if (!northPoleVisible && !southPoleVisible) {
            float[] llarr = new float[l.size() * 2];
            for (int i2 = 0; i2 < l.size(); ++i2) {
                int pos = i2 * 2;
                LatLonPoint llp = (LatLonPoint)l.get(i2);
                llarr[pos] = llp.radlat_;
                llarr[pos + 1] = llp.radlon_;
            }
            this.poly.setLocation(llarr, 1);
        }
        this.poly.generate(proj);
    }

    protected boolean isVisible(LatLonPoint llp) {
        boolean ret = false;
        if (this.sourceMapProjection != null && this.sourceMapProjection.isPlotable(llp)) {
            Point p = this.sourceMapProjection.forward(llp);
            double x = p.getX();
            double y = p.getY();
            if (x >= 0.0 && x <= (double)this.sourceMapProjection.getWidth() && y >= 0.0 && y <= (double)this.sourceMapProjection.getWidth()) {
                ret = true;
            }
        }
        return ret;
    }

    public void setSourceMapProjection(Projection proj) {
        this.sourceMapProjection = proj;
    }

    public void paint(Graphics g) {
        if (this.poly != null && this.overviewScale > this.sourceMapProjection.getScale()) {
            this.poly.render(g);
        }
    }

    public DrawingAttributes getAreaAttributes() {
        return this.areaAttributes;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.areaAttributes.setProperties(prefix, props);
        this.poly = null;
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.areaAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        this.areaAttributes.getPropertyInfo(props);
        return props;
    }
}

