/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.image.SunJPEGFormatter;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class MagicPlanetImageComponent
extends OMComponent
implements LayerListener,
PropertyChangeListener,
ActionListener {
    public static final String OutputDirectoryProperty = "outputDirectory";
    public static final String UpdateIntervalProperty = "updateInterval";
    public static final String InitialDelayProperty = "initialDelay";
    public static final String ScaleProperty = "scale";
    public static final String AutoUpdateProperty = "autoUpdate";
    public static final String CleanupProperty = "cleanup";
    public static final String CleanupIntervalProperty = "cleanupInterval";
    public static final String HeightProperty = "height";
    public static final String WidthProperty = "width";
    public static final String LastImageFileProperty = "lastImageFile";
    public static final String PostProcessingScriptProperty = "postProcessingScript";
    public static final String LAST_IMAGE_FILE_KEY = "MagicPlanet.lastFile";
    public static final String REPLACE_FILEPATH_MARKER = "%FILEPATH%";
    public static final String REPLACE_FILENAME_MARKER = "%FILENAME%";
    public static final String REPLACE_FILENAME_WOEXT_MARKER = "%FILENAME_WITHOUT_EXTENSION%";
    protected boolean DEBUG = false;
    protected LayerHandler layerHandler;
    protected MapBean mapBean;
    protected String outputDirectoryString;
    protected int updateInterval = 60000;
    protected int initialDelay = 0;
    protected float scale = 6.0E7f;
    protected Projection proj;
    protected Paint background;
    protected Layer[] layers;
    protected boolean autoUpdate = true;
    protected ImageFormatter imageFormatter = new SunJPEGFormatter();
    protected boolean cleanup = true;
    protected int cleanupInterval = 86400000;
    protected int height = -1;
    protected int width = -1;
    protected String lastImageFile = null;
    protected String postProcessingScript = null;
    protected Timer timer;
    static /* synthetic */ Class class$com$bbn$openmap$image$MagicPlanetImageComponent;

    public MagicPlanetImageComponent() {
        this.DEBUG = Debug.debugging("magicplanet");
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof LayerHandler) {
            this.setLayerHandler((LayerHandler)someObj);
        }
        if (someObj instanceof MapBean) {
            this.setMapBean((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof LayerHandler && someObj == this.getLayerHandler()) {
            this.setLayerHandler(null);
        }
        if (someObj instanceof MapBean && someObj == this.getMapBean()) {
            this.setMapBean(null);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        if (this.timer != null) {
            this.timer.removeActionListener(this);
            this.timer.stop();
        }
        this.timer = t;
        if (this.timer != null) {
            this.timer.addActionListener(this);
        }
    }

    public void createTimer() {
        Timer t = new Timer(this.updateInterval, null);
        t.setInitialDelay(this.initialDelay);
        this.setTimer(t);
    }

    public void setUpdateInterval(int delay) {
        this.updateInterval = delay;
        if (this.timer != null) {
            this.timer.setDelay(this.updateInterval);
            if (this.timer.isRunning()) {
                this.timer.restart();
            }
        }
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void actionPerformed(ActionEvent e) {
        this.createImage();
    }

    protected LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    protected void setLayerHandler(LayerHandler lh) {
        if (this.layerHandler != null) {
            this.layerHandler.removeLayerListener(this);
        }
        this.layerHandler = lh;
        if (this.layerHandler != null) {
            this.layerHandler.addLayerListener(this);
            this.layers = this.layerHandler.getMapLayers();
            Timer timer = this.getTimer();
            if (timer == null) {
                this.createTimer();
            }
        }
    }

    protected MapBean getMapBean() {
        return this.mapBean;
    }

    protected void setMapBean(MapBean mb) {
        if (this.mapBean != null) {
            this.mapBean.removePropertyChangeListener(this);
        }
        this.mapBean = mb;
        if (this.mapBean != null) {
            this.mapBean.addPropertyChangeListener(this);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setOutputDirectoryString(props.getProperty(prefix + OutputDirectoryProperty));
        this.setAutoUpdate(PropUtils.booleanFromProperties(props, prefix + AutoUpdateProperty, this.isAutoUpdate()));
        this.setHeight(PropUtils.intFromProperties(props, prefix + HeightProperty, this.getHeight()));
        this.setWidth(PropUtils.intFromProperties(props, prefix + WidthProperty, this.getWidth()));
        this.setScale(PropUtils.floatFromProperties(props, prefix + ScaleProperty, this.scale));
        this.setUpdateInterval(PropUtils.intFromProperties(props, prefix + UpdateIntervalProperty, this.getUpdateInterval()));
        this.setInitialDelay(PropUtils.intFromProperties(props, prefix + InitialDelayProperty, this.getInitialDelay()));
        this.setCleanup(PropUtils.booleanFromProperties(props, prefix + CleanupProperty, this.isCleanup()));
        this.setCleanupInterval(PropUtils.intFromProperties(props, prefix + CleanupIntervalProperty, this.getCleanupInterval()));
        this.setLastImageFile(props.getProperty(prefix + LastImageFileProperty, this.getLastImageFile()));
        this.setPostProcessingScript(props.getProperty(prefix + PostProcessingScriptProperty, this.getPostProcessingScript()));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + OutputDirectoryProperty, PropUtils.unnull(this.getOutputDirectoryString()));
        props.put(prefix + AutoUpdateProperty, Boolean.toString(this.isAutoUpdate()));
        props.put(prefix + HeightProperty, Integer.toString(this.getHeight()));
        props.put(prefix + WidthProperty, Integer.toString(this.getWidth()));
        props.put(prefix + ScaleProperty, Float.toString(this.getScale()));
        props.put(prefix + UpdateIntervalProperty, Integer.toString(this.getUpdateInterval()));
        props.put(prefix + InitialDelayProperty, Integer.toString(this.getInitialDelay()));
        props.put(prefix + CleanupProperty, Boolean.toString(this.isCleanup()));
        props.put(prefix + CleanupIntervalProperty, Integer.toString(this.getCleanupInterval()));
        props.put(prefix + LastImageFileProperty, PropUtils.unnull(this.getLastImageFile()));
        props.put(prefix + PostProcessingScriptProperty, PropUtils.unnull(this.getPostProcessingScript()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, OutputDirectoryProperty, 3, "Path to directory that holds created images.");
        props.put(OutputDirectoryProperty, interString);
        props.put("outputDirectory.editor", "com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, OutputDirectoryProperty, "Directory Path");
        props.put("outputDirectory.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, AutoUpdateProperty, 3, "Immediately create new images when the layers/background color changes.");
        props.put(AutoUpdateProperty, interString);
        props.put("autoUpdate.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, AutoUpdateProperty, "Auto-Update");
        props.put("autoUpdate.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, HeightProperty, 3, "Image pixel height (-1 defers to scale setting).");
        props.put(HeightProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, HeightProperty, "Image Height");
        props.put("height.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, WidthProperty, 3, "Image pixel width (-1 defers to scale setting).");
        props.put(WidthProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, WidthProperty, "Image Width");
        props.put("width.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, ScaleProperty, 3, "Scale to use for image projection (larger numbers make smaller maps).");
        props.put(ScaleProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, ScaleProperty, "Projection Scale");
        props.put("scale.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, UpdateIntervalProperty, 3, "Number of milliseconds until next image.");
        props.put(UpdateIntervalProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, UpdateIntervalProperty, "Update Interval");
        props.put("updateInterval.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, InitialDelayProperty, 3, "Number of milliseconds until the first image is created.");
        props.put(InitialDelayProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, InitialDelayProperty, "Initial Delay");
        props.put("initialDelay.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, CleanupProperty, 3, "Delete old images automatically.");
        props.put(CleanupProperty, interString);
        props.put("cleanup.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, CleanupProperty, "Delete Old Images");
        props.put("cleanup.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, CleanupIntervalProperty, 3, "Number of milliseconds to keep old images (86400000 is one day).");
        props.put(CleanupIntervalProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, CleanupIntervalProperty, "Cleanup Interval");
        props.put("cleanupInterval.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, LastImageFileProperty, 3, "Path to file containing name of last image file created.");
        props.put(LastImageFileProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, LastImageFileProperty, "Last Image Name");
        props.put("lastImageFile.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, PostProcessingScriptProperty, 3, "Script to run on the image file after it's been created.");
        props.put(PostProcessingScriptProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$image$MagicPlanetImageComponent == null ? (class$com$bbn$openmap$image$MagicPlanetImageComponent = MagicPlanetImageComponent.class$("com.bbn.openmap.image.MagicPlanetImageComponent")) : class$com$bbn$openmap$image$MagicPlanetImageComponent, PostProcessingScriptProperty, "Post Processing Script");
        props.put("postProcessingScript.label", interString);
        props.put("initProperties", "outputDirectory scale initialDelay updateInterval autoUpdate cleanup cleanupInterval height width lastImageFile postProcessingScript");
        return props;
    }

    public void setLayers(LayerEvent evt) {
        if (evt.getType() == 402) {
            this.setLayers(evt.getLayers());
        }
    }

    public void handleUpdate() {
        Timer timer = this.getTimer();
        if (timer != null && (this.isAutoUpdate() || !timer.isRunning())) {
            timer.restart();
        }
    }

    public void createImage() {
        FileOutputStream fos;
        Layer[] layers;
        if (this.isCleanup()) {
            this.cleanup(false);
        }
        String fileName = this.getFileNameForTime(System.currentTimeMillis());
        String filePath = this.getOutputDirectoryString() + "/" + fileName;
        if (this.DEBUG) {
            Debug.output("MagicPlanetImageComponent: creating image: " + filePath);
        }
        if ((layers = this.getLayers()) == null) {
            return;
        }
        ImageServer is = new ImageServer(layers, new SunJPEGFormatter());
        try {
            is.setBackground(this.getBackground());
        }
        catch (NoSuchMethodError nsme) {
            // empty catch block
        }
        byte[] imageBytes = is.createImage(this.getProj(), this.getWidth(), this.getHeight());
        try {
            fos = new FileOutputStream(filePath);
            fos.write(imageBytes);
            fos.flush();
            fos.close();
            if (this.DEBUG) {
                Debug.output("  MP: done writing image");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mapBean.setProjection(this.mapBean.getProjection());
        String launchCmd = this.generatePostProcessingCmd(this.postProcessingScript, filePath);
        if (launchCmd != null) {
            try {
                if (this.DEBUG) {
                    Debug.output("MP post processing: " + launchCmd);
                }
                Runtime.getRuntime().exec(launchCmd);
            }
            catch (IOException e) {
                System.err.println("MP post processing:  " + e);
            }
        }
        if (this.lastImageFile != null) {
            try {
                File lastImageFileFile = new File(this.lastImageFile);
                fos = new FileOutputStream(lastImageFileFile);
                fos.write(new String("MagicPlanet.lastFile=" + fileName).getBytes());
                fos.flush();
                fos.close();
                if (this.DEBUG) {
                    Debug.output("  MP: done writing file noting last image file name: " + this.lastImageFile);
                }
            }
            catch (IOException ioe) {
                Debug.error("MP: error writing file to note last image file name:\n" + ioe.getMessage());
                ioe.printStackTrace();
                this.lastImageFile = null;
            }
        }
    }

    protected String generatePostProcessingCmd(String script, String filePath) {
        String ret = null;
        if (script != null && filePath != null) {
            if (this.DEBUG) {
                Debug.output(" Replacing script: |" + script + "|" + filePath);
            }
            ret = script.replaceAll(REPLACE_FILEPATH_MARKER, filePath);
            ret = ret.replaceAll(REPLACE_FILENAME_MARKER, filePath.substring(filePath.lastIndexOf(47) + 1));
            ret = ret.replaceAll(REPLACE_FILENAME_WOEXT_MARKER, filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(46)));
            try {
                if (Environment.get("os.name").startsWith("Windows")) {
                    ret = ret.replace('/', '\\');
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (this.DEBUG) {
                Debug.output(" returning script: " + ret);
            }
        }
        return ret;
    }

    protected String getFileNameForTime(long l) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(l);
        DecimalFormat twoDigits = new DecimalFormat("00");
        String tMarker = Integer.toString(cal.get(1)) + twoDigits.format(cal.get(2) + 1) + twoDigits.format(cal.get(5)) + twoDigits.format(cal.get(11)) + twoDigits.format(cal.get(12)) + twoDigits.format(cal.get(13));
        return tMarker + "." + this.getImageFormatter().getFormatLabel().toLowerCase();
    }

    protected long getTimeForFileName(String fileName) throws NumberFormatException {
        int dotIndex = fileName.indexOf(".");
        if (dotIndex == -1) {
            throw new NumberFormatException();
        }
        if ((fileName = fileName.substring(0, dotIndex)).length() == 14) {
            int year = Integer.parseInt(fileName.substring(0, 4));
            int month = Integer.parseInt(fileName.substring(4, 6));
            int day = Integer.parseInt(fileName.substring(6, 8));
            int hour = Integer.parseInt(fileName.substring(8, 10));
            int minute = Integer.parseInt(fileName.substring(10, 12));
            int sec = Integer.parseInt(fileName.substring(12));
            return new GregorianCalendar(year, month - 1, day, hour, minute, sec).getTimeInMillis();
        }
        throw new NumberFormatException();
    }

    public void cleanup(boolean deleteAll) {
        long currentTime = System.currentTimeMillis();
        File file = new File(this.getOutputDirectoryString());
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!deleteAll) {
                    try {
                        long ft = this.getTimeForFileName(f.getName());
                        long tdiff = currentTime - ft;
                        if (this.DEBUG) {
                            Debug.output("MagicPlanetImageComponent considering deleting " + f.getName() + ", file time:" + ft + ", current time:" + currentTime + ", interval:" + this.getCleanupInterval() + ", diff:" + tdiff);
                        }
                        if (tdiff <= (long)this.getCleanupInterval()) continue;
                        if (this.DEBUG) {
                            Debug.output("   deleting...");
                        }
                        f.delete();
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                f.delete();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "MapBean.background") {
            this.setBackground((Paint)evt.getNewValue());
        }
    }

    protected void setBackground(Paint paint) {
        this.background = paint;
        this.handleUpdate();
    }

    public Paint getBackground() {
        return this.background;
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Layer[] layers) {
        this.layers = layers;
        this.handleUpdate();
    }

    public String getOutputDirectoryString() {
        return this.outputDirectoryString;
    }

    public void setOutputDirectoryString(String outputDirectoryString) {
        this.outputDirectoryString = outputDirectoryString;
        try {
            File dir = new File(outputDirectoryString);
            if (dir.exists() || dir.mkdirs()) {
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this.getMapBean(), "I can't access this directory to store the Magic Planet images in:\n" + outputDirectoryString + "\n\nPlease check the permissions for that directory.", "Problem Creating Directory", 0);
    }

    public Projection getProj() {
        return this.proj;
    }

    public void setProj(Projection proj) {
        this.proj = proj;
        this.handleUpdate();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        LatLonPoint center = new LatLonPoint();
        LLXY llxy = new LLXY(center, scale, 2000, 1000);
        Point p1 = llxy.forward(90.0f, -180.0f);
        Point p2 = llxy.forward(-90.0f, 180.0f);
        int w = (int)(p2.getX() - p1.getX());
        int h = (int)(p2.getY() - p1.getY());
        LLXY proj = new LLXY(center, scale, w, h);
        this.setProj(proj);
        if (this.DEBUG) {
            Debug.output("Created projection " + proj + " from " + p1 + ", " + p2);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public ImageFormatter getImageFormatter() {
        return this.imageFormatter;
    }

    public void setImageFormatter(ImageFormatter iFormatter) {
        this.imageFormatter = iFormatter;
        if (this.imageFormatter == null) {
            this.imageFormatter = new SunJPEGFormatter();
        }
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(int cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getLastImageFile() {
        return this.lastImageFile;
    }

    public void setLastImageFile(String lastImageFile) {
        this.lastImageFile = this.checkTrimAndNull(lastImageFile);
    }

    public String getPostProcessingScript() {
        return this.postProcessingScript;
    }

    public void setPostProcessingScript(String postProcessingScript) {
        this.postProcessingScript = this.checkTrimAndNull(postProcessingScript);
    }

    protected String checkTrimAndNull(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

