/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class OpenMapFrame
extends JFrame
implements BeanContextMembershipListener,
BeanContextChild,
PropertyConsumer {
    public static final String xProperty = "openmap.x";
    public static final String yProperty = "openmap.y";
    protected boolean useAsInternalFrameRootPaneIfNecessary = true;
    private BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);

    public OpenMapFrame() {
        this(Environment.get("openmap.Title"));
    }

    public OpenMapFrame(boolean useAsInternalFrameRootPaneIfNecessary) {
        this(Environment.get("openmap.Title"), useAsInternalFrameRootPaneIfNecessary);
    }

    public OpenMapFrame(String title) {
        this(title, true);
    }

    public OpenMapFrame(String title, boolean useAsInternalFrameRootPaneIfNecessary) {
        super(title);
        this.useAsInternalFrameRootPaneIfNecessary = useAsInternalFrameRootPaneIfNecessary;
    }

    protected void setPosition() {
        this.pack();
        int w = this.getWidth();
        int h = this.getHeight();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Debug.message("basic", "Screen dimensions are " + d);
        if (w > d.width) {
            w = d.width - d.width / 10;
        }
        if (h > d.height) {
            h = d.height - d.height / 10;
        }
        int x = Environment.getInteger(xProperty, -1);
        int y = Environment.getInteger(yProperty, -1);
        if (x < 0) {
            x = d.width / 2 - w / 2;
        }
        if (y < 0) {
            y = d.height / 2 - h / 2;
        }
        if (Debug.debugging("basic")) {
            Debug.output("Setting Frame X and Y from properties to " + x + " " + y);
        }
        this.setBounds(x, y, w, h);
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Container) {
            Debug.message("basic", "OpenMapFrame: Found a MapPanel");
            this.getContentPane().add((Container)someObj);
            JMenuBar jmb = ((MapPanel)someObj).getMapMenuBar();
            if (jmb != null) {
                Debug.message("basic", "OpenMapFrame: Got MenuBar from MapPanel");
                this.getRootPane().setJMenuBar(jmb);
            }
            this.setPosition();
            this.invalidate();
            this.setVisible(true);
        }
        if (someObj instanceof JMenuBar) {
            Debug.message("basic", "OpenMapFrame: Found a MenuBar");
            this.getRootPane().setJMenuBar((JMenuBar)someObj);
            this.invalidate();
        }
        if (someObj instanceof PropertyHandler) {
            this.setProperties(((PropertyHandler)someObj).getProperties());
        }
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapPanel && someObj instanceof Container) {
            Debug.message("basic", "OpenMapFrame: MapBean is being removed from frame");
            this.getContentPane().remove((Container)someObj);
            if (this.getJMenuBar() == ((MapPanel)someObj).getMapMenuBar()) {
                Debug.message("basic", "OpenMapFrame: Menu Bar is being removed");
                this.setJMenuBar(null);
            }
        }
        if (someObj instanceof JMenuBar && this.getJMenuBar() == (JMenuBar)someObj) {
            Debug.message("basic", "OpenMapFrame: Menu Bar is being removed");
            this.setJMenuBar(null);
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        boolean useInternalFrames;
        if (this.useAsInternalFrameRootPaneIfNecessary && (useInternalFrames = PropUtils.booleanFromProperties(setList, "openmap.UseInternalFrames", false)) && Environment.getInternalFrameDesktop() == null) {
            if (Debug.debugging("windows")) {
                Debug.output("Setting OpenMapFrame as internal pane.");
            }
            Environment.useInternalFrames(this.getRootPane());
        }
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        getList.setProperty(xProperty, "" + this.getBounds().x);
        getList.setProperty(yProperty, "" + this.getBounds().y);
        getList.setProperty("openmap.Width", Integer.toString(this.getWidth()));
        getList.setProperty("openmap.Height", Integer.toString(this.getHeight()));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.setProperty("x", "Starting X coordinate of window");
        list.setProperty("y", "Starting Y coordinate of window");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
    }

    public String getPropertyPrefix() {
        return "openmap";
    }

    public void setUseAsInternalFrameRootPaneIfNecessary(boolean val) {
        this.useAsInternalFrameRootPaneIfNecessary = true;
    }

    public boolean getUseAsInternalFrameRootPaneIfNecessary() {
        return this.useAsInternalFrameRootPaneIfNecessary;
    }
}

