/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.util.Debug;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class DMSCoordPanel
extends CoordPanel
implements Serializable {
    protected transient JTextField degLat;
    protected transient JTextField minLat;
    protected transient JTextField secLat;
    protected transient JTextField degLon;
    protected transient JTextField minLon;
    protected transient JTextField secLon;
    static /* synthetic */ Class class$com$bbn$openmap$gui$DMSCoordPanel;

    public DMSCoordPanel() {
    }

    public DMSCoordPanel(CenterSupport support) {
        super(support);
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        String locText = this.i18n.get(class$com$bbn$openmap$gui$DMSCoordPanel == null ? (class$com$bbn$openmap$gui$DMSCoordPanel = DMSCoordPanel.class$("com.bbn.openmap.gui.DMSCoordPanel")) : class$com$bbn$openmap$gui$DMSCoordPanel, "border", "Degress|Minutes|Seconds");
        this.setBorder(new TitledBorder(new EtchedBorder(), locText));
        locText = this.i18n.get(class$com$bbn$openmap$gui$DMSCoordPanel == null ? (class$com$bbn$openmap$gui$DMSCoordPanel = DMSCoordPanel.class$("com.bbn.openmap.gui.DMSCoordPanel")) : class$com$bbn$openmap$gui$DMSCoordPanel, "latlabel", "Latitude DMS: ");
        JLabel latlabel = new JLabel(locText);
        c.gridx = 0;
        gridbag.setConstraints(latlabel, c);
        this.add(latlabel);
        c.gridx = -1;
        this.degLat = new JTextField(4);
        gridbag.setConstraints(this.degLat, c);
        this.add(this.degLat);
        this.minLat = new JTextField(4);
        gridbag.setConstraints(this.minLat, c);
        this.add(this.minLat);
        this.secLat = new JTextField(4);
        gridbag.setConstraints(this.secLat, c);
        this.add(this.secLat);
        locText = this.i18n.get(class$com$bbn$openmap$gui$DMSCoordPanel == null ? (class$com$bbn$openmap$gui$DMSCoordPanel = DMSCoordPanel.class$("com.bbn.openmap.gui.DMSCoordPanel")) : class$com$bbn$openmap$gui$DMSCoordPanel, "lonlabel", "Longitude DMS: ");
        JLabel lonlabel = new JLabel(locText);
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(lonlabel, c);
        this.add(lonlabel);
        c.gridx = -1;
        this.degLon = new JTextField(4);
        gridbag.setConstraints(this.degLon, c);
        this.add(this.degLon);
        this.minLon = new JTextField(4);
        gridbag.setConstraints(this.minLon, c);
        this.add(this.minLon);
        this.secLon = new JTextField(4);
        gridbag.setConstraints(this.secLon, c);
        this.add(this.secLon);
    }

    public LatLonPoint getLatLon() {
        float seclon;
        int minlon;
        int deglon;
        float seclat;
        int minlat;
        int deglat;
        try {
            deglat = Float.valueOf(this.degLat.getText()).intValue();
            minlat = this.minLat.getText().equals("") ? 0 : Float.valueOf(this.minLat.getText()).intValue();
            this.minLat.setText(Integer.toString(Math.abs(minlat)));
            seclat = this.secLat.getText().equals("") ? 0.0f : Float.valueOf(this.secLat.getText()).floatValue();
            this.secLat.setText(Float.toString(Math.abs(seclat)));
            deglon = Float.valueOf(this.degLon.getText()).intValue();
            minlon = this.minLon.getText().equals("") ? 0 : Float.valueOf(this.minLon.getText()).intValue();
            this.minLon.setText(Integer.toString(Math.abs(minlon)));
            seclon = this.secLon.getText().equals("") ? 0.0f : Float.valueOf(this.secLon.getText()).floatValue();
            this.secLon.setText(Float.toString(Math.abs(seclon)));
        }
        catch (NumberFormatException except) {
            this.clearTextBoxes();
            return null;
        }
        this.degLat.setText(Integer.toString(deglat));
        this.degLon.setText(Integer.toString(deglon));
        float direction = 1.0f;
        if ((float)deglat < 0.0f) {
            direction = -1.0f;
        }
        float lat = (float)deglat + (Math.abs((float)minlat * 60.0f) + Math.abs(seclat)) / 3600.0f * direction;
        direction = 1.0f;
        if ((float)deglon < 0.0f) {
            direction = -1.0f;
        }
        float lon = (float)deglon + (Math.abs((float)minlon * 60.0f) + Math.abs(seclon)) / 3600.0f * direction;
        return new LatLonPoint(lat, lon);
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
            return;
        }
        double lat = llpoint.getLatitude();
        double lon = llpoint.getLongitude();
        double direction = 1.0;
        if (lat < 0.0) {
            direction = -1.0;
        }
        lat = Math.abs(lat);
        double fractLat = lat - Math.floor(lat);
        this.degLat.setText(Integer.toString((int)(Math.floor(lat) * direction)));
        this.minLat.setText(Integer.toString((int)Math.floor(fractLat * 60.0)));
        this.secLat.setText(this.df.format((float)Math.floor(fractLat * 60.0 % 1.0 * 60.0)));
        direction = 1.0;
        if (lon < 0.0) {
            direction = -1.0;
        }
        lon = Math.abs(lon);
        double fractLon = lon - Math.floor(lon);
        this.degLon.setText(Integer.toString((int)(Math.floor(lon) * direction)));
        this.minLon.setText(Integer.toString((int)Math.floor(fractLon * 60.0)));
        this.secLon.setText(this.df.format((float)Math.floor(fractLon * 60.0 % 1.0 * 60.0)));
        if (Debug.debugging("coordpanel")) {
            Debug.output("DMSCoordPanel.setLatLon(): setting " + llpoint + " to " + this.degLat.getText() + ", " + this.minLat.getText() + ", " + this.secLat.getText() + " and " + this.degLon.getText() + ", " + this.minLon.getText() + ", " + this.secLon.getText() + " : backcheck = " + this.getLatLon());
        }
    }

    protected void clearTextBoxes() {
        this.degLat.setText("");
        this.minLat.setText("");
        this.secLat.setText("");
        this.degLon.setText("");
        this.minLon.setText("");
        this.secLon.setText("");
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("coordpanel");
        DMSCoordPanel dms = new DMSCoordPanel();
        dms.setLatLon(new LatLonPoint(40.8f, -75.2f));
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

