/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.MatchParameters;

public interface MatchFilter {
    public boolean preConsider(GeoExtent var1, GeoExtent var2);

    public double getHRange();

    public static class ExactMF
    implements MatchFilter {
        public double getHRange() {
            return 0.0;
        }

        public boolean preConsider(GeoExtent seg, GeoExtent region) {
            return true;
        }
    }

    public static class MatchParametersMF
    implements MatchFilter {
        protected double hrange = 0.0;

        public MatchParametersMF(MatchParameters params) {
            this.hrange = params.horizontalRange();
        }

        public MatchParametersMF(double hrange, int[] vrange, long[] trange) {
            this.hrange = hrange;
        }

        public double getHRange() {
            return this.hrange;
        }

        public boolean preConsider(GeoExtent seg, GeoExtent region) {
            return true;
        }
    }
}

