/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.asrp.ASRPConstants;
import com.bbn.openmap.dataAccess.asrp.GeneralInformationFile;
import com.bbn.openmap.dataAccess.asrp.GeoReferenceFile;
import com.bbn.openmap.dataAccess.asrp.QualityFile;
import com.bbn.openmap.dataAccess.asrp.RasterGeoDataFile;
import com.bbn.openmap.dataAccess.asrp.SourceFile;
import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfield;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ASRPDirectory
extends CacheHandler
implements ASRPConstants {
    protected GeneralInformationFile gen;
    protected QualityFile qal;
    protected RasterGeoDataFile img;
    protected GeoReferenceFile ger;
    protected SourceFile sou;
    protected List tsi;
    protected int numHorBlocks_N;
    protected int numVerBlocks_M;
    protected int numHorPixels_Q;
    protected int numVerPixels_P;
    protected int pixelCountBits;
    protected int pixelValueBits;
    protected float swo;
    protected float nea;
    protected float neo;
    protected float swa;
    protected float lso;
    protected float pso;
    protected int arv;
    protected int brv;
    protected float degPerHorBlock;
    protected float degPerVerBlock;
    protected int tileDataOffset;
    protected Color[] colors;
    protected OMRect bounds;
    protected File dir;
    protected double scaleFactor = 4.0;

    public ASRPDirectory(String path) {
        this.dir = new File(path);
        if (this.dir.exists()) {
            try {
                this.initialize(this.dir.getPath(), this.dir.getName(), "01");
            }
            catch (IOException ioe) {
                Debug.error(ioe.getMessage());
                ioe.printStackTrace();
                return;
            }
        } else {
            Debug.error("ASRPDirectory (" + path + ") doesn't exist");
        }
    }

    public String getPath() {
        if (this.dir != null) {
            return this.dir.getPath();
        }
        return null;
    }

    public OMRect getBounds() {
        if (this.bounds == null) {
            this.bounds = new OMRect(this.pso, this.lso, this.pso - this.degPerVerBlock * (float)this.numVerBlocks_M, this.lso + this.degPerHorBlock * (float)this.numHorBlocks_N, 3);
        }
        return this.bounds;
    }

    public void setScaleFactor(double scaleFactorIn) {
        this.scaleFactor = scaleFactorIn;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public boolean isOnMap(Projection proj) {
        OMRect bds = this.getBounds();
        bds.generate(proj);
        GeneralPath s = bds.getShape();
        return s.intersects(0.0, 0.0, proj.getWidth(), proj.getHeight());
    }

    public boolean validScale(Projection proj) {
        if (proj instanceof EqualArc) {
            boolean result;
            EqualArc ea = (EqualArc)proj;
            double xPixConstant = ea.getXPixConstant();
            double scale = xPixConstant / (double)this.arv;
            boolean bl = result = scale < this.scaleFactor && scale > 1.0 / this.scaleFactor;
            if (Debug.debugging("asrp")) {
                Debug.output("Scale comparing arv = " + this.arv + ", " + xPixConstant + ", result: " + result);
            }
            return result;
        }
        return false;
    }

    public OMGraphicList checkProjAndGetTiledImages(Projection proj) throws IOException {
        if (!this.isOnMap(proj) || !this.validScale(proj)) {
            return new OMGraphicList();
        }
        return this.getTiledImages(proj);
    }

    public OMGraphicList getTiledImages(Projection proj) throws IOException {
        float ullat = this.pso;
        float ullon = this.lso;
        float lrlat = ullat - this.degPerVerBlock * (float)this.numVerBlocks_M;
        float lrlon = ullon + this.degPerHorBlock * (float)this.numHorBlocks_N;
        LatLonPoint llp1 = proj.getUpperLeft();
        LatLonPoint llp2 = proj.getLowerRight();
        int startX = (int)Math.floor((llp1.getLongitude() - ullon) / this.degPerHorBlock);
        int startY = (int)Math.floor((ullat - llp1.getLatitude()) / this.degPerVerBlock);
        int endX = this.numHorBlocks_N - (int)Math.floor((lrlon - llp2.getLongitude()) / this.degPerHorBlock);
        int endY = this.numVerBlocks_M - (int)Math.floor((llp2.getLatitude() - lrlat) / this.degPerVerBlock);
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (endX > this.numHorBlocks_N) {
            endX = this.numHorBlocks_N;
        }
        if (endY > this.numVerBlocks_M) {
            endY = this.numVerBlocks_M;
        }
        return this.getTiledImages(new Rectangle(startX, startY, endX - startX, endY - startY), proj);
    }

    protected OMGraphicList getTiledImages(Rectangle rect, Projection proj) throws IOException {
        if (Debug.debugging("asrp")) {
            Debug.output("ASRPDirectory: fielding request for " + rect);
        }
        OMGraphicList list = new OMGraphicList();
        int startX = (int)rect.getX();
        int startY = (int)rect.getY();
        int endX = startX + (int)rect.getWidth();
        int endY = startY + (int)rect.getHeight();
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                OMGraphic omg = (OMGraphic)this.get(new String(x + "," + y).intern());
                if (omg == null) continue;
                omg.generate(proj);
                list.add(omg);
            }
        }
        return list;
    }

    public OMScalingRaster getBlock(int x, int y) throws IOException {
        float ullat = this.pso - (float)y * this.degPerVerBlock;
        float ullon = this.lso + (float)x * this.degPerHorBlock;
        float lrlat = ullat - this.degPerVerBlock;
        float lrlon = ullon + this.degPerHorBlock;
        if (this.tsi != null) {
            int index = y * this.numHorBlocks_N + x;
            if (index >= this.tsi.size()) {
                return null;
            }
            int blockOffset = ((DDFSubfield)this.tsi.get(index)).intValue() - 1;
            if (Debug.debugging("asrp")) {
                Debug.output("ASRPDirectory.getBlock: index of (" + x + ", " + y + ") is " + blockOffset);
            }
            if (blockOffset < 0) {
                if (Debug.debugging("asrp")) {
                    Debug.output("     skipping...");
                }
                return null;
            }
            DDFModule mod = this.img.getInfo();
            mod.seek(this.tileDataOffset + blockOffset);
            int numBlockPixels = this.numHorPixels_Q * this.numVerPixels_P;
            byte[] data = new byte[numBlockPixels];
            int rowCount = 0;
            int cpc = 0;
            int cpv = 0;
            for (int byteCount = 0; byteCount < numBlockPixels; byteCount += cpc) {
                switch (this.pixelCountBits) {
                    case 8: {
                        cpc = mod.read();
                        break;
                    }
                    case 4: {
                        cpc = mod.read() >> 4;
                        Debug.output("CAUTION:  4 bit count");
                        break;
                    }
                    default: {
                        cpc = 1;
                    }
                }
                cpv = mod.read();
                try {
                    for (int c = 0; c < cpc; ++c) {
                        ++rowCount;
                        if (this.colors != null && cpv > this.colors.length && Debug.debugging("asrpdetail")) {
                            Debug.output("Got value that is too big for colortable");
                        }
                        data[byteCount + c] = (byte)cpv;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    if (!Debug.debugging("asrp")) continue;
                    Debug.output("ASRPDirectory.getBlock(): bad index for setting byte value: " + aioobe.getMessage());
                }
                if (rowCount != this.numHorPixels_Q) continue;
                rowCount = 0;
            }
            if (Debug.debugging("asrpdetail")) {
                Debug.output("ASRPDirectory creating image covering (" + ullat + ", " + ullon + "), (" + lrlat + ", " + lrlon + ")");
            }
            return new OMScalingRaster(ullat, ullon, lrlat, lrlon, this.numHorPixels_Q, this.numVerPixels_P, data, this.getColors(), 255);
        }
        return null;
    }

    protected Color[] getColors() {
        if (this.colors == null) {
            DDFField col = this.qal.getField("COL");
            List reds = col.getSubfields("NSR");
            List greens = col.getSubfields("NSG");
            List blues = col.getSubfields("NSB");
            int numColors = reds.size();
            this.colors = new Color[numColors];
            for (int count = 0; count < numColors; ++count) {
                int red = ((DDFSubfield)reds.get(count)).intValue();
                int green = ((DDFSubfield)greens.get(count)).intValue();
                int blue = ((DDFSubfield)blues.get(count)).intValue();
                this.colors[count] = new Color(red, green, blue, count == 0 ? 0 : 255);
            }
        }
        return this.colors;
    }

    protected void initialize(String dirPath, String root, String DD) throws IOException {
        String rootPath = dirPath + "/" + root + DD + ".";
        this.gen = new GeneralInformationFile(rootPath + "GEN");
        this.ger = new GeoReferenceFile(rootPath + "GER");
        this.qal = new QualityFile(rootPath + "QAL");
        this.sou = new SourceFile(rootPath + "SOU");
        this.img = new RasterGeoDataFile(rootPath + "IMG");
        DDFField sprInfo = this.gen.getField("SPR");
        this.numHorBlocks_N = sprInfo.getSubfield("NFC").intValue();
        this.numVerBlocks_M = sprInfo.getSubfield("NFL").intValue();
        this.numHorPixels_Q = sprInfo.getSubfield("PNC").intValue();
        this.numVerPixels_P = sprInfo.getSubfield("PNL").intValue();
        this.pixelCountBits = sprInfo.getSubfield("PCB").intValue();
        this.pixelValueBits = sprInfo.getSubfield("PVB").intValue();
        DDFField genInfo = this.gen.getField("GEN");
        this.swo = genInfo.getSubfield("SWO").floatValue() / 3600.0f;
        this.neo = genInfo.getSubfield("NEO").floatValue() / 3600.0f;
        this.nea = genInfo.getSubfield("NEA").floatValue() / 3600.0f;
        this.swa = genInfo.getSubfield("SWA").floatValue() / 3600.0f;
        this.lso = genInfo.getSubfield("LSO").floatValue() / 3600.0f;
        this.pso = genInfo.getSubfield("PSO").floatValue() / 3600.0f;
        this.arv = genInfo.getSubfield("ARV").intValue();
        this.brv = genInfo.getSubfield("BRV").intValue();
        DDFField timInfo = this.gen.getField("TIM");
        this.tsi = timInfo.getSubfields("TSI");
        DDFField pixelInfo = this.img.getField("SCN");
        this.tileDataOffset = pixelInfo.getHeaderOffset() + pixelInfo.getDataPosition();
        this.degPerHorBlock = 360.0f / (float)this.arv * (float)this.numHorPixels_Q;
        this.degPerVerBlock = 360.0f / (float)this.brv * (float)this.numVerPixels_P;
        if (Debug.debugging("asrp")) {
            Debug.output("For " + rootPath + "\n\thave blocks (" + this.numHorBlocks_N + ", " + this.numVerBlocks_M + ")\n\twith pixels (" + this.numHorPixels_Q + ", " + this.numVerPixels_P + ")");
            Debug.output("\tCoverage from (" + this.nea + ", " + this.swo + ") to (" + this.swa + ", " + this.neo + ")");
            Debug.output("\tPadded coverage starting at (" + this.pso + ", " + this.lso + ")");
            Debug.output("\tNumber of pixels 360 e-w (" + this.arv + ") , n-s (" + this.brv + ")");
            Debug.output("\tdegrees per horizontal block: " + this.degPerHorBlock + ", vertical: " + this.degPerVerBlock);
            Debug.output("\tImage Data made up of count bits: " + this.pixelCountBits + ", value bits: " + this.pixelValueBits);
            if (Debug.debugging("asrpdetail")) {
                Debug.output("Checking...");
                float latdiff = this.nea - this.swa;
                float londiff = this.neo - this.swo;
                float horPixels = (float)this.arv * (londiff / 360.0f);
                float verPixels = (float)this.brv * (latdiff / 360.0f);
                Debug.output("\tCalculating " + horPixels / (float)this.numHorPixels_Q + " hor blocks");
                Debug.output("\tCalculating " + verPixels / (float)this.numVerPixels_P + " hor blocks");
                Debug.output("\tCalculating " + (this.lso + this.degPerHorBlock * (float)this.numHorBlocks_N) + " end latitude");
                Debug.output("\tCalculating " + (this.pso - this.degPerVerBlock * (float)this.numVerBlocks_M) + " end latitude");
            }
        }
        this.getColors();
        this.gen.close();
        this.ger.close();
        this.qal.close();
        this.sou.close();
        this.img.close();
    }

    public CacheObject load(String xAndY) {
        if (xAndY != null) {
            int commaIndex = xAndY.indexOf(44);
            int x = Integer.parseInt(xAndY.substring(0, commaIndex));
            int y = Integer.parseInt(xAndY.substring(commaIndex + 1));
            if (Debug.debugging("asrpdetail")) {
                Debug.output("Getting tiled image " + x + ", " + y + " (from " + xAndY + ")");
            }
            try {
                OMScalingRaster block = this.getBlock(x, y);
                if (block != null) {
                    return new ASRPBlockCacheObject(xAndY.intern(), block);
                }
            }
            catch (IOException ioe) {
                Debug.error("ASRPDirectory caught exception creating tiled image for " + xAndY);
            }
        }
        return null;
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length < 1) {
            Debug.output("Usage: ASRPDirectory dir_pathname");
        } else {
            new ASRPDirectory(argv[0]);
        }
        System.exit(0);
    }

    private static class ASRPBlockCacheObject
    extends CacheObject {
        public ASRPBlockCacheObject(String id, OMGraphic obj) {
            super(id, obj);
        }

        public void finalize() {
        }
    }
}

