/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.grassraster.JGrassConstants;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureMate;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureUtilities {
    public static CoordinateList orderLineGeometries(List<Geometry> geometryList, double thresHold) {
        int i;
        Geometry firstFeature = null;
        boolean foundFirst = true;
        boolean foundSecond = true;
        for (Geometry feature : geometryList) {
            foundFirst = true;
            foundSecond = true;
            Coordinate[] coords = feature.getCoordinates();
            Coordinate first = coords[0];
            Coordinate last = coords[coords.length - 1];
            for (Geometry compareFeature : geometryList) {
                if (compareFeature.equals(feature)) continue;
                Coordinate[] compareCoords = compareFeature.getCoordinates();
                Coordinate comparefirst = compareCoords[0];
                Coordinate comparelast = compareCoords[compareCoords.length - 1];
                if (first.distance(comparefirst) < thresHold || first.distance(comparelast) < thresHold) {
                    foundFirst = false;
                }
                if (!(last.distance(comparefirst) < thresHold) && !(last.distance(comparelast) < thresHold)) continue;
                foundSecond = false;
            }
            if (!foundFirst && !foundSecond) continue;
            firstFeature = feature;
            break;
        }
        if (firstFeature == null) {
            throw new RuntimeException();
        }
        CoordinateList coordinateList = new CoordinateList();
        Coordinate[] coords = firstFeature.getCoordinates();
        if (foundSecond) {
            for (i = 0; i < coords.length; ++i) {
                coordinateList.add((Object)coords[coords.length - i - 1]);
            }
        } else {
            for (i = 0; i < coords.length; ++i) {
                coordinateList.add((Object)coords[i]);
            }
        }
        geometryList.remove(firstFeature);
        Coordinate currentCoordinate = coordinateList.getCoordinate(coordinateList.size() - 1);
        block4: while (geometryList.size() != 0) {
            for (int j = 0; j < geometryList.size(); ++j) {
                int i2;
                System.out.println(j);
                Geometry compareGeom = geometryList.get(j);
                Coordinate[] compareCoords = compareGeom.getCoordinates();
                Coordinate comparefirst = compareCoords[0];
                Coordinate comparelast = compareCoords[compareCoords.length - 1];
                if (currentCoordinate.distance(comparefirst) < thresHold) {
                    for (i2 = 0; i2 < compareCoords.length; ++i2) {
                        coordinateList.add((Object)compareCoords[i2]);
                    }
                    currentCoordinate = new Coordinate(comparelast);
                    geometryList.remove(compareGeom);
                    continue block4;
                }
                if (!(currentCoordinate.distance(comparelast) < thresHold)) continue;
                for (i2 = 0; i2 < compareCoords.length; ++i2) {
                    coordinateList.add((Object)compareCoords[compareCoords.length - i2 - 1]);
                }
                currentCoordinate = new Coordinate(comparefirst);
                geometryList.remove(compareGeom);
                continue block4;
            }
        }
        return coordinateList;
    }

    public static SimpleFeatureCollection createFeatureCollection(SimpleFeature ... features) {
        DefaultFeatureCollection fcollection = new DefaultFeatureCollection();
        for (SimpleFeature feature : features) {
            fcollection.add(feature);
        }
        return fcollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureCollection csvFileToFeatureCollection(File csvFile, CoordinateReferenceSystem crs, LinkedHashMap<String, Integer> fieldsAndTypesIndex, String separator, IJGTProgressMonitor pm) throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Map typesMap = JGrassConstants.CSVTYPESCLASSESMAP;
        String[] typesArray = JGrassConstants.CSVTYPESARRAY;
        if (separator == null) {
            separator = ",";
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("csvimport");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        int xIndex = -1;
        int yIndex = -1;
        Set<String> fieldNames = fieldsAndTypesIndex.keySet();
        String[] fieldNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
        for (int i = 0; i < fieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i];
            Integer typeIndex = fieldsAndTypesIndex.get(fieldName);
            if (typeIndex == 0) {
                xIndex = i;
                continue;
            }
            if (typeIndex == 1) {
                yIndex = i;
                continue;
            }
            Class class1 = (Class)typesMap.get(typesArray[typeIndex]);
            b.add(fieldName, class1);
        }
        SimpleFeatureType featureType = b.buildFeatureType();
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        Collection<Integer> orderedTypeIndexes = fieldsAndTypesIndex.values();
        Integer[] orderedTypeIndexesArray = orderedTypeIndexes.toArray(new Integer[orderedTypeIndexes.size()]);
        try (BufferedReader bR = null;){
            bR = new BufferedReader(new FileReader(csvFile));
            String line = null;
            int featureId = 0;
            pm.beginTask("Importing raw data", -1);
            while ((line = bR.readLine()) != null) {
                pm.worked(1);
                if (line.startsWith("#")) continue;
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                Object[] values = new Object[fieldNames.size() - 1];
                String[] lineSplit = line.split(separator);
                double x = Double.parseDouble(lineSplit[xIndex]);
                double y = Double.parseDouble(lineSplit[yIndex]);
                Point point = gf.createPoint(new Coordinate(x, y));
                values[0] = point;
                int objIndex = 1;
                for (int i = 0; i < lineSplit.length; ++i) {
                    if (i == xIndex || i == yIndex) continue;
                    String value = lineSplit[i];
                    int typeIndex = orderedTypeIndexesArray[i];
                    String typeName = typesArray[typeIndex];
                    if (typeName.equals(typesArray[3])) {
                        values[objIndex] = value;
                    } else if (typeName.equals(typesArray[4])) {
                        values[objIndex] = new Double(value);
                    } else if (typeName.equals(typesArray[5])) {
                        values[objIndex] = new Integer(value);
                    } else {
                        throw new IllegalArgumentException("An undefined value type was found");
                    }
                    ++objIndex;
                }
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(featureType.getTypeName() + "." + featureId);
                ++featureId;
                newCollection.add(feature);
            }
        }
        pm.done();
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean collectionToShapeFile(String shapeFilePath, CoordinateReferenceSystem crs, SimpleFeatureCollection fet) throws IOException {
        File file = null;
        file = shapeFilePath.toLowerCase().endsWith(".shp") ? new File(shapeFilePath) : new File(shapeFilePath + ".shp");
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, URL> create = new HashMap<String, URL>();
        create.put("url", file.toURI().toURL());
        ShapefileDataStore newDataStore = (ShapefileDataStore)factory.createNewDataStore(create);
        newDataStore.createSchema((SimpleFeatureType)fet.getSchema());
        if (crs != null) {
            newDataStore.forceSchemaCRS(crs);
        }
        DefaultTransaction transaction = new DefaultTransaction();
        SimpleFeatureStore featureStore = (SimpleFeatureStore)newDataStore.getFeatureSource();
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures((FeatureCollection)fet);
            transaction.commit();
        }
        catch (Exception problem) {
            problem.printStackTrace();
            transaction.rollback();
        }
        finally {
            transaction.close();
        }
        return true;
    }

    public static ShapefileDataStore createShapeFileDatastore(String name, String fieldsSpec, CoordinateReferenceSystem crs) throws Exception {
        File file = null;
        file = name.toLowerCase().endsWith(".shp") ? new File(name) : new File(name + ".shp");
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, URL> create = new HashMap<String, URL>();
        create.put("url", file.toURI().toURL());
        ShapefileDataStore myData = (ShapefileDataStore)factory.createNewDataStore(create);
        SimpleFeatureType featureType = DataUtilities.createType((String)name, (String)fieldsSpec);
        myData.createSchema(featureType);
        myData.forceSchemaCRS(crs);
        return myData;
    }

    public static List<SimpleFeature> featureCollectionToList(SimpleFeatureCollection collection) {
        ArrayList<SimpleFeature> featuresList = new ArrayList<SimpleFeature>();
        if (collection == null) {
            return featuresList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            featuresList.add(feature);
        }
        featureIterator.close();
        return featuresList;
    }

    public static STRtree featureCollectionToSTRtree(SimpleFeatureCollection collection) {
        STRtree tree = new STRtree();
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            tree.insert(geometry.getEnvelopeInternal(), (Object)feature);
        }
        featureIterator.close();
        return tree;
    }

    public static List<FeatureMate> featureCollectionToMatesList(SimpleFeatureCollection collection) {
        ArrayList<FeatureMate> featuresList = new ArrayList<FeatureMate>();
        if (collection == null) {
            return featuresList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            featuresList.add(new FeatureMate(feature));
        }
        featureIterator.close();
        return featuresList;
    }

    public static List<Geometry> featureCollectionToGeometriesList(SimpleFeatureCollection collection, boolean doSubGeoms, String userDataField) {
        ArrayList<Geometry> geometriesList = new ArrayList<Geometry>();
        if (collection == null) {
            return geometriesList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (geometry == null) continue;
            if (doSubGeoms) {
                int numGeometries = geometry.getNumGeometries();
                for (int i = 0; i < numGeometries; ++i) {
                    Geometry geometryN = geometry.getGeometryN(i);
                    geometriesList.add(geometryN);
                    if (userDataField == null) continue;
                    Object attribute = feature.getAttribute(userDataField);
                    geometryN.setUserData(attribute);
                }
                continue;
            }
            geometriesList.add(geometry);
            if (userDataField == null) continue;
            Object attribute = feature.getAttribute(userDataField);
            geometry.setUserData(attribute);
        }
        featureIterator.close();
        return geometriesList;
    }

    public static SimpleFeatureCollection featureCollectionFromGeometry(CoordinateReferenceSystem crs, Geometry ... geometries) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("simplegeom");
        b.setCRS(crs);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        GeometryType geometryType = GeometryUtilities.getGeometryType(geometries[0]);
        switch (geometryType) {
            case LINE: {
                b.add("the_geom", LineString.class);
                break;
            }
            case MULTILINE: {
                b.add("the_geom", MultiLineString.class);
                break;
            }
            case POINT: {
                b.add("the_geom", Point.class);
                break;
            }
            case MULTIPOINT: {
                b.add("the_geom", MultiPoint.class);
                break;
            }
            case POLYGON: {
                b.add("the_geom", Polygon.class);
                break;
            }
            case MULTIPOLYGON: {
                b.add("the_geom", MultiPolygon.class);
                break;
            }
        }
        Object userData = geometries[0].getUserData();
        int userDataSize = 1;
        if (userData != null) {
            if (userData instanceof String[]) {
                String[] string = (String[])userData;
                userDataSize = string.length;
                for (int i = 0; i < userDataSize; ++i) {
                    b.add("data" + i, String.class);
                }
            } else {
                b.add("userdata", userData.getClass());
            }
        }
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (Geometry g : geometries) {
            Object[] values;
            if (userData == null) {
                values = new Object[]{g};
            } else {
                Object tmpUserData = g.getUserData();
                if (tmpUserData instanceof String[]) {
                    String[] string = (String[])tmpUserData;
                    values = new Object[userDataSize + 1];
                    values[0] = g;
                    for (int i = 0; i < string.length; ++i) {
                        values[i + 1] = string[i];
                    }
                } else {
                    values = new Object[]{g, tmpUserData};
                }
            }
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
        }
        return newCollection;
    }

    public static Object getAttributeCaseChecked(SimpleFeature feature, String field) {
        Object attribute = feature.getAttribute(field);
        if (attribute == null) {
            attribute = feature.getAttribute(field.toLowerCase());
            if (attribute != null) {
                return attribute;
            }
            attribute = feature.getAttribute(field.toUpperCase());
            if (attribute != null) {
                return attribute;
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            field = FeatureUtilities.findAttributeName(featureType, field);
            if (field != null) {
                return feature.getAttribute(field);
            }
        }
        return attribute;
    }

    public static String findAttributeName(SimpleFeatureType featureType, String field) {
        List attributeDescriptors = featureType.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            if (!name.toLowerCase().equals(field.toLowerCase())) continue;
            return name;
        }
        return null;
    }

    public static Polygon envelopeToPolygon(Envelope2D envelope) {
        double w = envelope.getMinX();
        double e = envelope.getMaxX();
        double s = envelope.getMinY();
        double n = envelope.getMaxY();
        Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
        GeometryFactory gf = GeometryUtilities.gf();
        LinearRing linearRing = gf.createLinearRing(coords);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    public static Polygon envelopeToPolygon(Envelope envelope) {
        double w = envelope.getMinX();
        double e = envelope.getMaxX();
        double s = envelope.getMinY();
        double n = envelope.getMaxY();
        Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
        GeometryFactory gf = GeometryUtilities.gf();
        LinearRing linearRing = gf.createLinearRing(coords);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    public static List<Polygon> gridcoverageToCellPolygons(GridCoverage2D coverage) {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        double west = regionMap.getWest();
        double north = regionMap.getNorth();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double w = west + xres * (double)c;
                double e = w + xres;
                double n = north - yres * (double)r;
                double s = n - yres;
                Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
                GeometryFactory gf = GeometryUtilities.gf();
                LinearRing linearRing = gf.createLinearRing(coords);
                Polygon polygon = gf.createPolygon(linearRing, null);
                polygons.add(polygon);
            }
        }
        return polygons;
    }

    public static Collection<Polygon> doVectorize(GridCoverage2D src, Map<String, Object> args) {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        ParameterBlockJAI pb = new ParameterBlockJAI("Vectorize");
        pb.setSource("source0", (Object)src.getRenderedImage());
        for (Map.Entry<String, Object> e : args.entrySet()) {
            pb.setParameter(e.getKey(), e.getValue());
        }
        RenderedOp dest = JAI.create((String)"Vectorize", (ParameterBlock)pb);
        Collection polygons = (Collection)dest.getProperty("vectors");
        RegionMap regionParams = CoverageUtilities.getRegionParamsFromGridCoverage(src);
        double xRes = regionParams.getXres();
        double yRes = regionParams.getYres();
        AffineTransform mt2D = (AffineTransform)src.getGridGeometry().getGridToCRS2D(PixelOrientation.CENTER);
        AffineTransformation jtsTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX() - xRes / 2.0, mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY() + yRes / 2.0);
        for (Polygon polygon : polygons) {
            polygon.apply((CoordinateSequenceFilter)jtsTransformation);
        }
        return polygons;
    }

    public static SimpleFeature toDummyFeature(Geometry geom, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("dummy");
        if (crs != null) {
            b.setCRS(crs);
        }
        b.add("the_geom", geom.getClass());
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        Object[] values = new Object[]{geom};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(null);
        return feature;
    }

    public static List<Coordinate> extractPolygonOnCoverage(RandomIter coverageIterator, int cols, int rows, double xRes, GridGeometry2D gridGeometry, Polygon polygon, double defaultValue) throws Exception {
        GeometryFactory gf = GeometryUtilities.gf();
        PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)polygon);
        double delta = xRes / 4.0;
        ArrayList<Coordinate> coordinatesList = new ArrayList<Coordinate>();
        for (int r = 0; r < rows; ++r) {
            double[] westPos = gridGeometry.gridToWorld(new GridCoordinates2D(0, r)).getCoordinate();
            double[] eastPos = gridGeometry.gridToWorld(new GridCoordinates2D(cols - 1, r)).getCoordinate();
            Coordinate west = new Coordinate(westPos[0], westPos[1]);
            Coordinate east = new Coordinate(eastPos[0], eastPos[1]);
            LineString line = gf.createLineString(new Coordinate[]{west, east});
            if (!preparedGeometry.intersects((Geometry)line)) continue;
            Geometry internalLines = polygon.intersection((Geometry)line);
            int lineNums = internalLines.getNumGeometries();
            for (int l = 0; l < lineNums; ++l) {
                Coordinate[] coords = internalLines.getGeometryN(l).getCoordinates();
                if (coords.length == 2) {
                    for (int j = 0; j < coords.length; j += 2) {
                        DirectPosition2D endDP;
                        DirectPosition2D startDP;
                        Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                        Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                        if (startC.x < endC.x) {
                            startDP = new DirectPosition2D(startC.x, startC.x);
                            endDP = new DirectPosition2D(endC.x, endC.x);
                        } else {
                            startDP = new DirectPosition2D(endC.x, endC.x);
                            endDP = new DirectPosition2D(startC.x, startC.x);
                        }
                        GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)startDP);
                        GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)endDP);
                        for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                            double v = defaultValue;
                            if (coverageIterator != null) {
                                v = coverageIterator.getSampleDouble(k, r, 0);
                            }
                            double[] xy = gridGeometry.gridToWorld(new GridCoordinates2D(k, r)).getCoordinate();
                            Coordinate coordinate = new Coordinate(xy[0], xy[1], v);
                            coordinatesList.add(coordinate);
                        }
                    }
                    continue;
                }
                if (coords.length == 1) {
                    throw new ModelsIOException(MessageFormat.format("Found a cusp in: {0}/{1}", coords[0].x, coords[0].y), "FeatureUtilities");
                }
                throw new ModelsIOException(MessageFormat.format("Found intersection with more than 2 points in: {0}/{1}", coords[0].x, coords[0].y), "FeatureUtilities");
            }
        }
        return coordinatesList;
    }

    public static double avg(List<SimpleFeature> features, String field) {
        double sum = 0.0;
        int count = 0;
        for (SimpleFeature feature : features) {
            Object attribute = feature.getAttribute(field);
            if (!(attribute instanceof Number)) continue;
            sum += ((Number)attribute).doubleValue();
            ++count;
        }
        double avg = sum / (double)count;
        return avg;
    }

    public static double[][] histogram(List<SimpleFeature> features, String field, int bins) {
        int i;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (SimpleFeature feature : features) {
            Object attribute = feature.getAttribute(field);
            if (!(attribute instanceof Number)) continue;
            double value = ((Number)attribute).doubleValue();
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        double range = max - min;
        double step = range / (double)bins;
        double[][] histogram = new double[bins][3];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            histogram[i2][0] = min + step * (double)(i2 + 1);
        }
        block2: for (SimpleFeature feature : features) {
            Object attribute = feature.getAttribute(field);
            if (!(attribute instanceof Number)) continue;
            double value = ((Number)attribute).doubleValue();
            for (int j = 0; j < histogram.length; ++j) {
                if (!(value <= histogram[j][0])) continue;
                histogram[j][1] = histogram[j][1] + 1.0;
                continue block2;
            }
        }
        double cumulatedMax = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            histogram[i][2] = i == 0 ? histogram[i][1] : histogram[i - 1][2] + histogram[i][1];
            cumulatedMax = histogram[i][2];
        }
        for (i = 0; i < histogram.length; ++i) {
            histogram[i][2] = histogram[i][2] / cumulatedMax;
            histogram[i][0] = histogram[i][0] - step / 2.0;
        }
        return histogram;
    }
}

