/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.r.rangelookup.OmsRangeLookup;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module for raster to vector conversion.")
@Documentation(value="OmsVectorizer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, OmsScanLineRasterizer")
@Label(value="Vector Processing")
@Name(value="vectorizer")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorizer
extends JGTModel {
    @Description(value="The raster that has to be converted.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The value to use to trace the polygons. If it is null then all the value of the raster are used.")
    @In
    public Double pValue = null;
    @Description(value="The field name to use as a name for the raster value in the vector.")
    @In
    public String fDefault = "value";
    @Description(value="If true, wholes are removed form polygons.")
    @In
    public boolean doRemoveHoles = false;
    @Description(value="A threshold on cell number to filter away polygons with cells less than that.")
    @In
    public double pThres = 0.0;
    @Description(value="Make a check on the raster first and shrink the boundaries on the region with data.")
    @In
    public boolean doRegioncheck = false;
    @Description(value="Don't consider values, use value-nvalue mask.")
    @In
    public boolean doMask = false;
    @Description(value="A threshold to set on the values before masking (values below are nulled).")
    @In
    public double pMaskThreshold = Double.NaN;
    @Description(value="The extracted vector.")
    @Out
    public SimpleFeatureCollection outVector = null;
    public int featureIndex = 0;
    private CoordinateReferenceSystem crs;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inRaster);
        this.crs = this.inRaster.getCoordinateReferenceSystem();
        this.doRegionCheck();
        String classes = null;
        StringBuilder sb = new StringBuilder();
        if (this.pValue != null) {
            sb.append("(null ");
            sb.append(this.pValue);
            sb.append("),[");
            sb.append(this.pValue);
            sb.append(" ");
            sb.append(this.pValue);
            sb.append("],(");
            sb.append(this.pValue);
            sb.append(" null)");
            classes = "NaN," + this.pValue + ",NaN";
            String ranges = sb.toString();
            this.pm.beginTask("Extract range: " + ranges, -1);
            OmsRangeLookup cont = new OmsRangeLookup();
            cont.inRaster = this.inRaster;
            cont.pRanges = ranges;
            cont.pClasses = classes;
            cont.pm = this.pm;
            cont.process();
            this.inRaster = cont.outRaster;
            this.pm.done();
        }
        if (this.doMask) {
            this.inRaster = this.maskRaster();
        }
        this.pm.beginTask("Vectorizing map...", -1);
        HashMap<String, Object> args = new HashMap<String, Object>();
        Collection<Polygon> polygonsList = this.doVectorize(this.inRaster.getRenderedImage(), args);
        this.pm.done();
        RegionMap regionParams = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        double xRes = (Double)regionParams.get("XRES");
        double yRes = (Double)regionParams.get("YRES");
        AffineTransform mt2D = (AffineTransform)this.inRaster.getGridGeometry().getGridToCRS2D(PixelOrientation.CENTER);
        AffineTransformation awt2WorldTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX() - xRes / 2.0, mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY() + yRes / 2.0);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("raster2vector");
        b.setCRS(this.crs);
        b.add("the_geom", Polygon.class);
        b.add("cat", Integer.class);
        b.add(this.fDefault, Double.class);
        b.add("area", Double.class);
        b.add("perimeter", Double.class);
        b.add("xcentroid", Double.class);
        b.add("ycentroid", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        this.outVector = new DefaultFeatureCollection();
        for (Polygon polygon : polygonsList) {
            double area = polygon.getArea();
            if (area <= this.pThres) continue;
            Double tmpValue = -1.0;
            Object userData = polygon.getUserData();
            if (userData instanceof Double) {
                tmpValue = (Double)userData;
            }
            polygon.apply((CoordinateSequenceFilter)awt2WorldTransformation);
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            if (this.doRemoveHoles) {
                LineString exteriorRing = polygon.getExteriorRing();
                polygon = this.gf.createPolygon(exteriorRing.getCoordinates());
            }
            area = polygon.getArea();
            double perim = polygon.getLength();
            Point centroid = polygon.getCentroid();
            Coordinate centroidCoord = centroid.getCoordinate();
            Object[] values = new Object[]{polygon, this.featureIndex, tmpValue, area, perim, centroidCoord.x, centroidCoord.y};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(type.getTypeName() + "." + this.featureIndex);
            ++this.featureIndex;
            ((DefaultFeatureCollection)this.outVector).add(feature);
        }
    }

    private GridCoverage2D maskRaster() {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        RandomIter rasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        WritableRaster[] holder = new WritableRaster[1];
        GridCoverage2D outGC = CoverageUtilities.createCoverageFromTemplate(this.inRaster, Double.NaN, holder);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)holder[0], null);
        this.pm.beginTask("Masking map...", nRows);
        for (int r = 0; r < nRows; ++r) {
            for (int c = 0; c < nCols; ++c) {
                double value = rasterIter.getSampleDouble(c, r, 0);
                boolean doNull = false;
                if (!JGTConstants.isNovalue(value)) {
                    if (!Double.isNaN(this.pMaskThreshold)) {
                        doNull = value < this.pMaskThreshold;
                    }
                } else {
                    doNull = true;
                }
                if (doNull) continue;
                outIter.setSample(c, r, 0, 1);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        return outGC;
    }

    private void doRegionCheck() throws TransformException {
        if (this.doRegioncheck) {
            int left = Integer.MAX_VALUE;
            int right = -2147483647;
            int top = -2147483647;
            int bottom = Integer.MAX_VALUE;
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            int cols = regionMap.getCols();
            int rows = regionMap.getRows();
            this.pm.beginTask("Try to shrink the region over covered area...", cols);
            RandomIter rasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
            for (int c = 0; c < cols; ++c) {
                for (int r = 0; r < rows; ++r) {
                    double value = rasterIter.getSampleDouble(c, r, 0);
                    if (JGTConstants.isNovalue(value)) continue;
                    left = Math.min(left, c);
                    right = Math.max(right, c);
                    top = Math.max(top, r);
                    bottom = Math.min(bottom, r);
                }
                this.pm.worked(1);
            }
            this.pm.done();
            rasterIter.done();
            GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
            GridEnvelope2D gEnv = new GridEnvelope2D();
            gEnv.setLocation(new java.awt.Point(left, top));
            gEnv.add(new java.awt.Point(right, bottom));
            Envelope2D envelope2d = gridGeometry.gridToWorld(gEnv);
            this.inRaster = (GridCoverage2D)Operations.DEFAULT.crop((Coverage)this.inRaster, (Envelope)envelope2d);
        }
    }

    private Collection<Polygon> doVectorize(RenderedImage src, Map<String, Object> args) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Vectorize");
        pb.setSource("source0", (Object)src);
        for (Map.Entry<String, Object> e : args.entrySet()) {
            pb.setParameter(e.getKey(), e.getValue());
        }
        RenderedOp dest = JAI.create((String)"Vectorize", (ParameterBlock)pb);
        Object property = dest.getProperty("vectors");
        return (Collection)property;
    }
}

