/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.raster2xyz;

import java.io.BufferedWriter;
import java.io.FileWriter;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.geometry.DirectPosition;

@Description(value="Convert a raster to XYZ triplets.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Conversion")
@Label(value="Raster Processing")
@Name(value="raster2xyz")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRaster2Xyz
extends JGTModel {
    @Description(value="The map to convert.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The file into which to save the result.")
    @In
    public String inFile;
    @Description(value="Flag to remove novalues.")
    @In
    public boolean doRemovenv = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        RandomIter rasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(this.inFile));
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    double elevation = rasterIter.getSampleDouble(c, r, 0);
                    if (this.doRemovenv && JGTConstants.isNovalue(elevation)) continue;
                    DirectPosition position = gridGeometry.gridToWorld(new GridCoordinates2D(c, r));
                    double[] coordinate = position.getCoordinate();
                    StringBuilder sb = new StringBuilder();
                    sb.append(coordinate[0]);
                    sb.append("\t");
                    sb.append(coordinate[1]);
                    sb.append("\t");
                    sb.append(elevation);
                    sb.append("\n");
                    writer.write(sb.toString());
                }
            }
        }
    }
}

