/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.geopap4;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TableDescriptions;

public class DaoNotes {
    public static void createTables(Connection connection) throws IOException, SQLException {
        StringBuilder sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("notes");
        sB.append(" (");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName());
        sB.append(" INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName()).append(" DATE NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName()).append(" TEXT, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName()).append(" TEXT NOT NULL, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName()).append(" CLOB, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_STYLE.getFieldName()).append(" TEXT,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName()).append(" INTEGER");
        sB.append(");");
        String CREATE_TABLE_NOTES = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_ts_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_TS = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_x_by_y_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_X_BY_Y = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_isdirty_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_ISDIRTY = sB.toString();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(CREATE_TABLE_NOTES);
            statement.executeUpdate(CREATE_INDEX_NOTES_TS);
            statement.executeUpdate(CREATE_INDEX_NOTES_X_BY_Y);
            statement.executeUpdate(CREATE_INDEX_NOTES_ISDIRTY);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static void addNote(Connection connection, long id, double lon, double lat, double altim, long timestamp, String text, String form) throws Exception {
        String insertSQL = "INSERT INTO notes(" + TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName() + ") VALUES" + "(?,?,?,?,?,?,?,?)";
        try (PreparedStatement writeStatement = connection.prepareStatement(insertSQL);){
            writeStatement.setLong(1, id);
            writeStatement.setDouble(2, lat);
            writeStatement.setDouble(3, lon);
            writeStatement.setDouble(4, altim);
            writeStatement.setLong(5, timestamp);
            writeStatement.setString(6, text);
            writeStatement.setString(7, form);
            writeStatement.setInt(8, 1);
            writeStatement.executeUpdate();
        }
    }
}

