/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects;

import java.util.Vector;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgSpline
extends DwgObject {
    private int scenario;
    private int degree;
    private double fitTolerance;
    private double[] beginTanVector;
    private double[] endTanVector;
    private boolean rational;
    private boolean closed;
    private boolean periodic;
    private double knotTolerance;
    private double controlTolerance;
    private double[] knotPoints;
    private double[][] controlPoints;
    private double[] weights;
    private double[][] fitPoints;

    public void readDwgSplineV15(int[] data, int offset) throws Exception {
        double z;
        double y;
        int deg;
        int sc;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.scenario = sc = ((Integer)v.get(1)).intValue();
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.degree = deg = ((Integer)v.get(1)).intValue();
        int knotsNumber = 0;
        int controlPointsNumber = 0;
        int fitPointsNumber = 0;
        boolean weight = false;
        if (sc == 2) {
            double ft;
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.fitTolerance = ft = ((Double)v.get(1)).doubleValue();
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
            double[] coord = new double[]{x, y, z};
            this.beginTanVector = coord;
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
            coord = new double[]{x, y, z};
            this.endTanVector = coord;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            fitPointsNumber = (Integer)v.get(1);
        } else if (sc == 1) {
            double ctol;
            double ktol;
            boolean per;
            boolean closed;
            boolean rat;
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.rational = rat = ((Boolean)v.get(1)).booleanValue();
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.closed = closed = ((Boolean)v.get(1)).booleanValue();
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.periodic = per = ((Boolean)v.get(1)).booleanValue();
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.knotTolerance = ktol = ((Double)v.get(1)).doubleValue();
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.controlTolerance = ctol = ((Double)v.get(1)).doubleValue();
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            knotsNumber = (Integer)v.get(1);
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            controlPointsNumber = (Integer)v.get(1);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            weight = (Boolean)v.get(1);
        } else {
            System.out.println("ERROR: Escenario desconocido");
        }
        if (knotsNumber > 0) {
            double[] knotpts = new double[knotsNumber];
            for (int i = 0; i < knotsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                knotpts[i] = (Double)v.get(1);
            }
            this.knotPoints = knotpts;
        }
        if (controlPointsNumber > 0) {
            double[][] ctrlpts = new double[controlPointsNumber][3];
            double[] weights = new double[controlPointsNumber];
            for (int i = 0; i < controlPointsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double x = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double y2 = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double z2 = (Double)v.get(1);
                ctrlpts[i][0] = x;
                ctrlpts[i][1] = y2;
                ctrlpts[i][2] = z2;
                if (!weight) continue;
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                weights[i] = (Double)v.get(1);
            }
            this.controlPoints = ctrlpts;
            if (weight) {
                this.weights = weights;
            }
        }
        if (fitPointsNumber > 0) {
            double[][] fitpts = new double[fitPointsNumber][3];
            for (int i = 0; i < fitPointsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double x = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                y = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                z = (Double)v.get(1);
                fitpts[i][0] = x;
                fitpts[i][1] = y;
                fitpts[i][2] = z;
            }
            this.fitPoints = fitpts;
        }
        bitPos = this.readObjectTailV15(data, bitPos);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public double[][] getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(double[][] controlPoints) {
        this.controlPoints = controlPoints;
    }

    public double[][] getFitPoints() {
        return this.fitPoints;
    }

    public void setFitPoints(double[][] fitPoints) {
        this.fitPoints = fitPoints;
    }

    public double[] getKnotPoints() {
        return this.knotPoints;
    }

    public void setKnotPoints(double[] knotPoints) {
        this.knotPoints = knotPoints;
    }

    public int getScenario() {
        return this.scenario;
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public Object clone() {
        DwgSpline dwgSpline = new DwgSpline();
        dwgSpline.setType(this.type);
        dwgSpline.setHandle(this.handle);
        dwgSpline.setVersion(this.version);
        dwgSpline.setMode(this.mode);
        dwgSpline.setLayerHandle(this.layerHandle);
        dwgSpline.setColor(this.color);
        dwgSpline.setNumReactors(this.numReactors);
        dwgSpline.setNoLinks(this.noLinks);
        dwgSpline.setLinetypeFlags(this.linetypeFlags);
        dwgSpline.setPlotstyleFlags(this.plotstyleFlags);
        dwgSpline.setSizeInBits(this.sizeInBits);
        dwgSpline.setExtendedData(this.extendedData);
        dwgSpline.setGraphicData(this.graphicData);
        dwgSpline.setScenario(this.scenario);
        dwgSpline.setDegree(this.degree);
        dwgSpline.setFitTolerance(this.fitTolerance);
        dwgSpline.setBeginTanVector(this.beginTanVector);
        dwgSpline.setEndTanVector(this.endTanVector);
        dwgSpline.setRational(this.rational);
        dwgSpline.setClosed(this.closed);
        dwgSpline.setPeriodic(this.periodic);
        dwgSpline.setKnotTolerance(this.knotTolerance);
        dwgSpline.setControlTolerance(this.controlTolerance);
        dwgSpline.setKnotPoints(this.knotPoints);
        dwgSpline.setControlPoints(this.controlPoints);
        dwgSpline.setWeights(this.weights);
        dwgSpline.setFitPoints(this.fitPoints);
        return dwgSpline;
    }

    public double[] getBeginTanVector() {
        return this.beginTanVector;
    }

    public void setBeginTanVector(double[] beginTanVector) {
        this.beginTanVector = beginTanVector;
    }

    public double getControlTolerance() {
        return this.controlTolerance;
    }

    public void setControlTolerance(double controlTolerance) {
        this.controlTolerance = controlTolerance;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public double[] getEndTanVector() {
        return this.endTanVector;
    }

    public void setEndTanVector(double[] endTanVector) {
        this.endTanVector = endTanVector;
    }

    public double getFitTolerance() {
        return this.fitTolerance;
    }

    public void setFitTolerance(double fitTolerance) {
        this.fitTolerance = fitTolerance;
    }

    public double getKnotTolerance() {
        return this.knotTolerance;
    }

    public void setKnotTolerance(double knotTolerance) {
        this.knotTolerance = knotTolerance;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public boolean isRational() {
        return this.rational;
    }

    public void setRational(boolean rational) {
        this.rational = rational;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }
}

