/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusBar
extends JPanel
implements PositionListener,
RenderingListener {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.StatusBar.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.StatusBar.Imperial";
    private static final double METER_TO_FEET = 3.280839895;
    private static final double METER_TO_MILE = 6.21371192E-4;
    private static final int MAX_ALPHA = 254;
    private WorldWindow eventSource;
    protected final JLabel latDisplay = new JLabel("");
    protected final JLabel lonDisplay = new JLabel("Off globe");
    protected final JLabel altDisplay = new JLabel("");
    protected final JLabel eleDisplay = new JLabel("");
    private boolean showNetworkStatus = true;
    private String elevationUnit = "gov.nasa.worldwind.StatusBar.Metric";

    public StatusBar() {
        super(new GridLayout(1, 0));
        final JLabel jLabel = new JLabel("Downloading");
        this.altDisplay.setHorizontalAlignment(0);
        this.latDisplay.setHorizontalAlignment(0);
        this.lonDisplay.setHorizontalAlignment(0);
        this.eleDisplay.setHorizontalAlignment(0);
        this.add(this.altDisplay);
        this.add(this.latDisplay);
        this.add(this.lonDisplay);
        this.add(this.eleDisplay);
        this.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(new Color(255, 0, 0, 0));
        Timer timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!StatusBar.this.showNetworkStatus) {
                    if (jLabel.getText().length() > 0) {
                        jLabel.setText("");
                    }
                    return;
                }
                if (WorldWind.getNetworkStatus().isNetworkUnavailable()) {
                    jLabel.setText("No Network");
                    jLabel.setForeground(new Color(255, 0, 0, 255));
                    return;
                }
                Color color = jLabel.getForeground();
                int n = color.getAlpha();
                if (WorldWind.getRetrievalService().hasActiveTasks()) {
                    jLabel.setText("Downloading");
                    n = n >= 254 ? 254 : (n < 16 ? 16 : Math.min(254, n + 20));
                } else {
                    n = Math.max(0, n - 20);
                }
                jLabel.setForeground(new Color(255, 0, 0, n));
            }
        });
        timer.start();
    }

    public void setEventSource(WorldWindow worldWindow) {
        if (this.eventSource != null) {
            this.eventSource.removePositionListener(this);
            this.eventSource.removeRenderingListener(this);
        }
        if (worldWindow != null) {
            worldWindow.addPositionListener(this);
            worldWindow.addRenderingListener(this);
        }
        this.eventSource = worldWindow;
    }

    public boolean isShowNetworkStatus() {
        return this.showNetworkStatus;
    }

    public void setShowNetworkStatus(boolean bl) {
        this.showNetworkStatus = bl;
    }

    public void moved(PositionEvent positionEvent) {
        this.handleCursorPositionChange(positionEvent);
    }

    public WorldWindow getEventSource() {
        return this.eventSource;
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationUnit = string;
    }

    protected String makeCursorElevationDescription(double d) {
        String string = UNIT_IMPERIAL.equals(this.elevationUnit) ? String.format("Elev %,7d feet", (int)(d * 3.280839895)) : String.format("Elev %,7d meters", (int)d);
        return string;
    }

    protected String makeEyeAltitudeDescription(double d) {
        String string = UNIT_IMPERIAL.equals(this.elevationUnit) ? String.format("Altitude %,7d mi", (int)Math.round(d * 6.21371192E-4)) : String.format("Altitude %,7d km", (int)Math.round(d / 1000.0));
        return string;
    }

    private void handleCursorPositionChange(PositionEvent positionEvent) {
        Position position = positionEvent.getPosition();
        if (position != null) {
            String string = String.format("Lat %7.4f\u00b0", position.getLatitude().getDegrees());
            String string2 = String.format("Lon %7.4f\u00b0", position.getLongitude().getDegrees());
            String string3 = this.makeCursorElevationDescription(this.eventSource.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
            this.latDisplay.setText(string);
            this.lonDisplay.setText(string2);
            this.eleDisplay.setText(string3);
        } else {
            this.latDisplay.setText("");
            this.lonDisplay.setText("Off globe");
            this.eleDisplay.setText("");
        }
    }

    public void stageChanged(RenderingEvent renderingEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (StatusBar.this.eventSource.getView() != null && StatusBar.this.eventSource.getView().getEyePosition() != null) {
                    StatusBar.this.altDisplay.setText(StatusBar.this.makeEyeAltitudeDescription(StatusBar.this.eventSource.getView().getEyePosition().getElevation()));
                } else {
                    StatusBar.this.altDisplay.setText("Altitude");
                }
            }
        });
    }
}

