/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.SurfaceShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfacePolygon
extends SurfaceShape {
    private static final double TO_RADIANS = Math.PI / 180;

    public SurfacePolygon(Iterable<LatLon> iterable, Color color, Color color2) {
        super(iterable, color, color2, null);
    }

    public SurfacePolygon(Iterable<LatLon> iterable) {
        super(iterable, null, null, null);
    }

    public SurfacePolygon(Iterable<LatLon> iterable, Color color, Color color2, Dimension dimension) {
        super(iterable, color, color2, dimension);
    }

    @Override
    protected final BufferedImage drawShape(Globe globe, Sector sector, BufferedImage bufferedImage) {
        Object object;
        double d = globe.getRadiusAt(sector.getMinLatitude(), sector.getMinLongitude());
        double d2 = globe.getRadiusAt(sector.getMaxLatitude(), sector.getMaxLongitude());
        double d3 = d * sector.getMinLongitude().radians;
        double d4 = d * sector.getMinLatitude().radians;
        double d5 = d2 * sector.getMaxLongitude().radians;
        double d6 = d2 * sector.getMaxLatitude().radians;
        double d7 = d6 - d4;
        double d8 = d5 - d3;
        double d9 = d7 > 0.0 ? (double)(-(bufferedImage.getHeight() - 1)) / d7 : 0.0;
        double d10 = d8 > 0.0 ? (double)(bufferedImage.getWidth() - 1) / d8 : 0.0;
        double d11 = 0.0;
        if (sector.getMaxLongitude().getDegrees() == 180.0 && sector.getDeltaLonDegrees() < 180.0) {
            d11 = -180.0;
        }
        if (sector.getMinLongitude().getDegrees() == -180.0 && sector.getDeltaLonDegrees() < 180.0) {
            d11 = 180.0;
        }
        GeneralPath generalPath = new GeneralPath();
        Iterator<LatLon> iterator = this.getPositions().iterator();
        if (!iterator.hasNext()) {
            return bufferedImage;
        }
        Object object2 = this.computeDrawLatLon(iterator.next(), sector, d11);
        double d12 = globe.getRadiusAt(((LatLon)object2).getLatitude(), ((LatLon)object2).getLongitude());
        double d13 = d10 * (d12 * ((LatLon)object2).getLongitude().radians - d12 * (Math.PI / 180) * d11 - d3);
        double d14 = d9 * (d12 * ((LatLon)object2).getLatitude().radians - d4);
        generalPath.moveTo((float)d13, (float)d14);
        while (iterator.hasNext()) {
            object = this.computeDrawLatLon(iterator.next(), sector, d11);
            int n = (int)Math.max(1.0, this.getNumEdgeIntervalsPerDegree() * LatLon.greatCircleDistance((LatLon)object2, (LatLon)object).degrees);
            double d15 = 1.0 / (double)n;
            for (int i = 1; i < n; ++i) {
                LatLon latLon = LatLon.interpolate((double)i * d15, (LatLon)object2, (LatLon)object);
                d12 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
                d13 = d10 * (d12 * latLon.getLongitude().radians - d12 * (Math.PI / 180) * d11 - d3);
                d14 = d9 * (d12 * latLon.getLatitude().radians - d4);
                generalPath.lineTo((float)d13, (float)d14);
            }
            d12 = globe.getRadiusAt(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude());
            d13 = d10 * (d12 * ((LatLon)object).getLongitude().radians - d12 * (Math.PI / 180) * d11 - d3);
            d14 = d9 * (d12 * ((LatLon)object).getLatitude().radians - d4);
            generalPath.lineTo((float)d13, (float)d14);
            object2 = object;
        }
        object = bufferedImage.createGraphics();
        ((Graphics2D)object).setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        if (this.isAntiAlias()) {
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.isDrawInterior()) {
            ((Graphics2D)object).setPaint(this.getPaint());
            ((Graphics2D)object).fill(generalPath);
        }
        if (this.isDrawBorder()) {
            ((Graphics2D)object).setPaint(this.getBorderColor());
            ((Graphics2D)object).setStroke(this.getStroke());
            ((Graphics2D)object).draw(generalPath);
        }
        return bufferedImage;
    }

    private LatLon computeDrawLatLon(LatLon latLon, Sector sector, double d) {
        int n = sector.getMaxLongitude().degrees - latLon.getLongitude().getDegrees() > 180.0 ? 360 : 0;
        n = latLon.getLongitude().getDegrees() - sector.getMinLongitude().getDegrees() > 180.0 ? -360 : n;
        return LatLon.fromDegrees(latLon.getLatitude().getDegrees(), latLon.getLongitude().getDegrees() + (double)n + d);
    }
}

