/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GL;

public class MultiLineTextRenderer {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final String EFFECT_NONE = "render.MultiLineTextRenderer.EffectNone";
    public static final String EFFECT_SHADOW = "render.MultiLineTextRenderer.EffectShadow";
    public static final String EFFECT_OUTLINE = "render.MultiLineTextRenderer.EffectOutline";
    private TextRenderer textRenderer;
    private int lineSpacing = 0;
    private int lineHeight = 14;
    private int textAlign = 0;
    private String continuationString = "...";
    private Color textColor = Color.DARK_GRAY;
    private Color backColor = Color.LIGHT_GRAY;
    private Color linkColor = Color.BLUE;

    public MultiLineTextRenderer(TextRenderer textRenderer) {
        if (textRenderer == null) {
            String string = Logging.getMessage("nullValue.TextRendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRenderer = textRenderer;
    }

    public MultiLineTextRenderer(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRenderer = new TextRenderer(font, true, true);
        this.textRenderer.setUseVertexArrays(false);
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int n) {
        this.lineSpacing = n;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int n) {
        this.lineHeight = n;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int n) {
        if (n != 0 && n != 1 && n != 2) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textAlign = n;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
        this.textRenderer.setColor(color);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.backColor = color;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.linkColor = color;
    }

    public void setContinuationString(String string) {
        this.continuationString = string;
    }

    public double getMaxLineHeight(TextRenderer textRenderer) {
        return textRenderer.getBounds("_\u00c9").getHeight();
    }

    public Rectangle getBounds(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n = 0;
        int n2 = 0;
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            Rectangle2D rectangle2D = this.textRenderer.getBounds(stringArray[i]);
            n = (int)Math.max(rectangle2D.getWidth(), (double)n);
            n2 = (int)Math.max(rectangle2D.getHeight(), (double)this.lineHeight);
        }
        this.lineHeight = n2 = (int)Math.max(this.getMaxLineHeight(this.textRenderer), (double)n2);
        return new Rectangle(stringArray.length, this.lineHeight, n, stringArray.length * n2 + (stringArray.length - 1) * this.lineSpacing);
    }

    public void draw(String string, int n, int n2) {
        this.draw(string, n, n2, this.lineHeight);
    }

    public void draw(String string, int n, int n2, String string2) {
        this.draw(string, n, n2, this.lineHeight, string2);
    }

    public void draw(String string, int n, int n2, int n3, String string2) {
        if (string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2.equals(EFFECT_SHADOW)) {
            this.textRenderer.setColor(this.backColor);
            this.draw(string, n + 1, n2 - 1, n3);
            this.textRenderer.setColor(this.textColor);
        } else if (string2.equals(EFFECT_OUTLINE)) {
            this.textRenderer.setColor(this.backColor);
            this.draw(string, n, n2 + 1, n3);
            this.draw(string, n + 1, n2, n3);
            this.draw(string, n, n2 - 1, n3);
            this.draw(string, n - 1, n2, n3);
            this.textRenderer.setColor(this.textColor);
        }
        this.draw(string, n, n2, n3);
    }

    public void draw(String string, int n, int n2, int n3) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n4 = n;
            if (this.textAlign == 1) {
                n4 = n - (int)(this.textRenderer.getBounds(stringArray[i]).getWidth() / 2.0);
            } else if (this.textAlign == 2) {
                n4 = n - (int)this.textRenderer.getBounds(stringArray[i]).getWidth();
            }
            this.textRenderer.draw3D(stringArray[i], (float)n4, (float)(n2 -= n3), 0.0f, 1.0f);
            n2 -= this.lineSpacing;
        }
    }

    public void pick(String string, int n, int n2, int n3, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext == null) {
            String string3 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (pickSupport == null) {
            String string4 = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n4 = n;
            if (this.textAlign == 1) {
                n4 = n - (int)(this.textRenderer.getBounds(stringArray[i]).getWidth() / 2.0);
            } else if (this.textAlign == 2) {
                n4 = n - (int)this.textRenderer.getBounds(stringArray[i]).getWidth();
            }
            this.drawLineWithUniqueColors(stringArray[i], n4, n2 -= n3, drawContext, pickSupport, object, position);
            n2 -= this.lineSpacing;
        }
    }

    private void drawLineWithUniqueColors(String string, int n, int n2, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        float f = this.textRenderer.getCharWidth(' ');
        float f2 = n;
        float f3 = n2;
        String string2 = string.trim();
        int n3 = 0;
        int n4 = string2.indexOf(32, n3 + 1);
        while (n3 < string2.length()) {
            if (n4 == -1) {
                n4 = string2.length();
            }
            String string3 = string2.substring(n3, n4);
            Rectangle2D rectangle2D = this.textRenderer.getBounds(string3);
            Rectangle2D rectangle2D2 = this.textRenderer.getBounds(string2.substring(0, n3));
            float f4 = string3.charAt(0) == ' ' ? f : 0.0f;
            f2 = (float)n + (n3 > 0 ? (float)rectangle2D2.getWidth() + (float)rectangle2D2.getX() : 0.0f);
            Color color = drawContext.getUniquePickColor();
            int n5 = color.getRGB();
            PickedObject pickedObject = new PickedObject(n5, object, position, false);
            pickedObject.setValue("gov.nasa.worldwind.avkey.Text", string3.trim());
            pickSupport.addPickableObject(pickedObject);
            drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            this.drawFilledRectangle(drawContext, (double)f2 + rectangle2D.getX(), (double)f3 - rectangle2D.getHeight() - rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            n3 = n4;
            if (n3 >= string2.length() - 1) continue;
            n4 = string2.indexOf(32, n3 + 1);
        }
    }

    public String wrap(String string, Dimension dimension) {
        int n;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (dimension == null) {
            String string3 = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        int n2 = (int)dimension.getWidth();
        int n3 = (int)dimension.getHeight();
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.wrapLine(stringArray[n], n2);
        }
        n = 0;
        boolean bl = false;
        double d = this.getMaxLineHeight(this.textRenderer);
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            String[] stringArray2 = stringArray[i].split("\n");
            for (int j = 0; j < stringArray2.length && !bl; ++j) {
                if (n3 <= 0 || (double)n + d <= (double)n3) {
                    stringBuffer.append(stringArray2[j]);
                    n = (int)((double)n + (d + (double)this.lineSpacing));
                    if (j >= stringArray2.length - 1) continue;
                    stringBuffer.append('\n');
                    continue;
                }
                bl = true;
            }
            if (i >= stringArray.length - 1 || bl) continue;
            stringBuffer.append('\n');
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append(this.continuationString);
        }
        return stringBuffer.toString();
    }

    private String wrapLine(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.trim();
        Rectangle2D rectangle2D = this.textRenderer.getBounds(string2);
        if (rectangle2D.getWidth() > (double)n) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            int n3 = string2.indexOf(32, n2 + 1);
            while (n2 < string2.length()) {
                if (n3 == -1) {
                    n3 = string2.length();
                }
                String string3 = string2.substring(n2, n3);
                String string4 = stringBuffer2 + string3;
                if (this.textRenderer.getBounds(string4).getWidth() <= (double)n) {
                    stringBuffer2.append(string3);
                } else if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append('\n');
                    stringBuffer2.delete(0, stringBuffer2.length());
                    stringBuffer2.append(string3.trim());
                } else {
                    stringBuffer2.append(string3.trim());
                }
                if ((n2 = n3) >= string2.length() - 1) continue;
                n3 = string2.indexOf(32, n2 + 1);
            }
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean containsHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Pattern pattern = Pattern.compile("<[^\\s].*?>");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static String processLineBreaksHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        string = string.replaceAll("\n", "");
        string = string.replaceAll("(?i)<br\\s?.*?>", "\n");
        string = string.replaceAll("(?i)<p\\s?.*?>", "");
        string = string.replaceAll("(?i)</p>", "\n\n");
        return string;
    }

    public static String removeTagsHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.replaceAll("<[^\\s].*?>", "");
    }

    public static String getAttributeFromTagHTML(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Pattern pattern = Pattern.compile("(?i)" + string2.toLowerCase() + "=\"([^\"].*?)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public Rectangle2D getBoundsHTML(String string, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        return this.getBoundsHTML(string, drawState);
    }

    private Rectangle2D getBoundsHTML(String string, DrawState drawState) {
        String string2 = "(<[^\\s].*?>)|(\\s)";
        Pattern pattern = Pattern.compile(string2);
        DrawState drawState2 = new DrawState(drawState);
        double d = 0.0;
        double d2 = 0.0;
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            Rectangle2D rectangle2D;
            int n = 0;
            double d3 = 0.0;
            double d4 = this.getMaxLineHeight(drawState2.textRenderer);
            stringBuffer.delete(0, stringBuffer.length());
            Matcher matcher = pattern.matcher(stringArray[i]);
            while (matcher.find()) {
                if (matcher.group().equals(" ")) {
                    stringBuffer.append(stringArray[i].substring(n, matcher.start()));
                    n = matcher.start();
                    continue;
                }
                stringBuffer.append(stringArray[i].substring(n, matcher.start()));
                if (stringBuffer.length() > 0) {
                    rectangle2D = drawState2.textRenderer.getBounds(this.counterTrim(stringBuffer));
                    d3 += rectangle2D.getWidth() + rectangle2D.getX();
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n = matcher.end();
                drawState2.update(matcher.group(), false);
                d4 = (int)Math.max(this.getMaxLineHeight(drawState2.textRenderer), d4);
            }
            if (n < stringArray[i].length()) {
                stringBuffer.append(stringArray[i].substring(n));
                if (stringBuffer.length() > 0) {
                    rectangle2D = drawState2.textRenderer.getBounds(stringBuffer);
                    d3 += rectangle2D.getWidth() + rectangle2D.getX();
                    d4 = (int)Math.max(rectangle2D.getHeight(), d4);
                }
            }
            d = Math.max(d, d3);
            d2 += d4 + (double)this.lineSpacing;
        }
        return new Rectangle(stringArray.length, (int)((d2 -= (double)this.lineSpacing) / (double)stringArray.length), (int)Math.round(d), (int)Math.round(d2));
    }

    public void drawHTML(String string, int n, int n2, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = "(<[^\\s].*?>)|(\\s)";
        Pattern pattern = Pattern.compile(string4);
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        int n3 = n;
        double d = n2;
        drawState.textRenderer.begin3DRendering();
        drawState.textRenderer.setColor(this.textColor);
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            double d2 = n3;
            Rectangle2D rectangle2D = this.getBoundsHTML(stringArray[i], drawState);
            if (this.textAlign == 1) {
                d2 = n - (int)(rectangle2D.getWidth() / 2.0);
            } else if (this.textAlign == 2) {
                d2 = n - (int)rectangle2D.getWidth();
            }
            d -= rectangle2D.getHeight();
            int n4 = 0;
            stringBuffer.delete(0, stringBuffer.length());
            Matcher matcher = pattern.matcher(stringArray[i]);
            while (matcher.find()) {
                if (matcher.group().equals(" ")) {
                    stringBuffer.append(stringArray[i].substring(n4, matcher.start()));
                    n4 = matcher.start();
                    continue;
                }
                stringBuffer.append(stringArray[i].substring(n4, matcher.start()));
                if (stringBuffer.length() > 0) {
                    drawState.textRenderer.draw3D(stringBuffer, (float)((int)Math.round(d2)), (float)((int)Math.round(d)), 0.0f, 1.0f);
                    Rectangle2D rectangle2D2 = drawState.textRenderer.getBounds(this.counterTrim(stringBuffer));
                    d2 += rectangle2D2.getWidth() + rectangle2D2.getX();
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n4 = matcher.end();
                drawState.update(matcher.group(), true);
            }
            if (n4 < stringArray[i].length()) {
                stringBuffer.append(stringArray[i].substring(n4));
                if (stringBuffer.length() > 0) {
                    drawState.textRenderer.draw3D(stringBuffer, (float)((int)Math.round(d2)), (float)((int)Math.round(d)), 0.0f, 1.0f);
                }
            }
            d -= (double)this.lineSpacing;
        }
        drawState.textRenderer.end3DRendering();
    }

    public void pickHTML(String string, int n, int n2, TextRendererCache textRendererCache, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (drawContext == null) {
            String string4 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (pickSupport == null) {
            String string5 = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        String string6 = "(<[^\\s].*?>)|(\\s)";
        Pattern pattern = Pattern.compile(string6);
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        double d = n;
        double d2 = n2;
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string7;
            Rectangle2D rectangle2D;
            Rectangle2D rectangle2D2;
            String string8;
            String string9;
            double d3 = n;
            Rectangle2D rectangle2D3 = this.getBoundsHTML(stringArray[i], drawState);
            if (this.textAlign == 1) {
                d3 = n - (int)(rectangle2D3.getWidth() / 2.0);
            } else if (this.textAlign == 2) {
                d3 = n - (int)rectangle2D3.getWidth();
            }
            d2 -= rectangle2D3.getHeight();
            DrawState drawState2 = new DrawState(drawState);
            DrawState drawState3 = new DrawState(drawState);
            int n3 = -1;
            int n4 = 0;
            stringBuffer.delete(0, stringBuffer.length());
            Matcher matcher = pattern.matcher(stringArray[i]);
            while (matcher.find()) {
                if (matcher.group().equals(" ")) {
                    string9 = n3 == -1 ? stringArray[i].substring(n4, matcher.start()) : stringArray[i].substring(n3, matcher.start());
                    string8 = n3 == -1 ? stringArray[i].substring(0, n4) : stringArray[i].substring(0, n3);
                    rectangle2D2 = this.getBoundsHTML(string9, drawState3);
                    rectangle2D = this.getBoundsHTML(string8, drawState2);
                    string7 = drawState3.getDrawAttributes().hyperlink;
                    d = d3 + (double)(n4 > 0 ? (float)rectangle2D.getWidth() + (float)rectangle2D.getX() : 0.0f);
                    this.pickWord(string9, string7, d, d2, rectangle2D2, drawContext, pickSupport, object, position);
                    drawState3 = new DrawState(drawState);
                    n4 = matcher.start();
                    n3 = -1;
                    continue;
                }
                n3 = n3 == -1 ? n4 : n3;
                n4 = matcher.end();
                drawState.update(matcher.group(), false);
                drawState3.getDrawAttributes().hyperlink = drawState.getDrawAttributes().hyperlink != null ? drawState.getDrawAttributes().hyperlink : drawState3.getDrawAttributes().hyperlink;
            }
            if (n4 < stringArray[i].length() || n3 != -1) {
                string9 = n3 == -1 ? stringArray[i].substring(n4) : stringArray[i].substring(n3);
                string8 = n3 == -1 ? stringArray[i].substring(0, n4) : stringArray[i].substring(0, n3);
                rectangle2D2 = this.getBoundsHTML(string9, drawState3);
                rectangle2D = this.getBoundsHTML(string8, drawState2);
                string7 = drawState3.getDrawAttributes().hyperlink;
                d = d3 + (double)(n4 > 0 ? (float)rectangle2D.getWidth() + (float)rectangle2D.getX() : 0.0f);
                this.pickWord(string9, string7, d, d2, rectangle2D2, drawContext, pickSupport, object, position);
            }
            d2 -= (double)this.lineSpacing;
        }
    }

    private void pickWord(String string, String string2, double d, double d2, Rectangle2D rectangle2D, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        PickedObject pickedObject = new PickedObject(n, object, position, false);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Text", MultiLineTextRenderer.removeTagsHTML(string.trim()));
        if (string2 != null) {
            pickedObject.setValue("gov.nasa.worldwind.avkey.URL", string2);
        }
        pickSupport.addPickableObject(pickedObject);
        drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        this.drawFilledRectangle(drawContext, d, d2 - rectangle2D.getHeight() / 5.0, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public String wrapHTML(String string, Dimension dimension, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (dimension == null) {
            String string3 = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (textRendererCache == null) {
            String string4 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        String string5 = "(<[^\\s].*?>)|(\\s)";
        Pattern pattern = Pattern.compile(string5);
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            String string6 = stringArray[i].trim();
            double d = this.getMaxLineHeight(drawState.textRenderer);
            Rectangle2D rectangle2D = this.getBoundsHTML(string6, drawState);
            if (rectangle2D.getWidth() > (double)n) {
                Rectangle2D rectangle2D2;
                String string7;
                StringBuffer stringBuffer2 = new StringBuffer();
                double d2 = 0.0;
                double d3 = 0.0;
                int n5 = -1;
                int n6 = 0;
                Matcher matcher = pattern.matcher(string6);
                while (matcher.find() && !bl) {
                    if (matcher.group().equals(" ")) {
                        string7 = string6.substring(n6, matcher.start());
                        rectangle2D2 = this.getBoundsHTML(string7, drawState);
                        d3 += rectangle2D2.getWidth() + rectangle2D2.getX();
                        if (n5 != -1) {
                            string7 = string6.substring(n5, matcher.start());
                        }
                        if (d2 + d3 <= (double)n) {
                            stringBuffer2.append(string7);
                            d2 += d3;
                        } else {
                            string7 = string7.trim();
                            rectangle2D2 = this.getBoundsHTML(string7, drawState);
                            d3 = rectangle2D2.getWidth() + rectangle2D2.getX();
                            if (stringBuffer2.length() != 0) {
                                if (n2 <= 0 || (double)n3 + d <= (double)n2) {
                                    stringBuffer.append(stringBuffer2);
                                    stringBuffer.append('\n');
                                    n3 = (int)((double)n3 + (d + (double)this.lineSpacing));
                                    ++n4;
                                    stringBuffer2.delete(0, stringBuffer2.length());
                                    stringBuffer2.append(string7);
                                    d2 = d3;
                                    d = this.getMaxLineHeight(drawState.textRenderer);
                                } else {
                                    bl = true;
                                }
                            } else {
                                stringBuffer2.append(string7);
                                d2 = d3;
                            }
                        }
                        n6 = matcher.start();
                        d3 = 0.0;
                        n5 = -1;
                        continue;
                    }
                    if (matcher.start() > n6) {
                        string7 = string6.substring(n6, matcher.start());
                        rectangle2D2 = this.getBoundsHTML(this.counterTrim(string7), drawState);
                        d3 += rectangle2D2.getWidth() + rectangle2D2.getX();
                    }
                    n5 = n5 == -1 ? n6 : n5;
                    n6 = matcher.end();
                    drawState.update(matcher.group(), false);
                    d = (int)Math.max(this.getMaxLineHeight(drawState.textRenderer), d);
                }
                if (!(n6 >= string6.length() && n5 == -1 || bl)) {
                    string7 = "";
                    if (n6 < string6.length()) {
                        string7 = string6.substring(n6);
                        rectangle2D2 = this.getBoundsHTML(string7, drawState);
                        d3 += rectangle2D2.getWidth() + rectangle2D2.getX();
                    }
                    if (n5 != -1) {
                        string7 = string6.substring(n5);
                    }
                    if (d2 + d3 <= (double)n) {
                        stringBuffer2.append(string7);
                    } else {
                        string7 = string7.trim();
                        if (stringBuffer2.length() != 0) {
                            if (n2 <= 0 || (double)n3 + d <= (double)n2) {
                                stringBuffer.append(stringBuffer2);
                                stringBuffer.append('\n');
                                n3 = (int)((double)n3 + (d + (double)this.lineSpacing));
                                ++n4;
                                stringBuffer2.delete(0, stringBuffer2.length());
                                stringBuffer2.append(string7);
                                d = this.getMaxLineHeight(drawState.textRenderer);
                            } else {
                                bl = true;
                            }
                        } else {
                            stringBuffer2.append(string7);
                        }
                    }
                    if (n2 <= 0 || (double)n3 + d <= (double)n2) {
                        stringBuffer.append(stringBuffer2);
                        n3 = (int)((double)n3 + (d + (double)this.lineSpacing));
                        ++n4;
                    } else {
                        bl = true;
                    }
                }
            } else if (n2 <= 0 || (double)n3 + d <= (double)n2) {
                stringBuffer.append(string6);
                n3 = (int)((double)n3 + (d + (double)this.lineSpacing));
                ++n4;
            } else {
                bl = true;
            }
            if (i >= stringArray.length - 1 || bl) continue;
            stringBuffer.append('\n');
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append(this.continuationString);
        }
        return stringBuffer.toString();
    }

    private String counterTrim(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        if (stringBuffer2.substring(stringBuffer2.length() - 1).equals(" ")) {
            stringBuffer2.setCharAt(stringBuffer.length() - 1, 't');
        }
        if (stringBuffer2.substring(0, 1).equals(" ")) {
            stringBuffer2.setCharAt(0, 't');
        }
        return stringBuffer2.toString();
    }

    private String counterTrim(String string) {
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.substring(stringBuffer.length() - 1).equals(" ")) {
            stringBuffer.setCharAt(string.length() - 1, 't');
        }
        if (stringBuffer.substring(0, 1).equals(" ")) {
            stringBuffer.setCharAt(0, 't');
        }
        return stringBuffer.toString();
    }

    private void drawFilledRectangle(DrawContext drawContext, double d, double d2, double d3, double d4) {
        GL gL = drawContext.getGL();
        gL.glBegin(9);
        gL.glVertex3d(d, d2, 0.0);
        gL.glVertex3d(d + d3 - 1.0, d2, 0.0);
        gL.glVertex3d(d + d3 - 1.0, d2 + d4 - 1.0, 0.0);
        gL.glVertex3d(d, d2 + d4 - 1.0, 0.0);
        gL.glVertex3d(d, d2, 0.0);
        gL.glEnd();
    }

    private Color applyTextAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * this.textColor.getAlpha() / 255);
    }

    private class DrawState {
        private ArrayList<DrawAttributes> stack = new ArrayList();
        private TextRendererCache renderers;
        public TextRenderer textRenderer;

        public DrawState(TextRendererCache textRendererCache, Font font, String string, Color color) {
            this.stack.add(new DrawAttributes(font, string, color));
            this.renderers = textRendererCache;
            this.textRenderer = this.getTextRenderer(font);
        }

        public DrawState(DrawState drawState) {
            for (DrawAttributes drawAttributes : drawState.stack) {
                this.stack.add(new DrawAttributes(drawAttributes.font, drawAttributes.hyperlink, drawAttributes.color));
            }
            this.renderers = drawState.renderers;
            this.textRenderer = drawState.textRenderer;
        }

        public DrawAttributes getDrawAttributes() {
            if (this.stack.size() < 1) {
                return null;
            }
            return this.stack.get(this.stack.size() - 1);
        }

        private TextRenderer getTextRenderer(Font font) {
            TextRenderer textRenderer = this.renderers.get(font);
            if (textRenderer == null) {
                textRenderer = new TextRenderer(font, true, true);
                textRenderer.setUseVertexArrays(false);
                this.renderers.add(font, textRenderer);
            }
            return textRenderer;
        }

        private Font getFont(Font font, boolean bl, boolean bl2) {
            int n = bl ? (bl2 ? 3 : 1) : (bl2 ? 2 : 0);
            return font.deriveFont(n);
        }

        public TextRenderer update(String string, boolean bl) {
            DrawAttributes drawAttributes = this.getDrawAttributes();
            boolean bl2 = false;
            if (string.equalsIgnoreCase("<b>")) {
                this.stack.add(new DrawAttributes(this.getFont(drawAttributes.font, true, drawAttributes.font.isItalic()), drawAttributes.hyperlink, drawAttributes.color));
                bl2 = true;
            } else if (string.equalsIgnoreCase("</b>")) {
                if (this.stack.size() > 1) {
                    this.stack.remove(this.stack.size() - 1);
                }
                bl2 = true;
            } else if (string.equalsIgnoreCase("<i>")) {
                this.stack.add(new DrawAttributes(this.getFont(drawAttributes.font, drawAttributes.font.isBold(), true), drawAttributes.hyperlink, drawAttributes.color));
                bl2 = true;
            } else if (string.equalsIgnoreCase("</i>")) {
                if (this.stack.size() > 1) {
                    this.stack.remove(this.stack.size() - 1);
                }
                bl2 = true;
            } else if (string.toLowerCase().startsWith("<a ")) {
                this.stack.add(new DrawAttributes(drawAttributes.font, MultiLineTextRenderer.getAttributeFromTagHTML(string, "href"), MultiLineTextRenderer.this.applyTextAlpha(MultiLineTextRenderer.this.linkColor)));
                if (bl) {
                    this.textRenderer.setColor(MultiLineTextRenderer.this.applyTextAlpha(MultiLineTextRenderer.this.linkColor));
                }
            } else if (string.equalsIgnoreCase("</a>")) {
                if (this.stack.size() > 1) {
                    this.stack.remove(this.stack.size() - 1);
                }
                if (bl) {
                    this.textRenderer.setColor(this.getDrawAttributes().color);
                }
            } else if (string.toLowerCase().startsWith("<font ")) {
                String string2 = MultiLineTextRenderer.getAttributeFromTagHTML(string, "color");
                if (string2 != null) {
                    Color color = drawAttributes.color;
                    try {
                        color = MultiLineTextRenderer.this.applyTextAlpha(Color.decode(string2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stack.add(new DrawAttributes(drawAttributes.font, drawAttributes.hyperlink, color));
                    if (bl) {
                        this.textRenderer.setColor(color);
                    }
                }
            } else if (string.equalsIgnoreCase("</font>")) {
                if (this.stack.size() > 1) {
                    this.stack.remove(this.stack.size() - 1);
                }
                if (bl) {
                    this.textRenderer.setColor(this.getDrawAttributes().color);
                }
            }
            if (bl2) {
                if (bl) {
                    this.textRenderer.end3DRendering();
                }
                drawAttributes = this.getDrawAttributes();
                this.textRenderer = this.getTextRenderer(drawAttributes.font);
                if (bl) {
                    this.textRenderer.begin3DRendering();
                    this.textRenderer.setColor(drawAttributes.color);
                }
            }
            return this.textRenderer;
        }

        private class DrawAttributes {
            private final Font font;
            private String hyperlink;
            private final Color color;

            public DrawAttributes(Font font, String string, Color color) {
                this.font = font;
                this.hyperlink = string;
                this.color = color;
            }
        }
    }
}

