/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.rpf.wizard.FileSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.WizardProperties;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPFWizardUtil {
    public static final String SELECTED_FILE = "selectedFile";
    public static final String FILE_LIST = "fileList";
    public static final String IS_FILE_LIST_CURRENT = "isFileListCurrent";
    public static final String FILE_SET_LIST = "fileSetList";
    public static final String LAYER_LIST = "layerList";

    public static File getSelectedFile(WizardProperties wizardProperties) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file = null;
        Object object = wizardProperties.getProperty(SELECTED_FILE);
        if (object != null && object instanceof File) {
            file = (File)object;
        }
        return file;
    }

    public static void setSelectedFile(WizardProperties wizardProperties, File file) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        wizardProperties.setProperty(SELECTED_FILE, file);
    }

    public static List<File> getFileList(WizardProperties wizardProperties) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List list = null;
        Object object = wizardProperties.getProperty(FILE_LIST);
        if (object != null && object instanceof List) {
            list = (List)object;
        }
        return list;
    }

    public static void setFileList(WizardProperties wizardProperties, List<File> list) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        wizardProperties.setProperty(FILE_LIST, list);
    }

    public static boolean isFileListCurrent(WizardProperties wizardProperties) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        Boolean bl2 = wizardProperties.getBooleanProperty(IS_FILE_LIST_CURRENT);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public static void setFileListCurrent(WizardProperties wizardProperties, boolean bl) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        wizardProperties.setProperty(IS_FILE_LIST_CURRENT, bl);
    }

    public static List<FileSet> getFileSetList(WizardProperties wizardProperties) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List list = null;
        Object object = wizardProperties.getProperty(FILE_SET_LIST);
        if (object != null && object instanceof List) {
            list = (List)object;
        }
        return list;
    }

    public static void setFileSetList(WizardProperties wizardProperties, List<FileSet> list) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        wizardProperties.setProperty(FILE_SET_LIST, list);
    }

    public static List<Layer> getLayerList(WizardProperties wizardProperties) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List list = null;
        Object object = wizardProperties.getProperty(LAYER_LIST);
        if (object != null && object instanceof List) {
            list = (List)object;
        }
        return list;
    }

    public static void setLayerList(WizardProperties wizardProperties, List<Layer> list) {
        if (wizardProperties == null) {
            String string = "WizardProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        wizardProperties.setProperty(LAYER_LIST, list);
    }

    public static String makeLarger(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<font size=\"+1\">");
        stringBuilder.append(string);
        stringBuilder.append("</font>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String makeSmaller(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<font size=\"-2\">");
        stringBuilder.append(string);
        stringBuilder.append("</font>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String makeBold(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<br>");
        stringBuilder.append("<b>");
        stringBuilder.append(string);
        stringBuilder.append("</b>");
        stringBuilder.append("<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

