/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableLayer
extends AbstractLayer {
    private Collection<Renderable> renderables = new ArrayList<Renderable>();
    private Iterable<Renderable> renderablesOverride;
    private final PickSupport pickSupport = new PickSupport();
    private final Layer delegateOwner;

    public RenderableLayer() {
        this.delegateOwner = null;
    }

    public RenderableLayer(Layer layer) {
        this.delegateOwner = layer;
    }

    public void addRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.RenderableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.renderables.add(renderable);
    }

    public void addRenderables(Iterable<Renderable> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (Renderable renderable : iterable) {
            if (renderable == null) continue;
            this.renderables.add(renderable);
        }
    }

    public void removeRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.RenderableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.renderables.remove(renderable);
    }

    public void removeAllRenderables() {
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearRenderables();
    }

    private void clearRenderables() {
        if (this.renderables != null && this.renderables.size() > 0) {
            this.renderables.clear();
        }
    }

    public Iterable<Renderable> getRenderables() {
        return this.getActiveRenderables();
    }

    private Iterable<Renderable> getActiveRenderables() {
        if (this.renderablesOverride != null) {
            return this.renderablesOverride;
        }
        return Collections.unmodifiableCollection(this.renderables);
    }

    public void setRenderables(Iterable<Renderable> iterable) {
        this.renderablesOverride = iterable;
        this.disposeRenderables();
        this.clearRenderables();
    }

    @Override
    public void dispose() {
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.disposeRenderables();
    }

    private void disposeRenderables() {
        if (this.renderables != null && this.renderables.size() > 0) {
            for (Renderable renderable : this.renderables) {
                if (!(renderable instanceof Disposable)) continue;
                ((Disposable)((Object)renderable)).dispose();
            }
        }
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        for (Renderable renderable : this.getActiveRenderables()) {
            if (renderable == null) continue;
            float[] fArray = new float[4];
            drawContext.getGL().glGetFloatv(2816, fArray, 0);
            Color color = drawContext.getUniquePickColor();
            drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            renderable.render(drawContext);
            drawContext.getGL().glColor4fv(fArray, 0);
            if (renderable instanceof Locatable) {
                this.pickSupport.addPickableObject(color.getRGB(), renderable, ((Locatable)((Object)renderable)).getPosition(), false);
                continue;
            }
            this.pickSupport.addPickableObject(color.getRGB(), renderable);
        }
        this.pickSupport.resolvePick(drawContext, point, this.delegateOwner != null ? this.delegateOwner : this);
        this.pickSupport.endPicking(drawContext);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        for (Renderable renderable : this.getActiveRenderables()) {
            if (renderable == null) continue;
            renderable.render(drawContext);
        }
    }

    public Layer getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.RenderableLayer.Name");
    }
}

