/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

public class PolarConverter {
    private static final long POLAR_NO_ERROR = 0L;
    private static final long POLAR_LAT_ERROR = 1L;
    private static final long POLAR_LON_ERROR = 2L;
    private static final long POLAR_ORIGIN_LAT_ERROR = 4L;
    private static final long POLAR_ORIGIN_LON_ERROR = 8L;
    public static final long POLAR_EASTING_ERROR = 16L;
    public static final long POLAR_NORTHING_ERROR = 32L;
    private static final long POLAR_A_ERROR = 64L;
    private static final long POLAR_INV_F_ERROR = 128L;
    public static final long POLAR_RADIUS_ERROR = 256L;
    private static final double PI = Math.PI;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_Over_4 = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private static double Polar_a = 6378137.0;
    private static double Polar_f = 0.0033528106647474805;
    private static double es = 0.08181919084262188;
    private static double es_OVER_2 = 0.040909595421311;
    private static double Southern_Hemisphere = 0.0;
    private static double mc = 1.0;
    private static double tc = 1.0;
    private static double e4 = 1.0033565552493;
    private static double Polar_a_mc = 6378137.0;
    private static double two_Polar_a = 1.2756274E7;
    private static double Polar_Origin_Lat = 1.5707963267948966;
    private static double Polar_Origin_Long = 0.0;
    private static double Polar_False_Easting = 0.0;
    private static double Polar_False_Northing = 0.0;
    private static double Polar_Delta_Easting = 1.2713601E7;
    private static double Polar_Delta_Northing = 1.2713601E7;
    private static double Easting;
    private static double Northing;
    private static double Latitude;
    private static double Longitude;

    private PolarConverter() {
    }

    public static long setPolarStereographicParameters(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / d2;
        long l = 0L;
        if (d <= 0.0) {
            l |= 0x40L;
        }
        if (d7 < 250.0 || d7 > 350.0) {
            l |= 0x80L;
        }
        if (d3 < -1.5707963267948966 || d3 > 1.5707963267948966) {
            l |= 4L;
        }
        if (d4 < -Math.PI || d4 > Math.PI * 2) {
            l |= 8L;
        }
        if (l == 0L) {
            Polar_a = d;
            two_Polar_a = 2.0 * Polar_a;
            Polar_f = d2;
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d3 < 0.0) {
                Southern_Hemisphere = 1.0;
                Polar_Origin_Lat = -d3;
                Polar_Origin_Long = -d4;
            } else {
                Southern_Hemisphere = 0.0;
                Polar_Origin_Lat = d3;
                Polar_Origin_Long = d4;
            }
            Polar_False_Easting = d5;
            Polar_False_Northing = d6;
            double d8 = 2.0 * Polar_f - Polar_f * Polar_f;
            es = Math.sqrt(d8);
            es_OVER_2 = es / 2.0;
            if (Math.abs(Math.abs(Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10) {
                double d9 = Math.sin(Polar_Origin_Lat);
                double d10 = es * d9;
                double d11 = Math.pow((1.0 - d10) / (1.0 + d10), es_OVER_2);
                double d12 = Math.cos(Polar_Origin_Lat);
                mc = d12 / Math.sqrt(1.0 - d10 * d10);
                Polar_a_mc = Polar_a * mc;
                tc = Math.tan(1.5707963267948966 - Polar_Origin_Lat / 2.0) / d11;
            } else {
                double d13 = 1.0 + es;
                double d14 = 1.0 - es;
                e4 = Math.sqrt(Math.pow(d13, d13) * Math.pow(d14, d14));
            }
        }
        PolarConverter.Convert_Geodetic_To_Polar_Stereographic(0.0, Polar_Origin_Long);
        Polar_Delta_Northing = Northing;
        Polar_Delta_Easting = Polar_Delta_Northing = Math.abs(Polar_Delta_Northing) + 0.01;
        return l;
    }

    public static long Convert_Geodetic_To_Polar_Stereographic(double d, double d2) {
        long l = 0L;
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            l |= 1L;
        }
        if (d < 0.0 && Southern_Hemisphere == 0.0) {
            l |= 1L;
        }
        if (d > 0.0 && Southern_Hemisphere == 1.0) {
            l |= 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            l |= 2L;
        }
        if (l == 0L) {
            if (Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-10) {
                Easting = 0.0;
                Northing = 0.0;
            } else {
                double d3;
                if (Southern_Hemisphere != 0.0) {
                    d2 *= -1.0;
                    d *= -1.0;
                }
                if ((d3 = d2 - Polar_Origin_Long) > Math.PI) {
                    d3 -= Math.PI * 2;
                }
                if (d3 < -Math.PI) {
                    d3 += Math.PI * 2;
                }
                double d4 = Math.sin(d);
                double d5 = es * d4;
                double d6 = Math.pow((1.0 - d5) / (1.0 + d5), es_OVER_2);
                double d7 = Math.tan(1.5707963267948966 - d / 2.0) / d6;
                double d8 = Math.abs(Math.abs(Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10 ? Polar_a_mc * d7 / tc : two_Polar_a * d7 / e4;
                if (Southern_Hemisphere != 0.0) {
                    Easting = -(d8 * Math.sin(d3) - Polar_False_Easting);
                    Northing = d8 * Math.cos(d3) + Polar_False_Northing;
                } else {
                    Easting = d8 * Math.sin(d3) + Polar_False_Easting;
                }
                Northing = -d8 * Math.cos(d3) + Polar_False_Northing;
            }
        }
        return l;
    }

    public static double getEasting() {
        return Easting;
    }

    public static double getNorthing() {
        return Northing;
    }

    public static long Convert_Polar_Stereographic_To_Geodetic(double d, double d2) {
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        long l = 0L;
        double d8 = Polar_False_Easting - Polar_Delta_Easting;
        double d9 = Polar_False_Easting + Polar_Delta_Easting;
        double d10 = Polar_False_Northing - Polar_Delta_Northing;
        double d11 = Polar_False_Northing + Polar_Delta_Northing;
        if (d > d9 || d < d8) {
            l |= 0x10L;
        }
        if (d2 > d11 || d2 < d10) {
            l |= 0x20L;
        }
        if (l == 0L && (d6 = Math.sqrt((d5 = d - Polar_False_Easting) * d5 + (d4 = d2 - Polar_False_Northing) * d4)) > (d3 = Math.sqrt(Polar_Delta_Easting * Polar_Delta_Easting + Polar_Delta_Northing * Polar_Delta_Northing))) {
            l |= 0x100L;
        }
        if (l == 0L) {
            if (d4 == 0.0 && d5 == 0.0) {
                Latitude = 1.5707963267948966;
                Longitude = Polar_Origin_Long;
            } else {
                if (Southern_Hemisphere != 0.0) {
                    d4 *= -1.0;
                    d5 *= -1.0;
                }
                double d12 = Math.abs(Math.abs(Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10 ? d6 * tc / Polar_a_mc : d6 * e4 / two_Polar_a;
                double d13 = 1.5707963267948966 - 2.0 * Math.atan(d12);
                while (Math.abs(d13 - d7) > 1.0E-10) {
                    d7 = d13;
                    double d14 = Math.sin(d13);
                    double d15 = es * d14;
                    double d16 = Math.pow((1.0 - d15) / (1.0 + d15), es_OVER_2);
                    d13 = 1.5707963267948966 - 2.0 * Math.atan(d12 * d16);
                }
                Latitude = d13;
                Longitude = Polar_Origin_Long + Math.atan2(d5, -d4);
                if (Longitude > Math.PI) {
                    Longitude -= Math.PI * 2;
                } else if (Longitude < -Math.PI) {
                    Longitude += Math.PI * 2;
                }
                if (Latitude > 1.5707963267948966) {
                    Latitude = 1.5707963267948966;
                } else if (Latitude < -1.5707963267948966) {
                    Latitude = -1.5707963267948966;
                }
                if (Longitude > Math.PI) {
                    Longitude = Math.PI;
                } else if (Longitude < -Math.PI) {
                    Longitude = -Math.PI;
                }
            }
            if (Southern_Hemisphere != 0.0) {
                Latitude *= -1.0;
                Longitude *= -1.0;
            }
        }
        return l;
    }

    public static double getLatitude() {
        return Latitude;
    }

    public static double getLongitude() {
        return Longitude;
    }
}

