/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;

class MGRSCoordConverter {
    public static final int MGRS_NO_ERROR = 0;
    private static final int MGRS_LAT_ERROR = 1;
    private static final int MGRS_LON_ERROR = 2;
    public static final int MGRS_STRING_ERROR = 4;
    private static final int MGRS_PRECISION_ERROR = 8;
    private static final int MGRS_A_ERROR = 16;
    private static final int MGRS_INV_F_ERROR = 32;
    private static final int MGRS_EASTING_ERROR = 64;
    private static final int MGRS_NORTHING_ERROR = 128;
    private static final int MGRS_ZONE_ERROR = 256;
    private static final int MGRS_HEMISPHERE_ERROR = 512;
    private static final int MGRS_LAT_WARNING = 1024;
    private static final int MGRS_NOZONE_WARNING = 2048;
    private static final int MGRS_UTM_ERROR = 4096;
    private static final double PI = Math.PI;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final int MAX_PRECISION = 5;
    private static final double MIN_UTM_LAT = -1.3962634015954636;
    private static final double MAX_UTM_LAT = 1.4660765716752369;
    public static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double MIN_EAST_NORTH = 0.0;
    private static final double MAX_EAST_NORTH = 4000000.0;
    private static final double TWOMIL = 2000000.0;
    private static final double ONEHT = 100000.0;
    private static final String CLARKE_1866 = "CC";
    private static final String CLARKE_1880 = "CD";
    private static final String BESSEL_1841 = "BR";
    private static final String BESSEL_1841_NAMIBIA = "BN";
    private double MGRS_a = 6378137.0;
    private double MGRS_f = 0.0033528106647474805;
    private double MGRS_recpf = 298.257223563;
    private String MGRS_Ellipsoid_Code = "WE";
    private Globe globe;
    private String MGRSString = "";
    private long ltr2_low_value;
    private long ltr2_high_value;
    private double false_northing;
    private long lastLetter;
    private long last_error = 0L;
    private double north;
    private double south;
    private double min_northing;
    private double latitude;
    private double longitude;
    private static final int LETTER_A = 0;
    private static final int LETTER_B = 1;
    private static final int LETTER_C = 2;
    private static final int LETTER_D = 3;
    private static final int LETTER_E = 4;
    private static final int LETTER_F = 5;
    private static final int LETTER_G = 6;
    private static final int LETTER_H = 7;
    private static final int LETTER_I = 8;
    private static final int LETTER_J = 9;
    private static final int LETTER_K = 10;
    private static final int LETTER_L = 11;
    private static final int LETTER_M = 12;
    private static final int LETTER_N = 13;
    private static final int LETTER_O = 14;
    private static final int LETTER_P = 15;
    private static final int LETTER_Q = 16;
    private static final int LETTER_R = 17;
    private static final int LETTER_S = 18;
    private static final int LETTER_T = 19;
    private static final int LETTER_U = 20;
    private static final int LETTER_V = 21;
    private static final int LETTER_W = 22;
    private static final int LETTER_X = 23;
    private static final int LETTER_Y = 24;
    private static final int LETTER_Z = 25;
    private static final int MGRS_LETTERS = 3;
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final long[][] upsConstants = new long[][]{{0L, 9L, 25L, 25L, 800000L, 800000L}, {1L, 0L, 17L, 25L, 2000000L, 800000L}, {24L, 9L, 25L, 15L, 800000L, 1300000L}, {25L, 0L, 9L, 15L, 2000000L, 1300000L}};
    private static final double[][] latitudeBandConstants = new double[][]{{2.0, 1100000.0, -72.0, -80.5}, {3.0, 2000000.0, -64.0, -72.0}, {4.0, 2800000.0, -56.0, -64.0}, {5.0, 3700000.0, -48.0, -56.0}, {6.0, 4600000.0, -40.0, -48.0}, {7.0, 5500000.0, -32.0, -40.0}, {9.0, 6400000.0, -24.0, -32.0}, {10.0, 7300000.0, -16.0, -24.0}, {11.0, 8200000.0, -8.0, -16.0}, {12.0, 9100000.0, 0.0, -8.0}, {13.0, 0.0, 8.0, 0.0}, {15.0, 800000.0, 16.0, 8.0}, {16.0, 1700000.0, 24.0, 16.0}, {17.0, 2600000.0, 32.0, 24.0}, {18.0, 3500000.0, 40.0, 32.0}, {19.0, 4400000.0, 48.0, 40.0}, {20.0, 5300000.0, 56.0, 48.0}, {21.0, 6200000.0, 64.0, 56.0}, {22.0, 7000000.0, 72.0, 64.0}, {23.0, 7900000.0, 84.5, 72.0}};

    MGRSCoordConverter(Globe globe) {
        this.globe = globe;
        if (globe != null) {
            double d = globe.getEquatorialRadius();
            double d2 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
            this.setMGRSParameters(d, d2, this.MGRS_Ellipsoid_Code);
        }
    }

    public long setMGRSParameters(double d, double d2, String string) {
        if (d <= 0.0) {
            return 16L;
        }
        if (d2 == 0.0) {
            return 32L;
        }
        double d3 = 1.0 / d2;
        if (d3 < 250.0 || d3 > 350.0) {
            return 32L;
        }
        this.MGRS_a = d;
        this.MGRS_f = d2;
        this.MGRS_Ellipsoid_Code = string;
        return 0L;
    }

    public double getMGRS_f() {
        return this.MGRS_f;
    }

    public double getMGRS_a() {
        return this.MGRS_a;
    }

    private long getLastLetter() {
        return this.lastLetter;
    }

    public String getMGRS_Ellipsoid_Code() {
        return this.MGRS_Ellipsoid_Code;
    }

    public long convertMGRSToGeodetic(String string) {
        this.latitude = 0.0;
        this.longitude = 0.0;
        long l = this.checkZone(string);
        if (l == 0L) {
            UTMCoord uTMCoord = this.convertMGRSToUTM(string);
            if (uTMCoord != null) {
                this.latitude = uTMCoord.getLatitude().radians;
                this.longitude = uTMCoord.getLongitude().radians;
            } else {
                l = 4096L;
            }
        } else if (l == 2048L) {
            // empty if block
        }
        return l;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    private MGRSComponents breakMGRSString(String string) {
        int n;
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        int[] nArray = new int[3];
        long l2 = 0L;
        long l3 = 0L;
        int n4 = 0;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        n2 = n;
        while (n < string.length() && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        int n5 = n - n2;
        if (n5 <= 2) {
            if (n5 > 0) {
                n3 = Integer.parseInt(string.substring(n2, n));
                if (n3 < 1 || n3 > 60) {
                    l |= 4L;
                }
            } else {
                l |= 4L;
            }
        }
        n2 = n;
        while (n < string.length() && Character.isLetter(string.charAt(n))) {
            ++n;
        }
        int n6 = n - n2;
        if (n6 == 3) {
            nArray[0] = alphabet.indexOf(Character.toUpperCase(string.charAt(n2)));
            if (nArray[0] == 8 || nArray[0] == 14) {
                l |= 4L;
            }
            nArray[1] = alphabet.indexOf(Character.toUpperCase(string.charAt(n2 + 1)));
            if (nArray[1] == 8 || nArray[1] == 14) {
                l |= 4L;
            }
            nArray[2] = alphabet.indexOf(Character.toUpperCase(string.charAt(n2 + 2)));
            if (nArray[2] == 8 || nArray[2] == 14) {
                l |= 4L;
            }
        } else {
            l |= 4L;
        }
        n2 = n;
        while (n < string.length() && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        n5 = n - n2;
        if (n5 <= 10 && n5 % 2 == 0) {
            int n7;
            n4 = n7 = n5 / 2;
            if (n7 > 0) {
                l2 = Integer.parseInt(string.substring(n2, n2 + n7));
                l3 = Integer.parseInt(string.substring(n2 + n7, n2 + n7 + n7));
                double d = Math.pow(10.0, 5 - n7);
                l2 = (long)((double)l2 * d);
                l3 = (long)((double)l3 * d);
            } else {
                l2 = 0L;
                l3 = 0L;
            }
        } else {
            l |= 4L;
        }
        this.last_error = l;
        if (l == 0L) {
            return new MGRSComponents(n3, nArray[0], nArray[1], nArray[2], l2, l3, n4);
        }
        return null;
    }

    private long checkZone(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        n2 = n;
        while (n < string.length() && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        n3 = n - n2;
        if (n3 > 2) {
            l |= 4L;
        } else if (n3 <= 0) {
            l |= 0x800L;
        }
        return l;
    }

    private long getLatitudeBandMinNorthing(int n) {
        long l = 0L;
        if (n >= 2 && n <= 7) {
            this.min_northing = latitudeBandConstants[n - 2][1];
        } else if (n >= 9 && n <= 13) {
            this.min_northing = latitudeBandConstants[n - 3][1];
        } else if (n >= 15 && n <= 23) {
            this.min_northing = latitudeBandConstants[n - 4][1];
        } else {
            l |= 4L;
        }
        return l;
    }

    private long getLatitudeRange(int n) {
        long l = 0L;
        if (n >= 2 && n <= 7) {
            this.north = latitudeBandConstants[n - 2][2] * (Math.PI / 180);
            this.south = latitudeBandConstants[n - 2][3] * (Math.PI / 180);
        } else if (n >= 9 && n <= 13) {
            this.north = latitudeBandConstants[n - 3][2] * (Math.PI / 180);
            this.south = latitudeBandConstants[n - 3][3] * (Math.PI / 180);
        } else if (n >= 15 && n <= 23) {
            this.north = latitudeBandConstants[n - 4][2] * (Math.PI / 180);
            this.south = latitudeBandConstants[n - 4][3] * (Math.PI / 180);
        } else {
            l |= 4L;
        }
        return l;
    }

    private UTMCoord convertMGRSToUTM(String string) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        long l = 0L;
        char c = 'N';
        double d6 = 0.0;
        double d7 = 0.0;
        UTMCoord uTMCoord = null;
        MGRSComponents mGRSComponents = this.breakMGRSString(string);
        if (mGRSComponents == null) {
            l |= 4L;
        } else if (l == 0L) {
            if (mGRSComponents.latitudeBand == 23 && (mGRSComponents.zone == 32 || mGRSComponents.zone == 34 || mGRSComponents.zone == 36)) {
                l |= 4L;
            } else {
                c = mGRSComponents.latitudeBand < 13 ? (char)'S' : 'N';
                this.getGridValues(mGRSComponents.zone);
                if ((long)mGRSComponents.squareLetter1 < this.ltr2_low_value || (long)mGRSComponents.squareLetter1 > this.ltr2_high_value || mGRSComponents.squareLetter2 > 21) {
                    l |= 4L;
                }
                if (l == 0L) {
                    double d8 = (double)mGRSComponents.squareLetter2 * 100000.0 + this.false_northing;
                    double d9 = (double)((long)mGRSComponents.squareLetter1 - this.ltr2_low_value + 1L) * 100000.0;
                    if (this.ltr2_low_value == 9L && mGRSComponents.squareLetter1 > 14) {
                        d9 -= 100000.0;
                    }
                    if (mGRSComponents.squareLetter2 > 14) {
                        d8 -= 100000.0;
                    }
                    if (mGRSComponents.squareLetter2 > 8) {
                        d8 -= 100000.0;
                    }
                    if (d8 >= 2000000.0) {
                        d8 -= 2000000.0;
                    }
                    if ((l = this.getLatitudeBandMinNorthing(mGRSComponents.latitudeBand)) == 0L) {
                        double d10;
                        for (d10 = this.min_northing; d10 >= 2000000.0; d10 -= 2000000.0) {
                        }
                        if ((d8 -= d10) < 0.0) {
                            d = d8 + 2000000.0;
                            d2 = Math.abs(d8);
                            if (d2 > 2000000.0 && d > 2000000.0) {
                                this.last_error = 128L;
                                return null;
                            }
                            d8 = d2 < d ? this.min_northing + d8 : this.min_northing + d;
                        } else {
                            d8 = this.min_northing + d8;
                        }
                        d6 = d9 + mGRSComponents.easting;
                        d7 = d8 + mGRSComponents.northing;
                        try {
                            uTMCoord = UTMCoord.fromUTM(mGRSComponents.zone, c, d6, d7, this.globe);
                            d3 = uTMCoord.getLatitude().radians;
                            d5 = Math.pow(10.0, mGRSComponents.precision);
                            l = this.getLatitudeRange(mGRSComponents.latitudeBand);
                            if (!(l != 0L || this.south - Math.PI / 180 / d5 <= d3 && d3 <= this.north + Math.PI / 180 / d5)) {
                                l |= 0x400L;
                            }
                        }
                        catch (Exception exception) {
                            l = 4096L;
                        }
                    }
                }
            }
        }
        this.last_error = l;
        if (l == 0L || l == 1024L) {
            return uTMCoord;
        }
        return null;
    }

    public long convertGeodeticToMGRS(double d, double d2, int n) {
        String string = "N";
        double d3 = 0.0;
        double d4 = 0.0;
        this.MGRSString = "";
        long l = 0L;
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            l = 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            l = 2L;
        }
        if (n < 0 || n > 5) {
            l = 8L;
        }
        if (l == 0L && !(d < -1.3962634015954636) && !(d > 1.4660765716752369)) {
            try {
                UTMCoord uTMCoord = UTMCoord.fromLatLon(Angle.fromRadians(d), Angle.fromRadians(d2), this.globe);
                l |= this.convertUTMToMGRS(uTMCoord.getZone(), d, uTMCoord.getEasting(), uTMCoord.getNorthing(), n);
            }
            catch (Exception exception) {
                l = 4096L;
            }
        }
        return l;
    }

    public String getMGRSString() {
        return this.MGRSString;
    }

    private long convertUPSToMGRS(char c, Double d, Double d2, long l) {
        long[] lArray = new long[3];
        long l2 = 0L;
        if (c != 'N' && c != 'S') {
            l2 |= 0x200L;
        }
        if (d < 0.0 || d > 4000000.0) {
            l2 |= 0x40L;
        }
        if (d2 < 0.0 || d2 > 4000000.0) {
            l2 |= 0x80L;
        }
        if (l < 0L || l > 5L) {
            l2 |= 8L;
        }
        if (l2 == 0L) {
            double d3;
            double d4;
            long l3;
            double d5 = Math.pow(10.0, 5L - l);
            d = this.roundMGRS(d / d5) * d5;
            d2 = this.roundMGRS(d2 / d5) * d5;
            if (c == 'N') {
                lArray[0] = d >= 2000000.0 ? 25L : 24L;
                int n = (int)(lArray[0] - 22L);
                l3 = upsConstants[n][1];
                d4 = upsConstants[n][4];
                d3 = upsConstants[n][5];
            } else {
                lArray[0] = d >= 2000000.0 ? 1L : 0L;
                l3 = upsConstants[0][1];
                d4 = upsConstants[0][4];
                d3 = upsConstants[0][5];
            }
            double d6 = d2;
            lArray[2] = (long)((d6 -= d3) / 100000.0);
            if (lArray[2] > 7L) {
                lArray[2] = lArray[2] + 1L;
            }
            if (lArray[2] > 13L) {
                lArray[2] = lArray[2] + 1L;
            }
            double d7 = d;
            lArray[1] = l3 + (long)((d7 -= d4) / 100000.0);
            if (d < 2000000.0) {
                if (lArray[1] > 11L) {
                    lArray[1] = lArray[1] + 3L;
                }
                if (lArray[1] > 20L) {
                    lArray[1] = lArray[1] + 2L;
                }
            } else {
                if (lArray[1] > 2L) {
                    lArray[1] = lArray[1] + 2L;
                }
                if (lArray[1] > 7L) {
                    lArray[1] = lArray[1] + 1L;
                }
                if (lArray[1] > 11L) {
                    lArray[1] = lArray[1] + 3L;
                }
            }
            this.makeMGRSString(0L, lArray, d, d2, l);
        }
        return l2;
    }

    private long convertUTMToMGRS(long l, double d, double d2, double d3, long l2) {
        long[] lArray = new long[3];
        double d4 = Math.pow(10.0, 5L - l2);
        d2 = this.roundMGRS(d2 / d4) * d4;
        d3 = this.roundMGRS(d3 / d4) * d4;
        this.getGridValues(l);
        long l3 = this.getLatitudeLetter(d);
        lArray[0] = this.getLastLetter();
        if (l3 == 0L) {
            double d5 = d3;
            if (d5 == 1.0E7) {
                d5 -= 1.0;
            }
            while (d5 >= 2000000.0) {
                d5 -= 2000000.0;
            }
            if ((d5 -= this.false_northing) < 0.0) {
                d5 += 2000000.0;
            }
            lArray[2] = (long)(d5 / 100000.0);
            if (lArray[2] > 7L) {
                lArray[2] = lArray[2] + 1L;
            }
            if (lArray[2] > 13L) {
                lArray[2] = lArray[2] + 1L;
            }
            double d6 = d2;
            if (lArray[0] == 21L && l == 31L && d6 == 500000.0) {
                d6 -= 1.0;
            }
            lArray[1] = this.ltr2_low_value + ((long)(d6 / 100000.0) - 1L);
            if (this.ltr2_low_value == 9L && lArray[1] > 13L) {
                lArray[1] = lArray[1] + 1L;
            }
            this.makeMGRSString(l, lArray, d2, d3, l2);
        }
        return l3;
    }

    private void getGridValues(long l) {
        long l2 = l % 6L;
        if (l2 == 0L) {
            l2 = 6L;
        }
        long l3 = this.MGRS_Ellipsoid_Code.compareTo(CLARKE_1866) == 0 || this.MGRS_Ellipsoid_Code.compareTo(CLARKE_1880) == 0 || this.MGRS_Ellipsoid_Code.compareTo(BESSEL_1841) == 0 || this.MGRS_Ellipsoid_Code.compareTo(BESSEL_1841_NAMIBIA) == 0 ? 0L : 1L;
        if (l2 == 1L || l2 == 4L) {
            this.ltr2_low_value = 0L;
            this.ltr2_high_value = 7L;
        } else if (l2 == 2L || l2 == 5L) {
            this.ltr2_low_value = 9L;
            this.ltr2_high_value = 17L;
        } else if (l2 == 3L || l2 == 6L) {
            this.ltr2_low_value = 18L;
            this.ltr2_high_value = 25L;
        }
        this.false_northing = l3 == 1L ? (l2 % 2L == 0L ? 1500000.0 : 0.0) : (l2 % 2L == 0L ? 500000.0 : 1000000.0);
    }

    private long getLatitudeLetter(double d) {
        long l = 0L;
        double d2 = d * 57.29577951308232;
        if (d2 >= 72.0 && d2 < 84.5) {
            this.lastLetter = 23L;
        } else if (d2 > -80.5 && d2 < 72.0) {
            double d3 = (d + 1.3962634015954636) / 0.13962634015954636 + 1.0E-12;
            this.lastLetter = (long)latitudeBandConstants[(int)d3][0];
        } else {
            l |= 1L;
        }
        return l;
    }

    private double roundMGRS(double d) {
        double d2 = Math.floor(d);
        double d3 = d - d2;
        long l = (long)d2;
        if (d3 > 0.5 || d3 == 0.5 && l % 2L == 1L) {
            ++l;
        }
        return l;
    }

    private long makeMGRSString(long l, long[] lArray, double d, double d2, long l2) {
        long l3;
        Integer n;
        String string;
        long l4;
        Integer n2;
        String string2;
        long l5 = 0L;
        this.MGRSString = l != 0L ? String.format("%02d", l) : "  ";
        for (int i = 0; i < 3; ++i) {
            if (lArray[i] < 0L || lArray[i] > 26L) {
                return 256L;
            }
            this.MGRSString = this.MGRSString + alphabet.charAt((int)lArray[i]);
        }
        double d3 = Math.pow(10.0, 5L - l2);
        if ((d %= 100000.0) >= 99999.5) {
            d = 99999.0;
        }
        if ((long)(string2 = (n2 = Integer.valueOf((int)(l4 = (long)(d / d3)))).toString()).length() > l2) {
            string2 = string2.substring(0, (int)l2 - 1);
        } else {
            int n3 = string2.length();
            int n4 = 0;
            while ((long)n4 < l2 - (long)n3) {
                string2 = "0" + string2;
                ++n4;
            }
        }
        this.MGRSString = this.MGRSString + " " + string2;
        d2 %= 100000.0;
        if (d2 >= 99999.5) {
            d2 = 99999.0;
        }
        if ((long)(string = (n = Integer.valueOf((int)(l3 = (long)(d2 / d3)))).toString()).length() > l2) {
            string = string.substring(0, (int)l2 - 1);
        } else {
            int n5 = string.length();
            int n6 = 0;
            while ((long)n6 < l2 - (long)n5) {
                string = "0" + string;
                ++n6;
            }
        }
        this.MGRSString = this.MGRSString + " " + string;
        return l5;
    }

    public long getError() {
        return this.last_error;
    }

    private class MGRSComponents {
        private final int zone;
        private final int latitudeBand;
        private final int squareLetter1;
        private final int squareLetter2;
        private final double easting;
        private final double northing;
        private final int precision;

        public MGRSComponents(int n, int n2, int n3, int n4, double d, double d2, int n5) {
            this.zone = n;
            this.latitudeBand = n2;
            this.squareLetter1 = n3;
            this.squareLetter2 = n4;
            this.easting = d;
            this.northing = d2;
            this.precision = n5;
        }

        public String toString() {
            return "MGRS: " + this.zone + " " + MGRSCoordConverter.alphabet.charAt(this.latitudeBand) + " " + MGRSCoordConverter.alphabet.charAt(this.squareLetter1) + MGRSCoordConverter.alphabet.charAt(this.squareLetter2) + " " + this.easting + " " + this.northing + " " + "(" + this.precision + ")";
        }
    }
}

