/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFNonpolarFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;

public abstract class RPFFrameTransform {
    RPFFrameTransform() {
    }

    public static RPFFrameTransform createFrameTransform(char c, String string, double d) {
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        return RPFFrameTransform.newFrameTransform(c, string, d);
    }

    private static RPFFrameTransform newFrameTransform(char c, String string, double d) {
        boolean bl;
        boolean bl2 = bl = !RPFZone.isPolarZone(c);
        if (bl) {
            return RPFNonpolarFrameTransform.createNonpolarFrameTransform(c, string, d);
        }
        String string2 = String.format("Zone is not supported: %c", Character.valueOf(c));
        Logging.logger().fine(string2);
        throw new IllegalArgumentException(string2);
    }

    public abstract int getFrameNumber(int var1, int var2);

    public abstract int getMaximumFrameNumber();

    public abstract int getRows();

    public abstract int getColumns();

    public abstract LatLon computeFrameOrigin(int var1);

    public abstract Sector computeFrameCoverage(int var1);

    static int frameNumber(int n, int n2, int n3) {
        return n2 + n * n3;
    }

    static int maxFrameNumber(int n, int n2) {
        return n * n2 - 1;
    }

    static int frameRow(int n, int n2) {
        return (int)((double)n / (double)n2);
    }

    static int frameColumn(int n, int n2, int n3) {
        return n - n2 * n3;
    }
}

