/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.georss;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Quadrilateral;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRSSParser {
    public static final String GEORSS_URI = "http://www.georss.org/georss";
    public static final String GML_URI = "http://www.opengis.net/gml";

    public static List<Renderable> parseFragment(String string, NamespaceContext namespaceContext) {
        return GeoRSSParser.parseShapes(GeoRSSParser.fixNamespaceQualification(string));
    }

    public static List<Renderable> parseShapes(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.length() < 1) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            List<Renderable> list = GeoRSSParser.parseShapes(document);
            if (list == null || list.size() < 1) {
                Logging.logger().log(Level.WARNING, "GeoRSS.NoShapes", string);
                return null;
            }
            return list;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = Logging.getMessage("GeoRSS.ParserConfigurationException");
            Logging.logger().log(Level.SEVERE, string3, parserConfigurationException);
            throw new WWRuntimeException(string3, parserConfigurationException);
        }
        catch (IOException iOException) {
            String string4 = Logging.getMessage("GeoRSS.IOExceptionParsing", string);
            Logging.logger().log(Level.SEVERE, string4, iOException);
            throw new WWRuntimeException(string4, iOException);
        }
        catch (SAXException sAXException) {
            String string5 = Logging.getMessage("GeoRSS.IOExceptionParsing", string);
            Logging.logger().log(Level.SEVERE, string5, sAXException);
            throw new WWRuntimeException(string5, sAXException);
        }
    }

    private static String fixNamespaceQualification(String string) {
        String string2 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.contains("georss:") && !string2.contains(GEORSS_URI)) {
            stringBuffer.append(" xmlns:georss=\"");
            stringBuffer.append(GEORSS_URI);
            stringBuffer.append("\"");
        }
        if (string2.contains("gml:") && !string2.contains(GML_URI)) {
            stringBuffer.append(" xmlns:gml=\"");
            stringBuffer.append(GML_URI);
            stringBuffer.append("\"");
        }
        if (stringBuffer.length() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<wwdummyelement");
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(">");
            stringBuffer2.append(string);
            stringBuffer2.append("</wwdummyelement>");
            return stringBuffer2.toString();
        }
        return string;
    }

    private static String surroundWithNameSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<wwdummyelement");
        stringBuffer.append(" xmlns:georss=\"");
        stringBuffer.append(GEORSS_URI);
        stringBuffer.append("\"");
        stringBuffer.append(" xmlns:gml=\"");
        stringBuffer.append(GML_URI);
        stringBuffer.append("\"");
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append("</wwdummyelement>");
        return stringBuffer.toString();
    }

    public static List<Renderable> parseShapes(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            List<Renderable> list = GeoRSSParser.parseShapes(document);
            if (list == null || list.size() < 1) {
                Logging.logger().log(Level.WARNING, "GeoRSS.NoShapes", file.getPath());
                return null;
            }
            return list;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("GeoRSS.ParserConfigurationException");
            Logging.logger().log(Level.SEVERE, string, parserConfigurationException);
            throw new WWRuntimeException(string, parserConfigurationException);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("GeoRSS.IOExceptionParsing", file.getPath());
            Logging.logger().log(Level.SEVERE, string, iOException);
            throw new WWRuntimeException(string, iOException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("GeoRSS.IOExceptionParsing", file.getPath());
            Logging.logger().log(Level.SEVERE, string, sAXException);
            throw new WWRuntimeException(string, sAXException);
        }
    }

    public static List<Renderable> parseShapes(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        NodeList nodeList = document.getElementsByTagNameNS(GEORSS_URI, "where");
        if (nodeList != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "point")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "line")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "polygon")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "box")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "radius")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList2, nodeList);
        }
        if ((nodeList = document.getElementsByTagNameNS(GEORSS_URI, "elev")) != null && nodeList.getLength() > 0) {
            GeoRSSParser.addNodes(arrayList2, nodeList);
        }
        ArrayList<Renderable> arrayList3 = new ArrayList<Renderable>();
        if (arrayList.size() < 1) {
            return null;
        }
        for (Node node : arrayList) {
            Renderable renderable = null;
            String string = node.getLocalName();
            if (string.equals("point")) {
                renderable = GeoRSSParser.makePointShape(node, arrayList2);
            } else if (string.equals("where")) {
                renderable = GeoRSSParser.makeWhereShape(node);
            } else if (string.equals("line")) {
                renderable = GeoRSSParser.makeLineShape(node, arrayList2);
            } else if (string.equals("polygon")) {
                renderable = GeoRSSParser.makePolygonShape(node, arrayList2);
            } else if (string.equals("box")) {
                renderable = GeoRSSParser.makeBoxShape(node, arrayList2);
            }
            if (renderable == null) continue;
            arrayList3.add(renderable);
        }
        return arrayList3;
    }

    private static void addNodes(ArrayList<Node> arrayList, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
    }

    private static Renderable makeWhereShape(Node node) {
        Node node2 = GeoRSSParser.findChildByLocalName(node, "Polygon");
        if (node2 != null) {
            return GeoRSSParser.makeGMLPolygonShape(node2);
        }
        node2 = GeoRSSParser.findChildByLocalName(node, "Envelope");
        if (node2 != null) {
            return GeoRSSParser.makeGMLEnvelopeShape(node2);
        }
        node2 = GeoRSSParser.findChildByLocalName(node, "LineString");
        if (node2 != null) {
            return GeoRSSParser.makeGMLineStringShape(node2);
        }
        node2 = GeoRSSParser.findChildByLocalName(node, "Point");
        if (node2 != null) {
            return GeoRSSParser.makeGMLPointShape(node2);
        }
        Logging.logger().log(Level.WARNING, "GeoRSS.MissingElementContent", "where");
        return null;
    }

    private static Renderable makeGMLPolygonShape(Node node) {
        Node node2 = GeoRSSParser.findChildByLocalName(node, "exterior");
        if (node2 == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.MissingElement", "exterior");
            return null;
        }
        if ((node2 = GeoRSSParser.findChildByLocalName(node2, "LinearRing")) == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.MissingElement", "LinearRing");
            return null;
        }
        return GeoRSSParser.makePolygonShape(node2, null);
    }

    private static Renderable makePolygonShape(Node node, Iterable<Node> iterable) {
        double d;
        String string = node.getTextContent();
        if (string == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.NoCoordinates", node.getLocalName());
            return null;
        }
        ArrayList<Double> arrayList = GeoRSSParser.getDoubleValues(string);
        if (arrayList.size() < 8 || arrayList.size() % 2 != 0) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", node.getLocalName());
            return null;
        }
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        for (int i = 0; i < arrayList.size(); i += 2) {
            arrayList2.add(LatLon.fromDegrees(arrayList.get(i), arrayList.get(i + 1)));
        }
        double d2 = d = iterable != null ? GeoRSSParser.getElevation(node, iterable) : 0.0;
        if (d != 0.0) {
            Polyline polyline = new Polyline(arrayList2, d);
            polyline.setFilled(true);
            polyline.setPathType(0);
            return polyline;
        }
        return new SurfacePolygon(arrayList2);
    }

    private static Renderable makeGMLEnvelopeShape(Node node) {
        Node node2 = GeoRSSParser.findChildByLocalName(node, "lowerCorner");
        if (node2 == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.MissingElement", " lowerCorner");
            return null;
        }
        String string = node2.getTextContent();
        if (string == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", " lowerCorner");
            return null;
        }
        node2 = GeoRSSParser.findChildByLocalName(node, "upperCorner");
        if (node2 == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", " upperCorner");
            return null;
        }
        String string2 = node2.getTextContent();
        if (string2 == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", " upperCorner");
            return null;
        }
        ArrayList<Double> arrayList = GeoRSSParser.getDoubleValues(string);
        if (arrayList.size() != 2) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", " lowerCorner");
            return null;
        }
        ArrayList<Double> arrayList2 = GeoRSSParser.getDoubleValues(string2);
        if (arrayList2.size() != 2) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", " upperCorner");
            return null;
        }
        return new SurfaceSector(Sector.fromDegrees(arrayList.get(0), arrayList2.get(0), arrayList.get(1), arrayList2.get(1)));
    }

    private static Renderable makeBoxShape(Node node, Iterable<Node> iterable) {
        String string = node.getTextContent();
        if (string == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.NoCoordinates", node.getLocalName());
            return null;
        }
        ArrayList<Double> arrayList = GeoRSSParser.getDoubleValues(string);
        if (arrayList.size() != 4) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", node.getLocalName());
            return null;
        }
        double d = GeoRSSParser.getElevation(node, iterable);
        if (d != 0.0) {
            return new Quadrilateral(LatLon.fromDegrees(arrayList.get(0), arrayList.get(1)), LatLon.fromDegrees(arrayList.get(2), arrayList.get(3)), d);
        }
        return new SurfaceSector(Sector.fromDegrees(arrayList.get(0), arrayList.get(2), arrayList.get(1), arrayList.get(3)));
    }

    private static Renderable makeGMLineStringShape(Node node) {
        Node node2 = GeoRSSParser.findChildByLocalName(node, "posList");
        if (node2 == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.MissingElement", "posList");
            return null;
        }
        return GeoRSSParser.makeLineShape(node2, null);
    }

    private static Renderable makeLineShape(Node node, Iterable<Node> iterable) {
        double d;
        String string = node.getTextContent();
        if (string == null) {
            Logging.logger().log(Level.WARNING, "GeoRSS.NoCoordinates", node.getLocalName());
            return null;
        }
        ArrayList<Double> arrayList = GeoRSSParser.getDoubleValues(string);
        if (arrayList.size() < 4) {
            Logging.logger().log(Level.WARNING, "GeoRSS.InvalidCoordinateCount", node.getLocalName());
            return null;
        }
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        for (int i = 0; i < arrayList.size(); i += 2) {
            arrayList2.add(LatLon.fromDegrees(arrayList.get(i), arrayList.get(i + 1)));
        }
        double d2 = d = iterable != null ? GeoRSSParser.getElevation(node, iterable) : 0.0;
        if (d != 0.0) {
            Polyline polyline = new Polyline(arrayList2, d);
            polyline.setPathType(0);
            return polyline;
        }
        return new Polyline(arrayList2, 0.0);
    }

    private static Renderable makeGMLPointShape(Node node) {
        return null;
    }

    private static Renderable makePointShape(Node node, Iterable<Node> iterable) {
        return null;
    }

    private static Node findChildByLocalName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getLocalName();
            if (string2 == null || !string2.equals(string)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private static Node findSiblingAttribute(String string, Iterable<Node> iterable, Node node) {
        for (Node node2 : iterable) {
            if (!node2.getLocalName().equals(string) || !node2.getParentNode().equals(node.getParentNode())) continue;
            return node2;
        }
        return null;
    }

    private static ArrayList<Double> getDoubleValues(String string) {
        String[] stringArray = string.trim().split("[ ,\n]");
        if (stringArray.length < 1) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (String string2 : stringArray) {
            double d;
            if (string2 == null || string2.length() < 1) continue;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.logger().log(Level.SEVERE, "GeoRSS.NumberFormatException", string2);
                continue;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    private static double getElevation(Node node, Iterable<Node> iterable) {
        double d = 0.0;
        Node node2 = GeoRSSParser.findSiblingAttribute("elev", iterable, node);
        if (node2 != null) {
            ArrayList<Double> arrayList = GeoRSSParser.getDoubleValues(node2.getTextContent());
            if (arrayList != null && arrayList.size() > 0) {
                d = arrayList.get(0);
            } else {
                Logging.logger().log(Level.WARNING, "GeoRSS.MissingElementContent", "elev");
            }
        }
        return d;
    }
}

