/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class UsageInTabbedPane {
    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.setTitle("World Wind Tabbed Pane");
            jFrame.setDefaultCloseOperation(3);
            final JTabbedPane jTabbedPane = new JTabbedPane();
            final WWJPanel wWJPanel = new WWJPanel(new Dimension(800, 600), true);
            JPanel jPanel = new JPanel(new BorderLayout());
            JButton jButton = new JButton("Detach");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Detaching wwj");
                    System.out.println("Removing tab");
                    jTabbedPane.removeTabAt(0);
                    System.out.println("Tab removed");
                }
            });
            JButton jButton2 = new JButton("Attach");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Adding tab");
                    jTabbedPane.insertTab("WWJ Pane 1", null, wWJPanel, "Reattach", 0);
                    System.out.println("Tab added");
                }
            });
            jPanel.add((Component)jButton, "North");
            jPanel.add((Component)jButton2, "South");
            jTabbedPane.add("WWJ Pane 1", wWJPanel);
            jTabbedPane.add("Dummy Pane", jPanel);
            jFrame.getContentPane().add((Component)jTabbedPane, "Center");
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Tabbed Pane Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    public static class WWJPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;

        public WWJPanel(Dimension dimension, boolean bl) {
            super(new BorderLayout());
            this.wwd.setPreferredSize(dimension);
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.add((Component)this.wwd, "Center");
            if (bl) {
                this.statusBar = new StatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource(this.wwd);
            }
        }
    }
}

