/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.SurfaceImageLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SurfaceImageViewer
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Surface Images", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private JFileChooser fileChooser = new JFileChooser();
        private JSlider opacitySlider;
        private SurfaceImageLayer layer;

        public AppFrame() {
            super(true, true, false);
            try {
                this.layer = new SurfaceImageLayer();
                this.layer.setOpacity(0.7);
                this.layer.setPickEnabled(false);
                this.layer.setName("Surface Images");
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.layer);
                this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
            JButton jButton = new JButton("Open Image File...");
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AppFrame.this.fileChooser.showOpenDialog(AppFrame.this);
                    if (n != 0) {
                        return;
                    }
                    File file = AppFrame.this.fileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        AppFrame.this.layer.addImage(file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            this.opacitySlider = new JSlider();
            this.opacitySlider.setMaximum(100);
            this.opacitySlider.setValue((int)(this.layer.getOpacity() * 100.0));
            this.opacitySlider.setEnabled(true);
            this.opacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = AppFrame.this.opacitySlider.getValue();
                    AppFrame.this.layer.setOpacity((double)n / 100.0);
                    AppFrame.this.getWwd().repaint();
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)new JLabel("Opacity"), "West");
            jPanel2.add((Component)this.opacitySlider, "Center");
            jPanel.add(jPanel2);
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            return jPanel;
        }
    }
}

