/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.Moon.Clementine30Layer;
import gov.nasa.worldwind.layers.Moon.ShadedElevationLayer;

public class Moon
extends ApplicationTemplate {
    private static final String LAYERS = "gov.nasa.worldwind.layers.StarsLayer,gov.nasa.worldwind.layers.Moon.Clementine40BaseLayer,gov.nasa.worldwind.layers.Moon.Clementine40Layer,gov.nasa.worldwind.layers.Moon.Clementine30Layer,gov.nasa.worldwind.layers.Moon.ShadedElevationLayer,gov.nasa.worldwind.layers.ScalebarLayer,gov.nasa.worldwind.layers.CompassLayer";

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.GlobeClassName", gov.nasa.worldwind.globes.Moon.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.LayerClassNames", LAYERS);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 6000000.0);
        ApplicationTemplate.start("World Wind Moon", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (Layer layer : layerList) {
                if (!(layer instanceof Clementine30Layer) && !(layer instanceof ShadedElevationLayer)) continue;
                layer.setEnabled(false);
            }
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

