/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.rpf.wizard.RPFImportWizard;
import gov.nasa.worldwind.layers.rpf.wizard.RPFWizardUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LocallyGeneratedImagery
extends ApplicationTemplate {
    public static void runRPFImportWizard(WorldWindow worldWindow) {
        List<Layer> list;
        RPFImportWizard rPFImportWizard = new RPFImportWizard();
        rPFImportWizard.setTitle("Import CADRG/CIB Imagery");
        rPFImportWizard.getDialog().setPreferredSize(new Dimension(500, 400));
        LocallyGeneratedImagery.centerComponentOnScreen(rPFImportWizard.getDialog());
        int n = rPFImportWizard.showModalDialog();
        if (n == 0 && (list = RPFWizardUtil.getLayerList(rPFImportWizard.getModel())) != null) {
            for (Layer layer : list) {
                ApplicationTemplate.insertBeforePlacenames(worldWindow, layer);
            }
        }
    }

    private static void centerComponentOnScreen(Component component) {
        Dimension dimension = component.getPreferredSize();
        Point point = new Point(0, 0);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = point.x + (dimension2.width - dimension.width) / 2;
        int n2 = point.y + (dimension2.height - dimension.height) / 2;
        component.setLocation(n, n2);
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Locally Generated Imagery", AppFrame.class);
    }

    private static class RPFPanel
    extends JPanel {
        private LayerPanel layerPanel;
        private WorldWindow wwd;

        public RPFPanel(WorldWindow worldWindow) {
            this.wwd = worldWindow;
            this.initComponents();
        }

        private void onImportRPFPressed() {
            LocallyGeneratedImagery.runRPFImportWizard(this.wwd);
            this.layerPanel.update(this.wwd);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(10, 0, 10, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(20, 10, 20, 10));
            JButton jButton = new JButton("Import CADRG/CIB");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RPFPanel.this.onImportRPFPressed();
                }
            });
            jPanel.add((Component)jButton, "Center");
            this.add((Component)jPanel, "South");
            this.layerPanel = new LayerPanel(this.wwd, null);
            this.add((Component)this.layerPanel, "Center");
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private RPFPanel rpfPanel;

        public AppFrame() {
            super(true, false, false);
            this.initComponents();
        }

        private void initComponents() {
            this.rpfPanel = new RPFPanel(this.getWwd());
            this.getContentPane().add((Component)this.rpfPanel, "West");
        }
    }
}

