/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Quadrilateral;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public class DraggingShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Shape Dragging", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        WWIcon lastPickedIcon;

        public AppFrame() {
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.buildShapesLayer());
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.buildIconLayer());
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){
                private WWIcon lastToolTipIcon = null;
                private BasicDragger dragger = new BasicDragger(AppFrame.this.getWwd());

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
                        if (this.lastToolTipIcon != null) {
                            this.lastToolTipIcon.setShowToolTip(false);
                            this.lastToolTipIcon = null;
                            AppFrame.this.getWwd().repaint();
                        }
                        if (selectEvent.hasObjects() && !this.dragger.isDragging() && selectEvent.getTopObject() instanceof WWIcon) {
                            this.lastToolTipIcon = (WWIcon)selectEvent.getTopObject();
                            this.lastToolTipIcon.setShowToolTip(true);
                            AppFrame.this.getWwd().repaint();
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        this.dragger.selected(selectEvent);
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().repaint();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastPickedIcon == object) {
                return;
            }
            if (this.lastPickedIcon != null) {
                this.lastPickedIcon.setHighlighted(false);
                this.lastPickedIcon = null;
            }
            if (object != null && object instanceof WWIcon) {
                this.lastPickedIcon = (WWIcon)object;
                this.lastPickedIcon.setHighlighted(true);
            }
        }

        private IconLayer buildIconLayer() {
            IconLayer iconLayer = new IconLayer();
            Font font = this.makeToolTipFont();
            for (double d = 0.0; d < 10.0; d += 10.0) {
                for (double d2 = -180.0; d2 < 180.0; d2 += 10.0) {
                    double d3 = 0.0;
                    if (d2 % 90.0 == 0.0) {
                        d3 = 2000000.0;
                    }
                    UserFacingIcon userFacingIcon = new UserFacingIcon("images/32x32-icon-nasa.png", new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3));
                    userFacingIcon.setHighlightScale(1.5);
                    userFacingIcon.setToolTipFont(font);
                    userFacingIcon.setToolTipText(userFacingIcon.getImageSource().toString());
                    userFacingIcon.setToolTipTextColor(Color.YELLOW);
                    iconLayer.addIcon(userFacingIcon);
                }
            }
            return iconLayer;
        }

        private Font makeToolTipFont() {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.put(TextAttribute.BACKGROUND, new Color(0.4f, 0.4f, 0.4f, 1.0f));
            return Font.decode("Arial-BOLD-14").deriveFont(hashMap);
        }

        private RenderableLayer buildShapesLayer() {
            RenderableLayer renderableLayer = new RenderableLayer();
            Color color = new Color(1.0f, 1.0f, 0.0f, 0.3f);
            Color color2 = new Color(1.0f, 1.0f, 0.0f, 0.8f);
            SurfaceSector surfaceSector = new SurfaceSector(new Sector(Angle.fromDegrees(41.0), Angle.fromDegrees(41.6), Angle.fromDegrees(-122.5), Angle.fromDegrees(-121.7)), color, color2, null);
            renderableLayer.addRenderable(surfaceSector);
            SurfaceSector surfaceSector2 = new SurfaceSector(new Sector(Angle.fromDegrees(38.9), Angle.fromDegrees(39.3), Angle.fromDegrees(-120.2), Angle.fromDegrees(-119.9)), new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.8f), null);
            renderableLayer.addRenderable(surfaceSector2);
            SurfaceEllipse surfaceEllipse = new SurfaceEllipse(this.getWwd().getModel().getGlobe(), LatLon.fromDegrees(38.0, -104.0), 150000.0, 100000.0, Angle.fromDegrees(15.0), 16, new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.8f), null);
            renderableLayer.addRenderable(surfaceEllipse);
            SurfaceQuad surfaceQuad = new SurfaceQuad(this.getWwd().getModel().getGlobe(), LatLon.fromDegrees(42.0, -104.0), 100000.0, 130000.0, Angle.fromDegrees(20.0), new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.8f), null);
            renderableLayer.addRenderable(surfaceQuad);
            SurfaceSquare surfaceSquare = new SurfaceSquare(this.getWwd().getModel().getGlobe(), LatLon.fromDegrees(45.0, -104.0), 100000.0, new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.8f), null);
            renderableLayer.addRenderable(surfaceSquare);
            SurfaceCircle surfaceCircle = new SurfaceCircle(this.getWwd().getModel().getGlobe(), LatLon.fromDegrees(36.0, -104.0), 100000.0, 16, new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.8f), null);
            renderableLayer.addRenderable(surfaceCircle);
            Quadrilateral quadrilateral = new Quadrilateral(new Sector(Angle.fromDegrees(38.9), Angle.fromDegrees(39.3), Angle.fromDegrees(-120.2), Angle.fromDegrees(-119.9)), 50000.0);
            quadrilateral.setColor(new Color(1.0f, 1.0f, 0.0f, 1.0f));
            renderableLayer.addRenderable(quadrilateral);
            double d = 28.0;
            double d2 = -82.0;
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(new LatLon(Angle.fromDegrees(d + 5.0), Angle.fromDegrees(d2 + 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 5.0), Angle.fromDegrees(d2 - 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 2.5), Angle.fromDegrees(d2 - 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 2.5), Angle.fromDegrees(d2 - 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 5.0), Angle.fromDegrees(d2 - 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 5.0), Angle.fromDegrees(d2 + 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 2.5), Angle.fromDegrees(d2 + 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 2.5), Angle.fromDegrees(d2 + 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 5.0), Angle.fromDegrees(d2 + 2.5)));
            SurfacePolygon surfacePolygon = new SurfacePolygon(arrayList, new Color(1.0f, 0.11f, 0.2f, 0.4f), new Color(1.0f, 0.0f, 0.0f, 0.6f));
            surfacePolygon.setStroke(new BasicStroke(2.0f));
            renderableLayer.addRenderable(surfacePolygon);
            arrayList = new ArrayList();
            arrayList.add(new LatLon(Angle.fromDegrees(-10.0), Angle.fromDegrees(170.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(-10.0), Angle.fromDegrees(-170.0)));
            Polyline polyline = new Polyline(arrayList, 1000.0);
            polyline.setPathType(0);
            renderableLayer.addRenderable(polyline);
            arrayList = new ArrayList();
            arrayList.add(new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(-170.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(15.0), Angle.fromDegrees(170.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(10.0), Angle.fromDegrees(-175.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(5.0), Angle.fromDegrees(170.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(0.0), Angle.fromDegrees(-170.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(-170.0)));
            SurfacePolygon surfacePolygon2 = new SurfacePolygon(arrayList, new Color(1.0f, 0.11f, 0.2f, 0.4f), new Color(1.0f, 0.0f, 0.0f, 0.6f));
            surfacePolygon2.setStroke(new BasicStroke(2.0f));
            renderableLayer.addRenderable(surfacePolygon2);
            return renderableLayer;
        }
    }
}

