/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.UserFacingIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class AlarmIcons
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Icon Backgrounds", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private UserFacingIcon icon;
        private ArrayList<Action> alarmTypes = new ArrayList();

        public AppFrame() {
            super(true, false, false);
            IconLayer iconLayer = new IconLayer();
            this.icon = new UserFacingIcon("src/images/antenna.png", new Position(Angle.fromDegrees(38.0), Angle.fromDegrees(-116.0), 0.0));
            this.icon.setSize(new Dimension(64, 64));
            iconLayer.addIcon(this.icon);
            ApplicationTemplate.insertAfterPlacenames(this.getWwd(), iconLayer);
            BufferedImage bufferedImage = this.createBitmap("PatternFactory.PatternCircle", Color.YELLOW);
            BufferedImage bufferedImage2 = this.createBitmap("PatternFactory.PatternCircle", Color.RED);
            BufferedImage bufferedImage3 = this.createBitmap("PatternFactory.PatternTriangleUp", Color.YELLOW);
            BufferedImage bufferedImage4 = this.createBitmap("PatternFactory.PatternTriangleUp", Color.RED);
            BufferedImage bufferedImage5 = this.createBitmap("PatternFactory.PatternSquare", Color.YELLOW);
            BufferedImage bufferedImage6 = this.createBitmap("PatternFactory.PatternSquare", Color.RED);
            this.alarmTypes.add(new StaticAlarmAction("Static Yellow Circle", bufferedImage, 2.0));
            this.alarmTypes.add(new StaticAlarmAction("Static Smaller Red Circle", bufferedImage2, 1.5));
            this.alarmTypes.add(new StaticAlarmAction("Static Yellow Triangle", bufferedImage3, 2.0));
            this.alarmTypes.add(new StaticAlarmAction("Static Bigger Red Triangle", bufferedImage4, 2.5));
            this.alarmTypes.add(new PulsingAlarmAction("Pulsing Yellow Circle", (Object)bufferedImage, 100));
            this.alarmTypes.add(new PulsingAlarmAction("Pulsing Red Circle", (Object)bufferedImage2, 100));
            this.alarmTypes.add(new PulsingAlarmAction("Rapidly Pulsing Yellow Square", (Object)bufferedImage5, 50));
            this.alarmTypes.add(new PulsingAlarmAction("Rapidly Pulsing Red Square", (Object)bufferedImage6, 50));
            this.alarmTypes.add(new FlashingAlarmAction("Flashing Red Square", bufferedImage6, 200));
            this.alarmTypes.add(new FlashingAlarmAction("Flashing Yellow Triangle", bufferedImage3, 200));
            this.getContentPane().add((Component)this.makeControlPanel(), "West");
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (Action object2 : this.alarmTypes) {
                JRadioButton jRadioButton = new JRadioButton(object2);
                buttonGroup.add(jRadioButton);
                jPanel.add(jRadioButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.add((Component)jPanel, "North");
            jPanel2.setBorder(new CompoundBorder(new TitledBorder("Alarm States"), new EmptyBorder(20, 10, 20, 10)));
            JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
            jPanel3.add(jPanel2);
            jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
            return jPanel3;
        }

        private BufferedImage createBitmap(String string, Color color) {
            BufferedImage bufferedImage = PatternFactory.createPattern(string, new Dimension(128, 128), 0.7f, color, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
            bufferedImage = PatternFactory.blur(bufferedImage, 13);
            bufferedImage = PatternFactory.blur(bufferedImage, 13);
            bufferedImage = PatternFactory.blur(bufferedImage, 13);
            bufferedImage = PatternFactory.blur(bufferedImage, 13);
            return bufferedImage;
        }

        private class FlashingAlarmAction
        extends PulsingAlarmAction {
            private FlashingAlarmAction(String string, Object object, int n) {
                super(string, object, n, new double[]{2.0, 0.5});
            }
        }

        private class PulsingAlarmAction
        extends AbstractAction {
            protected final Object bgIconPath;
            protected int frequency;
            protected int scaleIndex;
            protected double[] scales;
            protected Timer timer;

            private PulsingAlarmAction(String string, Object object, int n) {
                super(string);
                this.scaleIndex = 0;
                this.scales = new double[]{1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.25, 3.0, 2.75, 2.5, 2.25, 2.0, 1.75, 1.5};
                this.bgIconPath = object;
                this.frequency = n;
            }

            private PulsingAlarmAction(String string, Object object, int n, double[] dArray) {
                this(string, object, n);
                this.scales = dArray;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.timer == null) {
                    this.timer = new Timer(this.frequency, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AppFrame.this.icon.setBackgroundScale(PulsingAlarmAction.this.scales[++PulsingAlarmAction.this.scaleIndex % PulsingAlarmAction.this.scales.length]);
                            AppFrame.this.getWwd().redraw();
                        }
                    });
                    ((JRadioButton)actionEvent.getSource()).addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 2) {
                                PulsingAlarmAction.this.timer.stop();
                            }
                        }
                    });
                }
                AppFrame.this.icon.setBackgroundImage(this.bgIconPath);
                this.scaleIndex = 0;
                this.timer.start();
            }
        }

        private class StaticAlarmAction
        extends AbstractAction {
            private Object bgIconPath;
            private double bgScale;

            private StaticAlarmAction(String string, Object object, double d) {
                super(string);
                this.bgIconPath = object;
                this.bgScale = d;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.icon.setBackgroundImage(this.bgIconPath);
                AppFrame.this.icon.setBackgroundScale(this.bgScale);
                AppFrame.this.getWwd().redraw();
            }
        }
    }
}

