/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.util;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opengis.annotation.UML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeList<E extends CodeList<E>>
implements Comparable<E>,
Serializable {
    private static final long serialVersionUID = 5655809691319522885L;
    private static final Map<Class<? extends CodeList>, Collection<? extends CodeList>> VALUES = new HashMap<Class<? extends CodeList>, Collection<? extends CodeList>>();
    private static final Class<String>[] CONSTRUCTOR_PARAMETERS = new Class[]{String.class};
    private final transient int ordinal;
    private final String name;
    private transient String identifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CodeList(String string, Collection<E> collection) {
        this.name = string = string.trim();
        Object object = collection;
        synchronized (object) {
            this.ordinal = collection.size();
            if (!collection.add(this)) {
                throw new IllegalArgumentException("Duplicated value: " + string);
            }
        }
        object = this.getClass();
        Map<Class<? extends CodeList>, Collection<? extends CodeList>> map = VALUES;
        synchronized (map) {
            Collection<E> collection2 = VALUES.put((Class<? extends CodeList>)object, collection);
            if (collection2 != null && collection2 != collection) {
                VALUES.put((Class<? extends CodeList>)object, collection2);
                throw new IllegalArgumentException("List already exists: " + collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CodeList> T valueOf(Class<T> clazz, String string) {
        Collection<? extends CodeList> collection;
        if (string == null) {
            return null;
        }
        string = string.trim();
        Object object = VALUES;
        synchronized (object) {
            collection = VALUES.get(clazz);
            if (collection == null) {
                if (clazz == null) {
                    throw new IllegalArgumentException("Code type is null");
                }
                throw new IllegalStateException("No collection of " + clazz.getSimpleName());
            }
        }
        object = collection;
        synchronized (object) {
            for (CodeList codeList : collection) {
                if (!codeList.matches(string)) continue;
                return (T)((CodeList)clazz.cast(codeList));
            }
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(CONSTRUCTOR_PARAMETERS);
                constructor.setAccessible(true);
                return (T)((CodeList)constructor.newInstance(string));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Can't create code of type " + clazz.getSimpleName(), exception);
            }
        }
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public String identifier() {
        String string = this.identifier;
        if (string == null) {
            Field field;
            Class<?> clazz = this.getClass();
            try {
                field = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = null;
            }
            if (field != null && Modifier.isStatic(field.getModifiers())) {
                UML uML;
                Object object;
                try {
                    object = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                if (this.equals(object) && (uML = field.getAnnotation(UML.class)) != null) {
                    string = uML.identifier();
                }
            }
            if (string == null) {
                string = "";
            }
            this.identifier = string;
        }
        return string.length() != 0 ? string : null;
    }

    public final String name() {
        return this.name;
    }

    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase(this.name)) {
            return true;
        }
        String string2 = this.identifier();
        return string2 != null && string.equalsIgnoreCase(string2);
    }

    public abstract E[] family();

    @Override
    public final int compareTo(E e) {
        Class<?> clazz;
        Class<?> clazz2 = this.getClass();
        if (!clazz2.equals(clazz = e.getClass())) {
            throw new ClassCastException("Can't compare " + clazz2.getSimpleName() + " to " + clazz.getSimpleName());
        }
        return this.ordinal - ((CodeList)e).ordinal;
    }

    public final boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            return this.ordinal == ((CodeList)object).ordinal;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Collection<? extends CodeList> collection;
        Class<?> clazz = this.getClass();
        Object object = VALUES;
        synchronized (object) {
            collection = VALUES.get(clazz);
        }
        if (collection != null) {
            object = collection;
            synchronized (object) {
                for (CodeList codeList : collection) {
                    if (!clazz.isInstance(codeList)) {
                        return this;
                    }
                    if (!codeList.matches(this.name)) continue;
                    return codeList;
                }
                Collection<? extends CodeList> collection2 = collection;
                if (!collection2.add(this)) {
                    throw new InvalidObjectException(this.name);
                }
            }
        }
        return this;
    }
}

