/*
 * Decompiled with CFR 0.152.
 */
package oms3.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oms3.Conversions;
import oms3.io.CSProperties;
import oms3.io.CSTable;
import oms3.io.CSVParser;
import oms3.io.CSVStrategy;
import oms3.io.MemoryTable;
import oms3.io.TableIterator;

public class DataIO {
    private static final String P = "@";
    public static final String TABLE = "@T";
    public static final String HEADER = "@H";
    public static final String PROPERTIES = "@S";
    public static final String PROPERTY = "@P";
    public static final String TABLE1 = "@Table";
    public static final String HEADER1 = "@Header";
    public static final String PROPERTIES1 = "@Properties";
    public static final String PROPERTY1 = "@Property";
    public static final String CSPROPERTIES_EXT = "csp";
    public static final String CSTABLE_EXT = "cst";
    private static final String ROOT_ANN = "___root___";
    private static final String COMMENT = "#";
    private static final Map<String, String> NOINFO = Collections.unmodifiableMap(new HashMap());
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^$}]+)\\}");
    private static final String ISO8601 = "yyyy-MM-dd'T'hh:mm:ss";
    public static final String KEY_CONVERTED_FROM = "converted_from";
    public static final String DATE_FORMAT = "date_format";
    public static final String DATE_START = "date_start";
    public static final String DATE_END = "date_end";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_MODIFIED_AT = "modifed_at";
    public static final String KEY_CREATED_BY = "created_by";
    public static final String KEY_UNIT = "unit";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_TYPE = "type";
    public static final String KEY_NAME = "name";
    public static final String KEY_MISSING_VAL = "missing_value";
    public static final String KEY_FC_START = "forecast_start";
    public static final String KEY_FC_DAYS = "forecast_days";
    public static final String KEY_HIST_YEAR = "historical_year";
    public static final String KEY_HIST_YEARS = "historical_years";
    public static final String KEY_ESP_DATES = "esp_dates";
    public static final String KEY_DIGEST = "digest";
    public static final String VAL_DATE = "Date";
    public static final int DAILY = 0;
    public static final int MEAN_MONTHLY = 1;
    public static final int MONTHLY_MEAN = 2;
    public static final int ANNUAL_MEAN = 3;
    public static final int PERIOD_MEAN = 4;
    public static final int PERIOD_MEDIAN = 5;
    public static final int PERIOD_STANDARD_DEVIATION = 6;
    public static final int PERIOD_MIN = 7;
    public static final int PERIOD_MAX = 8;
    public static final int RAW = 9;
    public static final int TIME_STEP = 10;

    public static double[] getColumnDoubleValuesInterval(Date start, Date end, CSTable t, String columnName, int timeStep) {
        boolean[] periodMask = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
        boolean[] subDivideMask = null;
        return DataIO.getColumnDoubleValuesInterval(start, end, t, columnName, timeStep, 0, periodMask, subDivideMask);
    }

    public static double[] getColumnDoubleValuesInterval(Date start, Date end, CSTable t, String columnName, int timeStep, boolean[] periodMask) {
        boolean[] subDivideMask = null;
        return DataIO.getColumnDoubleValuesInterval(start, end, t, columnName, timeStep, 0, periodMask, subDivideMask);
    }

    public static double[] getColumnDoubleValuesInterval(Date start, Date end, CSTable t, String columnName, int timeStep, int startMonth, boolean[] periodMask, boolean[] subDivideMask) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        if (periodMask != null) {
            boolean pmCheck = false;
            for (int i = 0; i < periodMask.length; ++i) {
                pmCheck |= periodMask[i];
            }
            if (!pmCheck) {
                throw new IllegalArgumentException("PeriodMask (i.e. Mask of months to include in data analysis) is all false, so no data would be used.");
            }
        }
        if (timeStep == 9) {
            Double[] a = DataIO.getColumnDoubleValues(t, columnName);
            double[] arr = Conversions.convert(a, double[].class);
            return arr;
        }
        SimpleDateFormat fmt = DataIO.lookupDateFormat(t, 1);
        boolean hasYear = DataIO.DateFormatHasYear(t, 1);
        switch (timeStep) {
            case 10: {
                ArrayList<Double> l = new ArrayList<Double>();
                double sum = 0.0;
                for (String[] row : t.rows()) {
                    try {
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        int month = d.getMonth();
                        double data = Double.parseDouble(row[col]);
                        boolean periodValid = periodMask == null || periodMask[month];
                        if (!periodValid) continue;
                        l.add(data);
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                double[] arr = new double[l.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (Double)l.get(i);
                }
                return arr;
            }
            case 0: 
            case 2: {
                int previousMonth = -1;
                int previousYear = -1;
                int previousDay = -1;
                boolean previousValid = false;
                boolean useYear = timeStep == 0 || timeStep == 2 || timeStep == 3;
                boolean useMonth = timeStep == 0 || timeStep == 2;
                boolean useDay = timeStep == 0;
                ArrayList<Double> l = new ArrayList<Double>();
                double sum = 0.0;
                int count = 0;
                int sdindx = 0;
                for (String[] row : t.rows()) {
                    try {
                        boolean subDivideValid;
                        boolean newEntry;
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        int month = d.getMonth();
                        int year = d.getYear();
                        int day = d.getDate();
                        double data = Double.parseDouble(row[col]);
                        boolean newYear = year != previousYear;
                        boolean bl = newEntry = previousValid && (useYear && newYear || useMonth && month != previousMonth || useDay && day != previousDay);
                        if (newEntry && count != 0) {
                            l.add(sum / (double)count);
                            sum = 0.0;
                            count = 0;
                        }
                        boolean periodValid = periodMask == null || periodMask[month];
                        boolean bl2 = subDivideValid = subDivideMask == null || subDivideMask[sdindx++];
                        if (periodValid && subDivideValid) {
                            sum += data;
                            ++count;
                        }
                        previousValid = true;
                        previousDay = day;
                        previousMonth = month;
                        previousYear = year;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (count != 0) {
                    l.add(sum / (double)count);
                }
                double[] arr = new double[l.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (Double)l.get(i);
                }
                return arr;
            }
            case 1: {
                double[] arr = new double[12];
                int[] count = new int[12];
                int sdindx = 0;
                for (int i = 0; i < 12; ++i) {
                    arr[i] = 0.0;
                    count[i] = 0;
                }
                for (String[] row : t.rows()) {
                    try {
                        boolean subDivideValid;
                        Date d = fmt.parse(row[1]);
                        if (hasYear && (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end))) continue;
                        int month = d.getMonth();
                        if (month > 11) {
                            throw new RuntimeException("Month > 11 = " + month);
                        }
                        double data = Double.parseDouble(row[col]);
                        boolean periodValid = periodMask == null || periodMask[month];
                        boolean bl = subDivideValid = subDivideMask == null || subDivideMask[sdindx++];
                        if (!periodValid || !subDivideValid) continue;
                        arr[month] = arr[month] + data;
                        count[month] = count[month] + 1;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (int i = 0; i < 12; ++i) {
                    arr[i] = count[i] == 0 ? 0.0 : arr[i] / (double)count[i];
                }
                return arr;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int previousMonth = -1;
                int previousYear = -1;
                int previousDay = -1;
                boolean previousValid = false;
                ArrayList<Double> l = new ArrayList<Double>();
                ArrayList<Double> l_median = new ArrayList<Double>();
                double sum = 0.0;
                double sq_sum = 0.0;
                int count = 0;
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                int sdindx = 0;
                for (String[] row : t.rows()) {
                    try {
                        boolean subDivideValid;
                        boolean newEntry;
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        int month = d.getMonth();
                        int year = d.getYear();
                        int day = d.getDate();
                        double data = Double.parseDouble(row[col]);
                        boolean newYear = month != previousMonth && month == startMonth;
                        boolean bl = newEntry = previousValid && newYear;
                        if (newEntry && count != 0) {
                            l.add(DataIO.selectResult(timeStep, sum, sq_sum, count, min, max, l_median));
                            sum = 0.0;
                            sq_sum = 0.0;
                            count = 0;
                            min = Double.MAX_VALUE;
                            max = Double.MIN_VALUE;
                            l_median.clear();
                        }
                        boolean periodValid = periodMask == null || periodMask[month];
                        boolean bl3 = subDivideValid = subDivideMask == null || subDivideMask[sdindx++];
                        if (periodValid && subDivideValid) {
                            sum += data;
                            sq_sum += data * data;
                            ++count;
                            if (data < min) {
                                min = data;
                            }
                            if (data > max) {
                                max = data;
                            }
                            l_median.add(data);
                        }
                        previousValid = true;
                        previousDay = day;
                        previousMonth = month;
                        previousYear = year;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (count != 0) {
                    double selVal = DataIO.selectResult(timeStep, sum, sq_sum, count, min, max, l_median);
                    l.add(selVal);
                }
                double[] arr = new double[l.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (Double)l.get(i);
                }
                return arr;
            }
        }
        throw new IllegalArgumentException("timeStep " + timeStep + "not supported.");
    }

    private static double selectResult(int timeStep, double sum, double sq_sum, int count, double min, double max, List<Double> l) {
        if (timeStep == 3 || timeStep == 4) {
            return count == 0 ? 0.0 : sum / (double)count;
        }
        if (timeStep == 7) {
            return min;
        }
        if (timeStep == 8) {
            return max;
        }
        if (timeStep == 5) {
            double median;
            int lSize = l.size();
            if (lSize == 0) {
                throw new RuntimeException("No data in file matched the specified period ");
            }
            double[] arr = new double[lSize];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = l.get(i);
            }
            Arrays.sort(arr);
            if (lSize % 2 == 1) {
                median = arr[(lSize + 1) / 2 - 1];
            } else {
                double lower = arr[lSize / 2 - 1];
                double upper = arr[lSize / 2];
                median = (lower + upper) / 2.0;
            }
            return median;
        }
        if (timeStep == 6) {
            double mean = count == 0 ? 0.0 : sum / (double)count;
            double variance = sq_sum / (double)count - mean * mean;
            double standardDeviation = Math.sqrt(variance);
            return standardDeviation;
        }
        throw new RuntimeException("TimeStep " + timeStep + " not supported here.");
    }

    public static SimpleDateFormat lookupDateFormat(CSTable table, int col) {
        if (col < 0 || col > table.getColumnCount()) {
            throw new IllegalArgumentException("invalid column: " + col);
        }
        String format = table.getColumnInfo(col).get(KEY_FORMAT);
        if (format == null) {
            format = table.getInfo().get(DATE_FORMAT);
        }
        if (format == null) {
            format = Conversions.ISO().toPattern();
        }
        return new SimpleDateFormat(format);
    }

    public static boolean DateFormatHasYear(CSTable table, int col) {
        if (col < 0 || col > table.getColumnCount()) {
            throw new IllegalArgumentException("invalid column: " + col);
        }
        String format = table.getColumnInfo(col).get(KEY_FORMAT);
        if (format == null) {
            format = table.getInfo().get(DATE_FORMAT);
        }
        if (format == null) {
            format = Conversions.ISO().toPattern();
        }
        return format.contains("YY") || format.contains("yy");
    }

    public static int findRowByDate(Date date, int dateColumn, CSTable table) {
        long start = System.currentTimeMillis();
        String type = table.getColumnInfo(dateColumn).get(KEY_TYPE);
        if (type == null || !type.equalsIgnoreCase(VAL_DATE)) {
            throw new IllegalArgumentException("type " + type);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        String year = Integer.toString(cal.get(1));
        SimpleDateFormat fmt = DataIO.lookupDateFormat(table, dateColumn);
        int rowNo = 0;
        TableIterator rows = (TableIterator)table.rows().iterator();
        while (rows.hasNext()) {
            String[] row = (String[])rows.next();
            try {
                Date d;
                if (row[dateColumn].contains(year) && (d = fmt.parse(row[dateColumn])).equals(date)) {
                    long end = System.currentTimeMillis();
                    return rowNo;
                }
                ++rowNo;
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        rows.close();
        throw new IllegalArgumentException(date.toString());
    }

    public static List<String[]> extractRows(CSTable table, int startRow, int endRow) {
        if (endRow <= startRow || startRow < 0 || endRow < 0) {
            throw new IllegalArgumentException("invalid start/end Row : " + startRow + "/" + endRow);
        }
        ArrayList<String[]> l = new ArrayList<String[]>();
        for (String[] r : table.rows(startRow)) {
            l.add(r);
            if (Integer.parseInt(r[0]) <= endRow) continue;
            break;
        }
        return l;
    }

    public static int[] sliceByTime(CSTable table, int timeCol, Date start, Date end) {
        if (end.before(start)) {
            throw new IllegalArgumentException("end < start:" + end + "  <  " + start);
        }
        if (timeCol < 0) {
            throw new IllegalArgumentException("timeCol :" + timeCol);
        }
        int s = -1;
        int e = -1;
        int i = -1;
        SimpleDateFormat df = DataIO.lookupDateFormat(table, timeCol);
        for (String[] col : table.rows()) {
            ++i;
            Date d = Conversions.convert((Object)col[timeCol], Date.class, df);
            if (s == -1 && (start.before(d) || start.equals(d))) {
                s = i;
            }
            if (e != -1 || !end.before(d) && !end.equals(d)) continue;
            e = i;
            break;
        }
        return new int[]{s, e};
    }

    public static TableModel createTableModel(final CSTable src) {
        final ArrayList<String[]> rows = new ArrayList<String[]>();
        for (String[] row : src.rows()) {
            rows.add(row);
        }
        return new TableModel(){

            @Override
            public int getColumnCount() {
                return src.getColumnCount();
            }

            @Override
            public String getColumnName(int column) {
                return src.getColumnName(column);
            }

            @Override
            public int getRowCount() {
                return rows.size();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])rows.get(rowIndex))[columnIndex];
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }
        };
    }

    public static AbstractTableModel getProperties(final CSProperties p) {
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return p.keySet().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return " " + p.keySet().toArray()[rowIndex];
                }
                return p.values().toArray()[rowIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    String[] keys = p.keySet().toArray(new String[0]);
                    p.put(keys[rowIndex], aValue.toString());
                }
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? "Name" : "Value";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static AbstractTableModel get2DBounded(final CSProperties p, final String pname) throws ParseException {
        String m = p.getInfo(pname).get("bound");
        String[] dims = m.split(",");
        final int rows = DataIO.getInt(p, dims[0].trim());
        final int cols = DataIO.getInt(p, dims[1].trim());
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rows;
            }

            @Override
            public int getColumnCount() {
                return cols;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public Object getValueAt(int row, int col) {
                String[][] d = Conversions.convert(p.get(pname), String[][].class);
                return d[row][col].trim();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                String[][] d = Conversions.convert(p.get(pname), String[][].class);
                d[rowIndex][columnIndex] = aValue.toString().trim();
                String s = DataIO.toArrayString(d);
                p.put(pname, s);
            }

            @Override
            public String getColumnName(int column) {
                return Integer.toString(column);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static boolean playsRole(CSProperties p, String key, String role) {
        String r = p.getInfo(key).get("role");
        if (r == null) {
            return false;
        }
        return r.contains(role);
    }

    public static int getBound(CSProperties p, String key) {
        String bound = p.getInfo(key).get("bound");
        if (bound == null) {
            return 0;
        }
        StringTokenizer t = new StringTokenizer(bound, ",");
        return t.countTokens();
    }

    public static boolean isBound(CSProperties p, String key, int dim) {
        String bound = p.getInfo(key).get("bound");
        if (bound == null) {
            return false;
        }
        StringTokenizer t = new StringTokenizer(bound, ",");
        return t.countTokens() == dim;
    }

    public static void copyProperty(String key, CSProperties from, CSProperties to) {
        Object v = from.get(key);
        Map<String, String> meta = from.getInfo(key);
        to.put(key, v);
        to.getInfo(key).putAll(meta);
    }

    public static AbstractTableModel getBoundProperties(final CSProperties p, String boundName) throws ParseException {
        final int rows = DataIO.getInt(p, boundName);
        final List<String> arr = DataIO.keysByMeta(p, "bound", boundName);
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rows;
            }

            @Override
            public int getColumnCount() {
                return arr.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String colname = (String)arr.get(columnIndex);
                String[] d = Conversions.convert(p.get(colname), String[].class);
                return d[rowIndex].trim();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                String colname = (String)arr.get(columnIndex);
                String[] d = Conversions.convert(p.get(colname), String[].class);
                d[rowIndex] = aValue.toString().trim();
                String s = DataIO.toArrayString(d);
                p.put(colname, s);
            }

            @Override
            public String getColumnName(int column) {
                return (String)arr.get(column);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static AbstractTableModel getUnBoundProperties(final CSProperties p) throws ParseException {
        final List<String> arr = DataIO.keysByNotMeta(p, "bound");
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return arr.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return arr.get(rowIndex);
                }
                return p.get(arr.get(rowIndex));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                p.put(arr.get(rowIndex), aValue.toString());
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? "Key" : "Value";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static String toArrayString(String[] arr) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < arr.length; ++i) {
            b.append(arr[i]);
            if (i >= arr.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public static String toArrayString(String[][] arr) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < arr.length; ++i) {
            b.append('{');
            for (int j = 0; j < arr[i].length; ++j) {
                b.append(arr[i][j]);
                if (j >= arr[i].length - 1) continue;
                b.append(',');
            }
            b.append('}');
            if (i >= arr.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public static TableModel fromCSP(CSProperties p, final int dim) {
        List<String> dims = DataIO.keysByMeta(p, "role", "dimension");
        if (dims.isEmpty()) {
            return null;
        }
        for (String d : dims) {
            if (Integer.parseInt(p.get(d).toString()) != dim) continue;
            final List<String> bounds = DataIO.keysByMeta(p, "bound", d);
            final ArrayList<double[]> columns = new ArrayList<double[]>(bounds.size());
            for (String bound : bounds) {
                columns.add(Conversions.convert(p.get(bound), double[].class));
            }
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return dim;
                }

                @Override
                public int getColumnCount() {
                    return bounds.size();
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return Array.get(columns.get(columnIndex), rowIndex);
                }

                @Override
                public String getColumnName(int column) {
                    return (String)bounds.get(column);
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Double.class;
                }
            };
        }
        return null;
    }

    public static List<String> keysByMeta(CSProperties csp, String mkey, String mval) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            String role;
            if (!csp.getInfo(key).keySet().contains(mkey) || !(role = csp.getInfo(key).get(mkey)).equals(mval)) continue;
            l.add(key);
        }
        return l;
    }

    public static List<String> keysForBounds(CSProperties csp, int boundCount) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            String bound;
            StringTokenizer t;
            if (!csp.getInfo(key).keySet().contains("bound") || (t = new StringTokenizer(bound = csp.getInfo(key).get("bound"), ",")).countTokens() != boundCount) continue;
            l.add(key);
        }
        return l;
    }

    public static List<String> keysByNotMeta(CSProperties csp, String mkey) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            if (csp.getInfo(key).keySet().contains(mkey)) continue;
            l.add(key);
        }
        return l;
    }

    public static Date[] getColumnDateValues(CSTable t, String columnName) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        Conversions.Params p = new Conversions.Params();
        p.add(String.class, Date.class, DataIO.lookupDateFormat(t, col));
        ArrayList<Date> l = new ArrayList<Date>();
        for (String[] s : t.rows()) {
            l.add(Conversions.convert((Object)s[col], Date.class, p));
        }
        return l.toArray(new Date[0]);
    }

    public static Double[] getColumnDoubleValues(CSTable t, String columnName) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        ArrayList<Double> l = new ArrayList<Double>();
        for (String[] s : t.rows()) {
            l.add(new Double(s[col]));
        }
        return l.toArray(new Double[0]);
    }

    public static Date getDate(CSProperties p, String key) throws ParseException {
        String val = p.get(key).toString();
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        String f = p.getInfo(key).get(KEY_FORMAT);
        SimpleDateFormat fmt = new SimpleDateFormat(f == null ? ISO8601 : f);
        return fmt.parse(val);
    }

    public static int getInt(CSProperties p, String key) throws ParseException {
        String val = p.get(key).toString();
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        return Integer.parseInt(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(CSProperties csp, File f, String title) {
        try (PrintWriter w = null;){
            if (csp instanceof BasicCSProperties) {
                BasicCSProperties c = (BasicCSProperties)csp;
                c.setName(title);
            }
            w = new PrintWriter(f);
            DataIO.print(csp, w);
            w.close();
        }
    }

    public static void print(CSProperties props, PrintWriter out) {
        out.println("@S," + CSVParser.printLine(props.getName()));
        for (String key : props.getInfo().keySet()) {
            out.println(" " + CSVParser.printLine(key, props.getInfo().get(key)));
        }
        out.println();
        for (String key : props.keySet()) {
            out.println("@P," + CSVParser.printLine(key, props.get(key).toString()));
            for (String key1 : props.getInfo(key).keySet()) {
                out.println(" " + CSVParser.printLine(key1, props.getInfo(key).get(key1)));
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void printWithTables(CSProperties props, PrintWriter out) {
        List<String> arrays;
        out.println("@S," + CSVParser.printLine(props.getName()));
        for (String key : props.getInfo().keySet()) {
            if (key.startsWith("oms")) continue;
            out.println(" " + CSVParser.printLine(key, props.getInfo().get(key)));
        }
        out.println();
        ArrayList<String> vars = new ArrayList<String>();
        String[] _1D = null;
        String[] _2D = null;
        if (props.getInfo().containsKey("oms.1D")) {
            for (String dim : _1D = Conversions.convert(props.getInfo().get("oms.1D"), String[].class)) {
                arrays = DataIO.keysByMeta(props, "bound", dim.trim());
                vars.addAll(arrays);
            }
        }
        if (props.getInfo().containsKey("oms.2D")) {
            for (String var : _2D = Conversions.convert(props.getInfo().get("oms.2D"), String[].class)) {
                vars.add(var.trim());
            }
        }
        for (String key : props.keySet()) {
            if (vars.contains(key)) continue;
            out.println("@P," + CSVParser.printLine(key, props.get(key).toString()));
            for (String key1 : props.getInfo(key).keySet()) {
                out.println(" " + CSVParser.printLine(key1, props.getInfo(key).get(key1)));
            }
            out.println();
        }
        if (_1D != null) {
            for (String dim : _1D) {
                arrays = DataIO.keysByMeta(props, "bound", dim.trim());
                vars.addAll(arrays);
                CSTable table = DataIO.asTable(props, dim.trim());
                if (table == null) continue;
                DataIO.print(table, out);
                out.println();
            }
        }
        if (_2D != null) {
            for (String var : _2D) {
                vars.add(var.trim());
                CSTable table = DataIO.as2DTable(props, var.trim());
                if (table == null) continue;
                DataIO.print(table, out);
                out.println();
            }
        }
        out.flush();
    }

    public static void print(Map<String, Object> props, String header, PrintWriter out) {
        out.println("@S," + header);
        out.println();
        for (String key : props.keySet()) {
            out.println("@P," + CSVParser.printLine(key, props.get(key).toString()));
        }
        out.println();
        out.flush();
    }

    public static void print(CSTable table, PrintWriter out) {
        int i;
        out.println("@T," + CSVParser.printLine(table.getName()));
        for (String key : table.getInfo().keySet()) {
            out.println(" " + CSVParser.printLine(key, table.getInfo().get(key)));
        }
        if (table.getColumnCount() < 1) {
            out.flush();
            return;
        }
        out.print(HEADER);
        for (int i2 = 1; i2 <= table.getColumnCount(); ++i2) {
            out.print("," + table.getColumnName(i2));
        }
        out.println();
        Map<String, String> m = table.getColumnInfo(1);
        for (String key : m.keySet()) {
            out.print(key);
            for (i = 1; i <= table.getColumnCount(); ++i) {
                out.print("," + table.getColumnInfo(i).get(key));
            }
            out.println();
        }
        for (String[] row : table.rows()) {
            for (i = 1; i < row.length; ++i) {
                out.print("," + row[i]);
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void save(CSTable table, File file) throws IOException {
        PrintWriter w = new PrintWriter(file);
        DataIO.print(table, w);
        w.close();
    }

    public static CSProperties properties(Reader r, String name) throws IOException {
        return new CSVProperties(r, name);
    }

    public static CSProperties properties(File r, String name) throws IOException {
        return new CSVProperties(new FileReader(r), name);
    }

    public static CSProperties properties(Reader[] r, String name) throws IOException {
        CSVProperties p = new CSVProperties(r[0], name);
        for (int i = 1; i < r.length; ++i) {
            CSVParser csv = new CSVParser(r[i], CSVStrategy.DEFAULT_STRATEGY);
            DataIO.locate(csv, name, PROPERTIES, PROPERTIES1);
            p.readProps(csv);
            r[i].close();
        }
        return p;
    }

    public static void merge(CSProperties base, CSProperties overlay) {
        for (String key : overlay.keySet()) {
            if (base.getInfo(key).containsKey("public")) {
                base.put(key, overlay.get(key));
                continue;
            }
            throw new IllegalArgumentException("Not public: " + key);
        }
    }

    public static CSTable merge(CSTable t1, CSTable t2, String name) {
        int i;
        MemoryTable t = new MemoryTable();
        t.setName(name);
        t.getInfo().putAll(t1.getInfo());
        t.getInfo().putAll(t2.getInfo());
        List<String> t1_col = DataIO.columnNames(t1);
        List<String> t2_col = DataIO.columnNames(t2);
        int t1_c = t1_col.size();
        int t2_c = t2_col.size();
        t1_col.addAll(t2_col);
        t.setColumns(t1_col.toArray(new String[0]));
        int col = 1;
        for (i = 0; i < t1_c; ++i) {
            t.getColumnInfo(col).putAll(t1.getColumnInfo(col));
            ++col;
        }
        for (i = 1; i <= t2_c; ++i) {
            t.getColumnInfo(col).putAll(t2.getColumnInfo(i));
            ++col;
        }
        String[] r = new String[t1_col.size()];
        Iterator<String[]> row_1 = t1.rows().iterator();
        Iterator<String[]> row_2 = t2.rows().iterator();
        while (row_1.hasNext() && row_2.hasNext()) {
            String[] s1 = row_1.next();
            String[] s2 = row_2.next();
            System.arraycopy(s1, 1, r, 0, s1.length - 1);
            System.arraycopy(s2, 1, r, s1.length - 1, s2.length - 1);
            t.addRow(r);
        }
        return t;
    }

    public static Properties properties(CSProperties p) {
        Properties pr = new Properties();
        pr.putAll((Map<?, ?>)p);
        return pr;
    }

    public static CSProperties properties(Properties p) {
        return new BasicCSProperties(p);
    }

    public static CSProperties properties(Map<String, Object> p) {
        return new BasicCSProperties(p);
    }

    public static CSProperties properties() {
        return new BasicCSProperties();
    }

    public static CSTable table(File file) throws IOException {
        return DataIO.table(file, null);
    }

    public static CSTable table(File file, String name) throws IOException {
        return new FileTable(file, name);
    }

    public static CSTable table(String s) throws IOException {
        return DataIO.table(s, null);
    }

    public static CSTable table(String s, String name) throws IOException {
        return new StringTable(s, name);
    }

    public static CSTable table(URL url) throws IOException {
        return DataIO.table(url, null);
    }

    public static CSTable table(URL url, String name) throws IOException {
        return new URLTable(url, name);
    }

    public static boolean columnExist(CSTable table, String name) {
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public static int columnIndex(CSTable table, String name) {
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static int[] columnIndexes(CSTable table, String name) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            l.add(i);
        }
        if (l.isEmpty()) {
            return null;
        }
        int[] idx = new int[l.size()];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = (Integer)l.get(i);
        }
        return idx;
    }

    public static List<String> columnNames(CSTable table) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            l.add(table.getColumnName(i));
        }
        return l;
    }

    public static List<String> columnNames(CSTable table, String name) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            l.add(table.getColumnName(i));
        }
        if (l.isEmpty()) {
            throw new IllegalArgumentException("No column(s) '" + name + "' in table: " + table.getName());
        }
        return l;
    }

    public static Map<String, String[]> columnMetaData(CSTable table) {
        HashMap<String, String[]> meta = new HashMap<String, String[]>();
        int n = table.getColumnCount();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            Map<String, String> m = table.getColumnInfo(i);
            for (String k : m.keySet()) {
                String[] s;
                if (!meta.containsKey(k)) {
                    s = new String[n];
                    meta.put(k, s);
                }
                s = (String[])meta.get(k);
                s[i - 1] = m.get(k);
            }
        }
        return meta;
    }

    public static void rowStringValues(String[] row, int[] idx, String[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = row[idx[i]];
        }
    }

    public static double[] rowDoubleValues(String[] row, int[] idx, double[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Double.parseDouble(row[idx[i]]);
        }
        return vals;
    }

    public static double[] rowDoubleValues(String[] row, int[] idx) {
        double[] vals = new double[idx.length];
        return DataIO.rowDoubleValues(row, idx, vals);
    }

    public static CSTable extractColumns(CSTable table, String ... colNames) {
        int[] idx = new int[]{};
        for (String name : colNames) {
            idx = DataIO.add(idx, DataIO.columnIndexes(table, name));
        }
        if (idx.length == 0) {
            throw new IllegalArgumentException("No such column names: " + Arrays.toString(colNames));
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (String name : colNames) {
            cols.addAll(DataIO.columnNames(table, name));
        }
        MemoryTable t = new MemoryTable();
        t.setName(table.getName());
        t.getInfo().putAll(table.getInfo());
        t.setColumns(cols.toArray(new String[0]));
        for (int i = 0; i < idx.length; ++i) {
            t.getColumnInfo(i + 1).putAll(table.getColumnInfo(idx[i]));
        }
        String[] r = new String[idx.length];
        for (String[] row : table.rows()) {
            DataIO.rowStringValues(row, idx, r);
            t.addRow(r);
        }
        return t;
    }

    public static String diff(double[] o, double[] p) {
        String status = "ok.";
        if (o.length != p.length) {
            status = "o.length != p.length";
        } else {
            for (int i = 0; i < o.length; ++i) {
                if (o[i] == p[i]) continue;
                status = status + "error";
            }
        }
        return status;
    }

    public static double[][] asArray(CSTable table) {
        ArrayList<double[]> l = new ArrayList<double[]>();
        for (String[] row : table.rows()) {
            double[] r = new double[row.length - 1];
            for (int i = 1; i < row.length; ++i) {
                r[i - 1] = Double.parseDouble(row[i]);
            }
            l.add(r);
        }
        double[][] d = new double[l.size()][];
        for (int i = 0; i < d.length; ++i) {
            d[i] = (double[])l.get(i);
        }
        return d;
    }

    public static CSProperties from2DTable(CSTable t) {
        String n = t.getName();
        if (n == null) {
            throw new RuntimeException("2D variable name missing");
        }
        double[][] d = DataIO.asArray(t);
        BasicCSProperties p = new BasicCSProperties();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("bound", t.getInfo().get("bound"));
        m.put("len", d.length + "," + d[0].length);
        p.put(n, Conversions.convert(d, String.class));
        p.setInfo(n, m);
        return p;
    }

    public static CSTable asTable(CSProperties p, String dim) {
        List<String> arrays = DataIO.keysByMeta(p, "bound", dim);
        if (arrays.isEmpty()) {
            return null;
        }
        int len = 0;
        ArrayList<String[]> m = new ArrayList<String[]>();
        for (String arr : arrays) {
            String[] d = Conversions.convert(p.get(arr), String[].class);
            len = d.length;
            m.add(d);
        }
        String[] cols = new String[m.size()];
        for (int i = 0; i < arrays.size(); ++i) {
            String a = arrays.get(i);
            cols[i] = a.substring(a.indexOf(36) + 1);
        }
        MemoryTable table = new MemoryTable();
        table.getInfo().put("description", "Parameter bound by '" + dim + "'");
        table.getInfo().put("len", Integer.toString(len));
        table.setName(dim);
        table.setColumns(cols);
        String[] row = new String[m.size()];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < m.size(); ++j) {
                row[j] = ((String[])m.get(j))[i].trim();
            }
            table.addRow(row);
        }
        return table;
    }

    public static CSTable asTable(CSProperties p, String dim, String tableName) {
        List<String> arrays = DataIO.keysByMeta(p, "bound", dim);
        if (arrays.isEmpty()) {
            return null;
        }
        int len = 0;
        ArrayList<String[]> m = new ArrayList<String[]>();
        for (String arr : arrays) {
            String[] d = Conversions.convert(p.get(arr), String[].class);
            len = d.length;
            m.add(d);
        }
        MemoryTable table = new MemoryTable();
        table.getInfo().put("info", "Parameter bound by " + dim);
        table.setName(tableName);
        table.setColumns(arrays.toArray(new String[m.size()]));
        String[] row = new String[m.size()];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < m.size(); ++j) {
                row[j] = ((String[])m.get(j))[i].trim();
            }
            table.addRow(row);
        }
        return table;
    }

    public static CSTable as2DTable(CSProperties p, String key) {
        Object val = p.get(key);
        String[][] vals = Conversions.convert(val, String[][].class);
        MemoryTable table = new MemoryTable();
        table.setName(key);
        table.getInfo().putAll(p.getInfo(key));
        if (!table.getInfo().containsKey("len")) {
            table.getInfo().put("len", vals.length + "," + vals[0].length);
        }
        String[] header = new String[vals[0].length];
        for (int i = 0; i < header.length; ++i) {
            header[i] = Integer.toString(i);
        }
        table.setColumns(header);
        for (int row = 0; row < vals.length; ++row) {
            table.addRow(vals[row]);
        }
        return table;
    }

    public static CSTable as2DTable(CSProperties p, String dim, String tableName) {
        List<String> arrays = DataIO.keysByMeta(p, "bound", dim);
        if (arrays.isEmpty()) {
            return null;
        }
        return DataIO.as2DTable(p, arrays.get(0));
    }

    public static CSProperties fromTable(CSTable t) {
        String name = t.getName();
        if (t.getInfo().get("bound") != null && t.getInfo().get("bound").indexOf(44) != -1) {
            return DataIO.from2DTable(t);
        }
        return DataIO.from1DTable(t);
    }

    public static CSProperties from1DTable(CSTable t) {
        int i;
        BasicCSProperties p = new BasicCSProperties();
        HashMap table = new HashMap();
        for (int i2 = 1; i2 <= t.getColumnCount(); ++i2) {
            table.put(i2, new ArrayList());
        }
        for (String[] row : t.rows()) {
            for (i = 1; i < row.length; ++i) {
                ((List)table.get(i)).add(row[i].trim());
            }
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        String tname = t.getName();
        m.put("bound", tname);
        for (i = 1; i <= t.getColumnCount(); ++i) {
            String name = t.getColumnName(i);
            p.put(tname + "$" + name, ((List)table.get(i)).toString().replace('[', '{').replace(']', '}'));
            m.put("len", Integer.toString(((List)table.get(i)).size()));
            p.setInfo(tname + "$" + name, m);
        }
        return p;
    }

    public static List<String> tables(File f) throws IOException {
        return DataIO.findCSVElements(f, TABLE);
    }

    public static boolean tableExists(String table, File f) throws IOException {
        List<String> tables = DataIO.tables(f);
        return tables.contains(table);
    }

    public static List<String> properties(File f) throws IOException {
        return DataIO.findCSVElements(f, PROPERTIES);
    }

    public static boolean propertyExists(String property, File f) throws IOException {
        List<String> properties = DataIO.properties(f);
        return properties.contains(property);
    }

    static List<String> findCSVElements(File f, String tag) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        FileReader r = new FileReader(f);
        CSVParser csv = new CSVParser(r, CSVStrategy.DEFAULT_STRATEGY);
        String[] line = null;
        while ((line = csv.getLine()) != null) {
            if (line.length < 2 || !line[0].equals(tag)) continue;
            l.add(line[1]);
        }
        ((Reader)r).close();
        return l;
    }

    private static int[] add(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static String locate(CSVParser csv, String name, String ... type) throws IOException {
        if (name == null) {
            name = ".+";
        }
        Pattern p = Pattern.compile(name);
        String[] line = null;
        while ((line = csv.getLine()) != null) {
            if (line[0].startsWith(COMMENT) || !line[0].startsWith(P)) continue;
            for (String s : type) {
                if (!line[0].equalsIgnoreCase(s) || !p.matcher(line[1].trim()).matches()) continue;
                return line[1];
            }
        }
        throw new IllegalArgumentException("Not found : " + Arrays.toString(type) + ", " + name);
    }

    public static String[] parseCsvFilename(String file) {
        String f = file.toLowerCase();
        if (!f.contains(".csv")) {
            throw new IllegalArgumentException("Not a csv file: " + file);
        }
        if (f.endsWith(".csv")) {
            return new String[]{file};
        }
        file = file.replace('\\', '/');
        int fpos = f.indexOf(".csv") + 4;
        String base = file.substring(0, fpos);
        String info = file.substring(fpos + 1);
        String[] parts = info.split("/");
        if (parts.length == 1) {
            return new String[]{base, parts[0]};
        }
        if (parts.length == 2) {
            return new String[]{base, parts[0], parts[1]};
        }
        throw new IllegalArgumentException("Not a valid descriptior:" + file);
    }

    public static void main(String[] args) throws IOException, ParseException {
        System.out.println(Arrays.toString(DataIO.parseCsvFilename("/od/test/a.csv/name/col")));
        String table = "@T, a\ncreatedby, od\ndate, today\n@H,idx, hru_coeff, area, me\ntype, Double, Double, Double\n,1,1.3,3.5,5.6\n,2,1.3,3.5,5.6\n,3,1.3,3.5,5.6\n\n";
        String table1 = "@T, a\nbound, \"nhru,month\"\ncreatedby, od\ndate, today\n@H, 1, 2, 3\ntype, Double, Double, Double\n,1.3,3.5,5.6\n,1.3,3.5,5.6\n,1.3,3.5,5.6\n,1.3,3.5,5.6\n,1.3,3.5,5.6\n\n";
        CSTable t1 = DataIO.table(table, "a");
        DataIO.print(t1, new PrintWriter(System.out));
        CSProperties csp1 = DataIO.fromTable(t1);
        DataIO.print(csp1, new PrintWriter(System.out));
        String a = "llsl~lslsl~lslsllslslsl";
        Object[] o = a.split("\\~");
        System.out.println(Arrays.toString(o));
    }

    private static class URLTable
    extends CSVTable {
        URL url;

        URLTable(URL url, String name) throws IOException {
            this.url = url;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            try {
                return new InputStreamReader(this.url.openStream());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class StringTable
    extends CSVTable {
        String str;

        StringTable(String str, String name) throws IOException {
            this.str = str;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            return new StringReader(this.str);
        }
    }

    private static class FileTable
    extends CSVTable {
        File file;

        FileTable(File f, String name) throws IOException {
            this.file = f;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            try {
                return new FileReader(this.file);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static abstract class CSVTable
    implements CSTable {
        Map<Integer, Map<String, String>> info = new HashMap<Integer, Map<String, String>>();
        String name;
        int colCount;
        String[] columnNames;
        int firstline;
        static final CSVStrategy strategy = CSVStrategy.DEFAULT_STRATEGY;

        private CSVTable() {
        }

        protected abstract Reader newReader();

        protected void init(String tableName) throws IOException {
            Reader r = this.newReader();
            if (r == null) {
                throw new NullPointerException("reader");
            }
            CSVParser csv = new CSVParser(r, strategy);
            this.name = DataIO.locate(csv, tableName, new String[]{DataIO.TABLE, DataIO.TABLE1});
            this.firstline = this.readTableHeader(csv);
            r.close();
        }

        private void skip0(BufferedReader csv, int lines) {
            try {
                while (lines-- > 0) {
                    csv.readLine();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private String[] readRow(BufferedReader csv) {
            try {
                String s = csv.readLine();
                return s == null ? null : s.split("\\s*,\\s*");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Iterable<String[]> rows() {
            return this.rows(0);
        }

        @Override
        public Iterable<String[]> rows(final int startRow) {
            if (startRow < 0) {
                throw new IllegalArgumentException("startRow<0");
            }
            return new Iterable<String[]>(){

                @Override
                public TableIterator<String[]> iterator() {
                    Reader r = CSVTable.this.newReader();
                    if (r == null) {
                        throw new NullPointerException("reader");
                    }
                    final BufferedReader csv = new BufferedReader(r, 16384);
                    CSVTable.this.skip0(csv, CSVTable.this.firstline);
                    CSVTable.this.skip0(csv, startRow);
                    return new TableIterator<String[]>(){
                        String[] line;
                        int row;
                        {
                            this.line = CSVTable.this.readRow(csv);
                            this.row = startRow;
                        }

                        @Override
                        public void close() {
                            try {
                                csv.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            boolean hn;
                            boolean bl = hn = this.line != null && this.line.length > 1 && this.line[0].isEmpty();
                            if (!hn) {
                                this.close();
                            }
                            return hn;
                        }

                        @Override
                        public String[] next() {
                            String[] s = this.line;
                            s[0] = Integer.toString(++this.row);
                            this.line = CSVTable.this.readRow(csv);
                            return s;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void skip(int n) {
                            if (n < 1) {
                                throw new IllegalArgumentException("n<1 : " + n);
                            }
                            CSVTable.this.skip0(csv, n - 1);
                            this.line = CSVTable.this.readRow(csv);
                            this.row += n;
                        }

                        protected void finalize() throws Throwable {
                            super.finalize();
                            this.close();
                        }
                    };
                }
            };
        }

        private int readTableHeader(CSVParser csv) throws IOException {
            int i;
            LinkedHashMap<String, String> tableInfo = new LinkedHashMap<String, String>();
            this.info.put(-1, tableInfo);
            String[] line = null;
            while ((line = csv.getLine()) != null && !line[0].equalsIgnoreCase(DataIO.HEADER)) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                tableInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
            if (line == null) {
                throw new IOException("Invalid table structure.");
            }
            this.colCount = line.length - 1;
            this.columnNames = new String[line.length];
            this.columnNames[0] = "ROW";
            for (i = 1; i < line.length; ++i) {
                this.columnNames[i] = line[i];
                this.info.put(i, new LinkedHashMap());
            }
            while ((line = csv.getLine()) != null && !line[0].isEmpty()) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                for (i = 1; i < line.length; ++i) {
                    this.info.get(i).put(line[0], line[i]);
                }
            }
            assert (line != null && line[0].isEmpty());
            return csv.getLineNumber() - 1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getColumnInfo(-1);
        }

        @Override
        public Map<String, String> getColumnInfo(int column) {
            return Collections.unmodifiableMap(this.info.get(column));
        }

        @Override
        public int getColumnCount() {
            return this.colCount;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }
    }

    private static class CSVProperties
    extends BasicCSProperties
    implements CSProperties {
        CSVProperties(Reader reader, String name) throws IOException {
            CSVParser csv = new CSVParser(reader, CSVStrategy.DEFAULT_STRATEGY);
            this.name = DataIO.locate(csv, name, new String[]{DataIO.PROPERTIES, DataIO.PROPERTIES1});
            this.readProps(csv);
            reader.close();
        }

        private void readProps(CSVParser csv) throws IOException {
            HashMap<String, String> propInfo = null;
            String[] line = null;
            String propKey = DataIO.ROOT_ANN;
            while (!((line = csv.getLine()) == null || line[0].equalsIgnoreCase(DataIO.PROPERTIES) || line[0].equalsIgnoreCase(DataIO.PROPERTIES1) || line[0].equalsIgnoreCase(DataIO.TABLE) || line[0].equalsIgnoreCase(DataIO.TABLE1))) {
                if (line[0].startsWith(DataIO.COMMENT) || line[0].isEmpty()) continue;
                if (line[0].equalsIgnoreCase(DataIO.PROPERTY) || line[0].equalsIgnoreCase(DataIO.PROPERTY1)) {
                    if (line.length < 2) {
                        throw new IOException("Expected property name in line " + csv.getLineNumber());
                    }
                    propKey = line[1];
                    this.put(propKey, line.length > 2 ? line[2] : null);
                    propInfo = null;
                    continue;
                }
                if (propInfo == null) {
                    propInfo = new HashMap<String, String>();
                    this.info.put(propKey, propInfo);
                }
                propInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
        }
    }

    private static class BasicCSProperties
    extends LinkedHashMap<String, Object>
    implements CSProperties {
        private static final long serialVersionUID = 1L;
        String name = "";
        Map<String, Map<String, String>> info = new HashMap<String, Map<String, String>>();

        BasicCSProperties(Properties p) {
            this();
            for (Object key : p.keySet()) {
                this.put(key.toString(), p.getProperty(key.toString()));
            }
        }

        BasicCSProperties(Map<String, Object> p) {
            this();
            for (String key : p.keySet()) {
                this.put(key, p.get(key));
            }
        }

        BasicCSProperties() {
            this.info.put(DataIO.ROOT_ANN, new LinkedHashMap());
        }

        @Override
        public void putAll(CSProperties p) {
            for (String key : p.keySet()) {
                if (!this.containsKey(key)) continue;
                throw new IllegalArgumentException("Duplicate key in parameter sets: " + key);
            }
            super.putAll(p);
            for (String s : p.keySet()) {
                Map<String, String> m = p.getInfo(s);
                this.setInfo(s, m);
            }
            this.getInfo().putAll(p.getInfo());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public synchronized Map<String, String> getInfo(String property) {
            Map<String, String> im = this.info.get(property);
            if (im == null) {
                im = new HashMap<String, String>();
                this.info.put(property, im);
            }
            return im;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getInfo(DataIO.ROOT_ANN);
        }

        @Override
        public void setInfo(String propertyname, Map<String, String> inf) {
            this.info.put(propertyname, inf);
        }

        @Override
        public Object get(Object key) {
            Object val = super.get(key);
            if (val != null && val.getClass() == String.class) {
                return this.resolve((String)val);
            }
            return val;
        }

        private String resolve(String str) {
            if (str != null && str.contains("${")) {
                Matcher ma = null;
                while ((ma = varPattern.matcher(str)).find()) {
                    String key = ma.group(1);
                    String val = (String)this.get(key);
                    if (val == null) {
                        throw new IllegalArgumentException("value substitution failed for " + key);
                    }
                    Pattern repl = Pattern.compile("\\$\\{" + key + "\\}");
                    str = repl.matcher(str).replaceAll(val);
                }
            }
            return str;
        }
    }
}

