/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.utils.FlipUtils;

public class EdgedBalloonStyle
extends BalloonTipStyle {
    private Color borderColor;
    private Color fillColor;

    public EdgedBalloonStyle(Color color, Color color2) {
        this.borderColor = color2;
        this.fillColor = color;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + 1, 1, 1, 1);
        }
        return new Insets(1, 1, this.verticalOffset + 1, 1);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Point point;
        int n5;
        int n6;
        int n7 = n2;
        if (this.flipY) {
            n7 = n2 + this.verticalOffset;
        }
        graphics.setColor(this.fillColor);
        graphics.fillRect(n, n7, n3, n4 - this.verticalOffset);
        graphics.setColor(this.borderColor);
        graphics.drawRect(n, n7, n3 - 1, n4 - this.verticalOffset - 1);
        int[] nArray = new int[]{n + this.horizontalOffset, n + this.horizontalOffset + this.verticalOffset, n + this.horizontalOffset};
        int[] nArray2 = new int[]{n2 + n4 - this.verticalOffset - 1, n2 + n4 - this.verticalOffset - 1, n2 + n4 - 1};
        if (this.flipY) {
            n6 = n4 - 1;
            for (n5 = 0; n5 < nArray.length; ++n5) {
                point = FlipUtils.flipHorizontally(nArray[n5], nArray2[n5], n6);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
        }
        if (this.flipX) {
            n6 = n3 - 1;
            for (n5 = 0; n5 < nArray.length; ++n5) {
                point = FlipUtils.flipVertically(nArray[n5], nArray2[n5], n6);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
        }
        graphics.setColor(this.fillColor);
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(this.borderColor);
        graphics.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        graphics.setColor(this.fillColor);
        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics.setColor(this.borderColor);
        graphics.drawLine(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        graphics.drawLine(nArray[1], nArray2[1], nArray[1], nArray2[1]);
    }
}

