/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.positioners;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public abstract class BasicBalloonTipPositioner
extends BalloonTipPositioner {
    protected int x = 0;
    protected int y = 0;
    protected int hOffset = 0;
    protected boolean flipX = false;
    protected boolean flipY = false;
    protected int preferredHorizontalOffset;
    protected int preferredVerticalOffset;
    protected int minimumHorizontalOffset;
    protected boolean offsetCorrection = true;
    protected boolean orientationCorrection = true;
    protected boolean fixedAttachLocation = false;
    protected float attachLocationX = 0.0f;
    protected float attachLocationY = 0.0f;

    public BasicBalloonTipPositioner(int n, int n2) {
        this.preferredHorizontalOffset = n;
        this.preferredVerticalOffset = n2;
    }

    @Override
    public void setBalloonTip(BalloonTip balloonTip) {
        this.balloonTip = balloonTip;
        balloonTip.getStyle().setHorizontalOffset(this.preferredHorizontalOffset);
        balloonTip.getStyle().setVerticalOffset(this.preferredVerticalOffset);
        this.minimumHorizontalOffset = balloonTip.getStyle().getMinimalHorizontalOffset();
        balloonTip.addPropertyChangeListener("style", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BalloonTipStyle balloonTipStyle = (BalloonTipStyle)propertyChangeEvent.getNewValue();
                balloonTipStyle.setHorizontalOffset(BasicBalloonTipPositioner.this.preferredHorizontalOffset);
                balloonTipStyle.setVerticalOffset(BasicBalloonTipPositioner.this.preferredVerticalOffset);
                BasicBalloonTipPositioner.this.minimumHorizontalOffset = balloonTipStyle.getMinimalHorizontalOffset();
            }
        });
    }

    public int getPreferredHorizontalOffset() {
        return this.preferredHorizontalOffset;
    }

    public void setPreferredHorizontalOffset(int n) {
        this.preferredHorizontalOffset = n;
        this.balloonTip.getStyle().setHorizontalOffset(n);
        this.balloonTip.repaint();
    }

    public int getPreferredVerticalOffset() {
        return this.preferredVerticalOffset;
    }

    public void setPreferredVerticalOffset(int n) {
        this.preferredVerticalOffset = n;
        this.minimumHorizontalOffset = 2 * n;
        this.balloonTip.getStyle().setVerticalOffset(n);
    }

    public boolean isOffsetCorrected() {
        return this.offsetCorrection;
    }

    public void enableOffsetCorrection(boolean bl) {
        this.offsetCorrection = bl;
    }

    public boolean isOrientationCorrected() {
        return this.orientationCorrection;
    }

    public void enableOrientationCorrection(boolean bl) {
        this.orientationCorrection = bl;
    }

    public boolean isFixedAttachLocation() {
        return this.fixedAttachLocation;
    }

    public void enableFixedAttachLocation(boolean bl) {
        this.fixedAttachLocation = bl;
    }

    public float getAttachLocationX() {
        return this.attachLocationX;
    }

    public float getAttachLocationY() {
        return this.attachLocationY;
    }

    public void setAttachLocation(float f, float f2) {
        this.attachLocationX = f;
        this.attachLocationY = f2;
    }

    @Override
    public Point getTipLocation() {
        int n = this.x + this.hOffset;
        int n2 = this.y + this.balloonTip.getHeight();
        if (this.flipX) {
            n = this.x + this.hOffset;
        }
        if (this.flipY) {
            n2 = this.y;
        }
        return new Point(n, n2);
    }

    protected void applyOffsetCorrection() {
        int n = -this.x;
        int n2 = this.balloonTip.getWidth();
        if (n > 0) {
            this.x += n;
            this.hOffset -= n;
            if (this.hOffset < this.minimumHorizontalOffset) {
                this.hOffset = this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += -n + (n2 - this.preferredHorizontalOffset) - this.minimumHorizontalOffset) : (this.x += -n + this.preferredHorizontalOffset - this.minimumHorizontalOffset);
            }
        }
        if ((n = this.x + n2 - this.balloonTip.getTopLevelContainer().getWidth()) > 0) {
            this.x -= n;
            this.hOffset += n;
            if (this.hOffset > n2 - this.minimumHorizontalOffset) {
                this.hOffset = n2 - this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += n + this.preferredHorizontalOffset + this.minimumHorizontalOffset) : (this.x += n - (n2 - this.preferredHorizontalOffset) + this.minimumHorizontalOffset);
            }
        }
    }
}

