/*
 * WMSControlPanel.java
 *
 * Created on November 3, 2008, 7:56 AM
 */
package gw.ui.layerproperies;

import gov.nasa.worldwind.avlist.AVKey;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import java.util.Vector;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import gw.api.Events;

/**
 *
 * @author  od
 */
public class WMSLayerProperties extends javax.swing.JPanel {

    /** Creates new form WMSControlPanel */
    public WMSLayerProperties(final WMSTiledImageLayer layer) {
        initComponents();
        setupComponents(layer);
    }

    private void setupComponents(final WMSTiledImageLayer layer) {
        Vector<String> v = new Vector<String>();
//        for (Entry<String, Object> entry : layer.getEntries()) {
//            v.add(entry.getKey() + " :" + entry.getValue());
//        }
        AVList cp = (AVList) layer.getValue(AVKey.CONSTRUCTION_PARAMETERS);
        v.add("Service: " + cp.getValue(AVKey.SERVICE));
        v.add(java.util.ResourceBundle.getBundle("gw/resources/language").getString("L_Title") + cp.getValue(AVKey.TITLE));
        v.add(java.util.ResourceBundle.getBundle("gw/resources/language").getString("L_Dataset") + cp.getValue(AVKey.DATASET_NAME));
        v.add("Sector : " + cp.getValue(AVKey.SECTOR));
        v.add("Format : " + cp.getValue(AVKey.IMAGE_FORMAT));
        v.add("Cache  : " + cp.getValue(AVKey.DATA_CACHE_NAME));
        v.add("Tile   : " + cp.getValue(AVKey.LEVEL_ZERO_TILE_DELTA));
        conList.removeAll();
        conList.setListData(v);

        opacitySlider.setValue((int) (layer.getOpacity() * 100));
        opacitySlider.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider) e.getSource();
                int value = slider.getValue();
                layer.setOpacity((double) value / 100);
                firePropertyChange(Events.GF_UPDATE, null, null);
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        conList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        opacitySlider = new javax.swing.JSlider();
        jSeparator3 = new javax.swing.JSeparator();

        conList.setFont(new java.awt.Font("Monospaced", 0, 11));
        conList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "test" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(conList);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("gw/resources/language"); // NOI18N
        jLabel1.setText(bundle.getString("L_WMS_details")); // NOI18N

        jLabel2.setText(bundle.getString("L_Opacity")); // NOI18N

        opacitySlider.setMajorTickSpacing(25);
        opacitySlider.setMinorTickSpacing(5);
        opacitySlider.setPaintLabels(true);
        opacitySlider.setPaintTicks(true);
        opacitySlider.setPaintTrack(false);

        jSeparator3.setBackground(new java.awt.Color(208, 208, 191));
        jSeparator3.setForeground(new java.awt.Color(236, 233, 216));
        jSeparator3.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jSeparator3.setEnabled(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 210, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(jSeparator3, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 88, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(141, 141, 141)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addGap(56, 56, 56))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(opacitySlider, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2))
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSeparator3, javax.swing.GroupLayout.DEFAULT_SIZE, 47, Short.MAX_VALUE)
                    .addComponent(opacitySlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 47, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList conList;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSlider opacitySlider;
    // End of variables declaration//GEN-END:variables
}
