/*
 * ExperimentalPanel.java
 *
 * Created on November 10, 2008, 1:45 PM
 */
package gw.ui;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.SurfaceSector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

/**
 *
 * @author  od
 */
public class ExperimentalPanel extends javax.swing.JPanel implements PositionListener {

    WorldWindow ww;    //Things for drawing boxes
    Position currentPosition = null;
    MouseMotionListener mmlistener;
    RenderableLayer boxlayer;
    SurfaceSector box = null;
    Position start = null;

    /** Creates new form ExperimentalPanel */
    public ExperimentalPanel(WorldWindow ww) {
        initComponents();
        setupComponents(ww);
    }

    private void setupComponents(WorldWindow ww) {
        this.ww = ww;
        ww.addPositionListener(this);
        boxlayer = new RenderableLayer();
        boxlayer.setPickEnabled(false);
        ww.getModel().getLayers().add(boxlayer);
    }

    @Override
    public void moved(PositionEvent event) {
        currentPosition = event.getPosition();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        
        drawBoxButton = new javax.swing.JButton();
        elevationSlider = new javax.swing.JSlider();
        
        setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Experimental", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.BOTTOM));
        
        drawBoxButton.setText("Draw Box");
        drawBoxButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drawBoxButtonActionPerformed(evt);
            }
        });
        
        elevationSlider.setMajorTickSpacing(1000);
        elevationSlider.setMaximum(10000);
        elevationSlider.setMinorTickSpacing(500);
        elevationSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                elevationSliderChanged(evt);
            }
        });
        
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                .addComponent(drawBoxButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(elevationSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(23, Short.MAX_VALUE))
                );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(drawBoxButton)
                .addComponent(elevationSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(40, Short.MAX_VALUE))
                );
    }// </editor-fold>//GEN-END:initComponents

private void drawBoxButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drawBoxButtonActionPerformed
    mmlistener = new MouseMotionListener() {

        @Override
        public void mouseDragged(MouseEvent e) {
            if (box != null) {
                box.setSector(Sector.boundingSector(start, currentPosition));
            }
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            e.consume();
        }
    };
    ww.getInputHandler().addMouseMotionListener(mmlistener);
    ww.getInputHandler().addMouseListener(new MouseAdapter() {

        View oldView;

        @Override
        public void mousePressed(MouseEvent e) {
            start = currentPosition;
            box = new SurfaceSector(
                    Sector.boundingSector(start, currentPosition),
                    new Color(0.5f, 0.5f, 0.5f, 0.25f),
                    new Color(1.0f, 1.0f, 1.0f, 1.0f),
                    new Dimension(128, 128));

            boxlayer.addRenderable(box);
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (box != null) {
                box.setSector(Sector.boundingSector(start, currentPosition));
            }
            ww.redrawNow();
            ww.getInputHandler().removeMouseListener(this);
            ww.getInputHandler().removeMouseMotionListener(mmlistener);
            e.consume();
        }
    });
}//GEN-LAST:event_drawBoxButtonActionPerformed

private void elevationSliderChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_elevationSliderChanged
    // TODO add your handling code here:
}//GEN-LAST:event_elevationSliderChanged

// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JButton drawBoxButton;
private javax.swing.JSlider elevationSlider;
// End of variables declaration//GEN-END:variables
}
