/*
 * ScenarioDataTable.java
 *
 * Created on April 25, 2007, 4:58 PM
 */
package gw.calc;

import gw.ui.util.console.CommandHandler;
import java.awt.BorderLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

/**
 *
 * @author  od
 */
public class DataTable extends javax.swing.JPanel implements CommandHandler {

    TableCalculator calc;
    JTable table;
    JelLibrarySupport jel;
    
    /** Creates new form ScenarioDataTable */
    public DataTable(JTable t) {
        initComponents();
        setupComponents(t);
    }
    
    private void setupComponents(JTable t) {
        this.table = t;
        table.setRowSelectionAllowed(true);
        table.setDoubleBuffered(true);
        table.setRequestFocusEnabled(false);
        table.getSelectionModel().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        
        jel = new JelLibrarySupport(table.getModel());
        calc = new TableCalculator();

        JScrollPane pane = new JScrollPane();
        pane.setViewportView(table);
        add(pane, BorderLayout.CENTER);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents

    @Override
    public String handle(String cmd) {
        return calc.apply(jel, table, cmd);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
