/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Cylinder;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwind.render.RigidShape;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.Wedge;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.shapebuilder.AbstractShapeEditor;
import gov.nasa.worldwindx.examples.shapebuilder.BoxEditor;
import gov.nasa.worldwindx.examples.shapebuilder.ConeEditor;
import gov.nasa.worldwindx.examples.shapebuilder.CylinderEditor;
import gov.nasa.worldwindx.examples.shapebuilder.ExtrudedPolygonEditor;
import gov.nasa.worldwindx.examples.shapebuilder.PyramidEditor;
import gov.nasa.worldwindx.examples.shapebuilder.RigidShapeEditor;
import gov.nasa.worldwindx.examples.shapebuilder.WedgeEditor;
import gov.nasa.worldwindx.examples.util.ShapeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;

public class RigidShapeBuilder
extends ApplicationTemplate {
    protected static final String SHAPE_LAYER_NAME = "Rigid Shapes";
    protected static final String CLEAR_SELECTION = "AbstractShapeBuilder.ClearSelection";
    protected static final String SIZE_NEW_SHAPES_TO_VIEWPORT = "AbstractShapeBuilder.SizeNewShapesToViewport";
    protected static final String ENABLE_EDIT = "AbstractShapeBuilder.EnableEdit";
    protected static final String KEEP_SHAPE_ABOVE_SURFACE = "AbstractShapeBuilder.KeepShapeAboveSurface";
    protected static final String SET_EDIT_MODE = "AbstractShapeBuilder.SetEditMode";
    protected static final String NEW_ABSTRACT_SHAPE = "AbstractShapeBuilder.NewAbstractShape";
    protected static final String REMOVE_SELECTED = "AbstractShapeBuilder.RemoveSelected";
    protected static final String OPEN = "AbstractShapeBuilder.Open";
    protected static final String SAVE = "AbstractShapeBuilder.Save";
    protected static final String SELECTION_CHANGED = "AbstractShapeBuilder.SelectionChanged";
    protected static final String EDIT_TEXTURE = "AbstractShapeBuilder.EditTexture";
    protected static final String OPEN_IMAGE_FILE = "OpenImageFile";
    protected static EditMode[] defaultEditModes = new EditMode[]{new EditMode("move", 90), new EditMode("scale", 88), new EditMode("rotate", 67), new EditMode("skew", 86), new EditMode("texture", 66)};
    protected static AbstractShapeFactory[] defaultAbstractShapeFactories = new AbstractShapeFactory[]{new EllipsoidFactory(), new BoxFactory(), new CylinderFactory(), new PyramidFactory(), new ConeFactory(), new WedgeFactory(), new ExtrudedPolygonFactory()};
    protected static final double DEFAULT_SHAPE_SIZE_METERS = 100000.0;
    protected static long nextEntryNumber = 1L;

    public static ShapeAttributes getDefaultAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(new Material(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.BLACK, 0.0f));
        basicShapeAttributes.setOutlineMaterial(Material.DARK_GRAY);
        basicShapeAttributes.setDrawOutline(false);
        basicShapeAttributes.setInteriorOpacity(0.75);
        basicShapeAttributes.setOutlineOpacity(0.95);
        basicShapeAttributes.setOutlineWidth(2.0);
        basicShapeAttributes.setEnableLighting(true);
        return basicShapeAttributes;
    }

    public static ShapeAttributes getSelectionAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(Material.WHITE);
        basicShapeAttributes.setOutlineMaterial(Material.BLACK);
        basicShapeAttributes.setDrawOutline(false);
        basicShapeAttributes.setInteriorOpacity(0.85);
        basicShapeAttributes.setOutlineOpacity(0.8);
        basicShapeAttributes.setOutlineWidth(2.0);
        basicShapeAttributes.setEnableLighting(true);
        return basicShapeAttributes;
    }

    public static void setEditorAttributes(AbstractShapeEditor abstractShapeEditor) {
    }

    public static String getNextName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(nextEntryNumber++);
        return stringBuilder.toString();
    }

    private static AbstractShapeEditor getEditorFor(AbstractShape abstractShape) {
        if (!(abstractShape instanceof ExtrudedPolygon)) {
            if (abstractShape instanceof Ellipsoid) {
                RigidShapeEditor rigidShapeEditor = new RigidShapeEditor();
                rigidShapeEditor.setShape(abstractShape);
                return rigidShapeEditor;
            }
            if (abstractShape instanceof gov.nasa.worldwind.render.Box) {
                BoxEditor boxEditor = new BoxEditor();
                boxEditor.setShape(abstractShape);
                return boxEditor;
            }
            if (abstractShape instanceof Cylinder) {
                CylinderEditor cylinderEditor = new CylinderEditor();
                cylinderEditor.setShape(abstractShape);
                return cylinderEditor;
            }
            if (abstractShape instanceof Pyramid) {
                PyramidEditor pyramidEditor = new PyramidEditor();
                pyramidEditor.setShape(abstractShape);
                return pyramidEditor;
            }
            if (abstractShape instanceof Cone) {
                ConeEditor coneEditor = new ConeEditor();
                coneEditor.setShape(abstractShape);
                return coneEditor;
            }
            if (abstractShape instanceof Wedge) {
                WedgeEditor wedgeEditor = new WedgeEditor();
                wedgeEditor.setShape(abstractShape);
                return wedgeEditor;
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("3D Shape Builder", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer shapeLayer = new RenderableLayer();
        protected AbstractShapeBuilderModel builderModel;
        protected AbstractShapeBuilderPanel builderView;
        protected AbstractShapeBuilderController builderController;

        public AppFrame() {
            this.shapeLayer.setName(RigidShapeBuilder.SHAPE_LAYER_NAME);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.shapeLayer);
            this.getLayerPanel().update(this.getWwd());
            this.builderController = new AbstractShapeBuilderController(this);
            this.builderModel = new AbstractShapeBuilderModel();
            this.builderView = new AbstractShapeBuilderPanel(this.builderModel, this.builderController);
            this.getContentPane().add((Component)this.builderView, "South");
            this.builderController.setModel(this.builderModel);
            this.builderController.setView(this.builderView);
            this.builderController.setResizeNewShapesToViewport(true);
            this.builderController.setEditMode(this.builderView.getSelectedEditMode());
            AppFrame.makeMenuBar(this, this.builderController);
        }

        public AbstractShapeBuilderPanel getRigidShapeBuilderPanel() {
            return this.builderView;
        }

        public RenderableLayer getShapeLayer() {
            return this.shapeLayer;
        }

        public static void makeMenuBar(JFrame jFrame, final AbstractShapeBuilderController abstractShapeBuilderController) {
            JMenuItem jMenuItem;
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem2 = new JMenuItem("Open...");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem2.setActionCommand(RigidShapeBuilder.OPEN);
            jMenuItem2.addActionListener(abstractShapeBuilderController);
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Save...");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem2.setActionCommand(RigidShapeBuilder.SAVE);
            jMenuItem2.addActionListener(abstractShapeBuilderController);
            jMenu.add(jMenuItem2);
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Shape");
            jMenuItem2 = new JMenu("New");
            for (final AbstractShapeFactory object : defaultAbstractShapeFactories) {
                jMenuItem = new JMenuItem(object.toString());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        abstractShapeBuilderController.createNewEntry(object);
                    }
                });
                ((JMenu)jMenuItem2).add(jMenuItem);
            }
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenu("Edit Mode");
            for (final EditMode editMode : defaultEditModes) {
                jMenuItem = new JMenuItem(editMode.getMode());
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(editMode.getShortcut(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        abstractShapeBuilderController.setEditMode(editMode.getMode());
                    }
                });
                ((JMenu)jMenuItem2).add(jMenuItem);
            }
            jMenu.add(jMenuItem2);
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Fit new shapes to viewport");
            jCheckBoxMenuItem.setActionCommand(RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBoxMenuItem.addActionListener(abstractShapeBuilderController);
            jCheckBoxMenuItem.setState(abstractShapeBuilderController.isResizeNewShapesToViewport());
            jMenu.add(jCheckBoxMenuItem);
            final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Enable shape editing");
            jCheckBoxMenuItem2.setActionCommand(RigidShapeBuilder.ENABLE_EDIT);
            jCheckBoxMenuItem2.addActionListener(abstractShapeBuilderController);
            jCheckBoxMenuItem2.setState(abstractShapeBuilderController.isEnableEdit());
            jMenu.add(jCheckBoxMenuItem2);
            final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Keep shape above ground");
            jCheckBoxMenuItem3.setActionCommand(RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE);
            jCheckBoxMenuItem3.addActionListener(abstractShapeBuilderController);
            jCheckBoxMenuItem3.setState(abstractShapeBuilderController.isAboveGround());
            jMenu.add(jCheckBoxMenuItem3);
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Selection");
            jMenuItem2 = new JMenuItem("Deselect");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem2.setActionCommand(RigidShapeBuilder.CLEAR_SELECTION);
            jMenuItem2.addActionListener(abstractShapeBuilderController);
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Delete");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            jMenuItem2.setActionCommand(RigidShapeBuilder.REMOVE_SELECTED);
            jMenuItem2.addActionListener(abstractShapeBuilderController);
            jMenu.add(jMenuItem2);
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            abstractShapeBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBoxMenuItem.setSelected(abstractShapeBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.ENABLE_EDIT) {
                        jCheckBoxMenuItem2.setSelected(abstractShapeBuilderController.isEnableEdit());
                    } else if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE) {
                        jCheckBoxMenuItem3.setSelected(abstractShapeBuilderController.isAboveGround());
                    }
                }
            });
        }
    }

    protected static class AbstractShapeBuilderController
    extends WWObjectImpl
    implements ActionListener,
    MouseListener,
    CaretListener {
        protected AppFrame app;
        protected AbstractShapeBuilderModel model;
        protected AbstractShapeBuilderPanel view;
        protected AbstractShapeEntry selectedEntry;
        protected boolean enabled = true;
        protected boolean enableEdit = true;
        protected boolean aboveGround = false;
        protected boolean resizeNewShapes;
        protected String editMode;
        private JFileChooser fileChooser;
        protected AbstractShapeEditor editor;

        public AbstractShapeBuilderController(AppFrame appFrame) {
            this.app = appFrame;
            this.app.getWwd().getInputHandler().addMouseListener(this);
        }

        public AppFrame getApp() {
            return this.app;
        }

        public AbstractShapeBuilderModel getModel() {
            return this.model;
        }

        public void setModel(AbstractShapeBuilderModel abstractShapeBuilderModel) {
            this.model = abstractShapeBuilderModel;
        }

        public AbstractShapeEditor getActiveEditor() {
            return this.editor;
        }

        public void setActiveEditor(AbstractShapeEditor abstractShapeEditor) {
            this.editor = abstractShapeEditor;
        }

        public AbstractShapeBuilderPanel getView() {
            return this.view;
        }

        public void setView(AbstractShapeBuilderPanel abstractShapeBuilderPanel) {
            this.view = abstractShapeBuilderPanel;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.getView().setEnabled(bl);
            this.getApp().setEnabled(bl);
        }

        public boolean isEnableEdit() {
            return this.enableEdit;
        }

        public boolean isAboveGround() {
            return this.aboveGround;
        }

        public void setEnableEdit(boolean bl) {
            this.enableEdit = bl;
            this.handleEnableEdit(bl);
            this.firePropertyChange(RigidShapeBuilder.ENABLE_EDIT, null, bl);
        }

        public void setAboveGround(boolean bl) {
            this.aboveGround = bl;
            this.handleAboveGround(bl);
            this.firePropertyChange(RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE, null, bl);
        }

        public boolean isResizeNewShapesToViewport() {
            return this.resizeNewShapes;
        }

        public void setResizeNewShapesToViewport(boolean bl) {
            this.resizeNewShapes = bl;
            this.firePropertyChange(RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT, null, bl);
        }

        public String getEditMode() {
            return this.editMode;
        }

        public void setEditMode(String string) {
            this.editMode = string;
            this.view.setSelectedEditMode(string);
            if (this.editor != null) {
                this.editor.setEditMode(string);
            }
            this.getApp().getWwd().redraw();
        }

        public String getImageSource() {
            return this.view.textureBox.getText();
        }

        public void setImageSource(String string) {
            AbstractShape abstractShape = null;
            if (this.getSelectedEntry() != null) {
                abstractShape = this.getSelectedEntry().getShape();
            }
            if (abstractShape instanceof RigidShape) {
                RigidShapeEditor rigidShapeEditor = (RigidShapeEditor)this.getSelectedEntry().getEditor();
                RigidShape rigidShape = (RigidShape)abstractShape;
                int n = rigidShapeEditor.getSelectedFace();
                if (string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".bmp") || string.endsWith(".png") || string.endsWith(".gif")) {
                    rigidShape.setImageSource(n, string);
                    this.getApp().getWwd().redraw();
                } else {
                    rigidShape.setImageSource(n, null);
                    this.getApp().getWwd().redraw();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = actionEvent.getActionCommand();
            if (WWUtil.isEmpty(string)) {
                return;
            }
            if (string == RigidShapeBuilder.NEW_ABSTRACT_SHAPE) {
                AbstractShapeFactory abstractShapeFactory = this.getView().getSelectedFactory();
                this.createNewEntry(abstractShapeFactory);
            } else if (string == RigidShapeBuilder.CLEAR_SELECTION) {
                this.selectEntry(null, true);
            } else if (string == RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setResizeNewShapesToViewport(bl);
                }
            } else if (string == RigidShapeBuilder.ENABLE_EDIT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setEnableEdit(bl);
                }
            } else if (string == RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setAboveGround(bl);
                }
            } else if (string == RigidShapeBuilder.OPEN) {
                this.openFromFile();
            } else if (string == RigidShapeBuilder.REMOVE_SELECTED) {
                this.removeEntries(Arrays.asList(this.getSelectedEntries()));
            } else if (string == RigidShapeBuilder.SAVE) {
                this.saveToFile();
            } else if (string == RigidShapeBuilder.SELECTION_CHANGED) {
                this.viewSelectionChanged();
            } else if (string == RigidShapeBuilder.SET_EDIT_MODE) {
                this.setEditMode(this.getView().getSelectedEditMode());
            } else if (string == RigidShapeBuilder.EDIT_TEXTURE) {
                String string2 = this.getView().textureBox.getText();
                this.setImageSource(string2);
                this.view.textureBox.setText(string2);
            }
            if (string == RigidShapeBuilder.OPEN_IMAGE_FILE) {
                this.doOpenImageFile();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.isConsumed()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                this.handleSelect();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.setImageSource(this.getView().textureBox.getText());
        }

        protected void handleSelect() {
            PickedObjectList pickedObjectList = this.getApp().getWwd().getObjectsAtCurrentPosition();
            Object object = pickedObjectList.getTopObject();
            if (!(object instanceof AbstractShape)) {
                return;
            }
            AbstractShapeEntry abstractShapeEntry = this.getEntryFor((AbstractShape)object);
            if (abstractShapeEntry == null) {
                return;
            }
            if (this.getSelectedEntry() != abstractShapeEntry) {
                this.selectEntry(abstractShapeEntry, true);
            } else if (abstractShapeEntry.getShape() instanceof RigidShape) {
                RigidShape rigidShape = (RigidShape)this.selectedEntry.getShape();
                RigidShapeEditor rigidShapeEditor = (RigidShapeEditor)this.selectedEntry.getEditor();
                int n = rigidShapeEditor.getSelectedFace();
                this.view.textureBox.setText(rigidShape.getImageSource(n).toString());
            }
        }

        protected void handleEnableEdit(boolean bl) {
            if (this.getSelectedEntry() == null) {
                return;
            }
            if (this.isSelectionEditing() != bl) {
                this.setSelectionEditing(bl);
            }
        }

        protected void handleAboveGround(boolean bl) {
            if (this.getSelectedEntry() == null) {
                return;
            }
            if (this.getSelectedEntry().getEditor() != null) {
                this.getSelectedEntry().getEditor().setAboveGround(bl);
            }
        }

        public void createNewEntry(AbstractShapeFactory abstractShapeFactory) {
            AbstractShape abstractShape = abstractShapeFactory.createShape(this.getApp().getWwd(), this.isResizeNewShapesToViewport());
            AbstractShapeEditor abstractShapeEditor = abstractShapeFactory.createEditor(abstractShape);
            abstractShapeEditor.setAboveGround(this.isAboveGround());
            AbstractShapeEntry abstractShapeEntry = new AbstractShapeEntry(abstractShape, abstractShapeEditor);
            this.addEntry(abstractShapeEntry);
            this.selectEntry(abstractShapeEntry, true);
        }

        public void removeEntries(Iterable<? extends AbstractShapeEntry> iterable) {
            if (iterable != null) {
                for (AbstractShapeEntry abstractShapeEntry : iterable) {
                    this.removeEntry(abstractShapeEntry);
                }
            }
        }

        public void addEntry(AbstractShapeEntry abstractShapeEntry) {
            this.getModel().addEntry(abstractShapeEntry);
            this.getApp().getShapeLayer().addRenderable(abstractShapeEntry.getShape());
            this.getApp().getWwd().redraw();
        }

        public void removeEntry(AbstractShapeEntry abstractShapeEntry) {
            if (this.getSelectedEntry() == abstractShapeEntry) {
                this.selectEntry(null, true);
            }
            this.getModel().removeEntry(abstractShapeEntry);
            this.getApp().getShapeLayer().removeRenderable(abstractShapeEntry.getShape());
            this.getApp().getWwd().redraw();
        }

        public AbstractShapeEntry getSelectedEntry() {
            return this.selectedEntry;
        }

        public void selectEntry(AbstractShapeEntry abstractShapeEntry, boolean bl) {
            this.setSelectedEntry(abstractShapeEntry);
            if (bl) {
                if (abstractShapeEntry != null) {
                    int n = this.getModel().getIndexForEntry(abstractShapeEntry);
                    this.getView().setSelectedIndices(new int[]{n});
                } else {
                    this.getView().setSelectedIndices(new int[0]);
                }
            }
            if (this.isEnableEdit() && this.getSelectedEntry() != null && !this.isSelectionEditing()) {
                this.setSelectionEditing(true);
            }
            if (this.getSelectedEntry() != null) {
                this.getSelectedEntry().getEditor().setAboveGround(this.isAboveGround());
            }
            this.getApp().getWwd().redraw();
        }

        protected void setSelectedEntry(AbstractShapeEntry abstractShapeEntry) {
            if (this.selectedEntry != null) {
                if (this.selectedEntry != abstractShapeEntry && this.selectedEntry.isEditing()) {
                    this.setSelectionEditing(false);
                }
                this.selectedEntry.setSelected(false);
            }
            this.selectedEntry = abstractShapeEntry;
            if (this.selectedEntry != null) {
                this.selectedEntry.setSelected(true);
            }
        }

        protected boolean isSelectionEditing() {
            return this.selectedEntry != null && this.selectedEntry.isEditing();
        }

        protected void setSelectionEditing(boolean bl) {
            if (this.selectedEntry == null) {
                throw new IllegalStateException();
            }
            if (this.selectedEntry.isEditing() == bl) {
                throw new IllegalStateException();
            }
            this.selectedEntry.setEditing(bl);
            AbstractShapeEditor abstractShapeEditor = this.selectedEntry.getEditor();
            abstractShapeEditor.setArmed(bl);
            abstractShapeEditor.setEditMode(this.getEditMode());
            if (bl) {
                if (this.selectedEntry.getShape() instanceof RigidShape) {
                    RigidShape rigidShape = (RigidShape)this.getSelectedEntry().getShape();
                    RigidShapeEditor rigidShapeEditor = (RigidShapeEditor)this.getSelectedEntry().getEditor();
                    rigidShapeEditor.setSelectedFace(0);
                    if (rigidShape.getImageSource(0) == null) {
                        this.view.textureBox.setText("");
                    } else {
                        this.view.textureBox.setText(((RigidShape)this.selectedEntry.getShape()).getImageSource(0).toString());
                    }
                }
                abstractShapeEditor.setWorldWindow(this.app.getWwd());
                this.setActiveEditor(abstractShapeEditor);
                ApplicationTemplate.insertBeforePlacenames(this.getApp().getWwd(), abstractShapeEditor);
            } else {
                abstractShapeEditor.setWorldWindow(null);
                this.setActiveEditor(null);
                this.getApp().getWwd().getModel().getLayers().remove(abstractShapeEditor);
            }
            int n = this.getModel().getIndexForEntry(this.selectedEntry);
            this.getModel().fireTableRowsUpdated(n, n);
        }

        protected void viewSelectionChanged() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                for (AbstractShapeEntry abstractShapeEntry : this.getEntriesFor(nArray)) {
                    this.selectEntry(abstractShapeEntry, false);
                }
            }
            this.getApp().getWwd().redraw();
        }

        protected AbstractShapeEntry[] getSelectedEntries() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                return this.getEntriesFor(nArray);
            }
            return new AbstractShapeEntry[0];
        }

        protected AbstractShapeEntry[] getEntriesFor(int[] nArray) {
            AbstractShapeEntry[] abstractShapeEntryArray = new AbstractShapeEntry[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                abstractShapeEntryArray[i] = this.getModel().getEntry(nArray[i]);
            }
            return abstractShapeEntryArray;
        }

        protected AbstractShapeEntry getEntryFor(AbstractShape abstractShape) {
            for (AbstractShapeEntry abstractShapeEntry : this.getModel().getEntries()) {
                if (abstractShapeEntry.getShape() != abstractShape) continue;
                return abstractShapeEntry;
            }
            return null;
        }

        protected void saveToFile() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Directory to Place Shapes");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showSaveDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            final List<AbstractShapeEntry> list = this.getModel().getEntries();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat("####");
                        decimalFormat.setMinimumIntegerDigits(4);
                        int n = 0;
                        for (AbstractShapeEntry abstractShapeEntry : list) {
                            AbstractShape abstractShape = abstractShapeEntry.getShape();
                            ShapeAttributes shapeAttributes = abstractShape.getAttributes();
                            abstractShape.setAttributes(abstractShapeEntry.getAttributes());
                            String string = abstractShape.getRestorableState();
                            if (string != null) {
                                try {
                                    PrintWriter printWriter = new PrintWriter(new File(file, abstractShape.getClass().getName() + "-" + abstractShapeEntry.getName() + "-" + decimalFormat.format(n++) + ".xml"));
                                    printWriter.write(string);
                                    printWriter.flush();
                                    printWriter.close();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            abstractShape.setAttributes(shapeAttributes);
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AbstractShapeBuilderController.this.setEnabled(true);
                                AbstractShapeBuilderController.this.getApp().setCursor(null);
                                AbstractShapeBuilderController.this.getApp().getWwd().redraw();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setEnabled(false);
            this.getApp().setCursor(new Cursor(3));
            thread.start();
        }

        protected void openFromFile() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Shape File Directory");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showOpenDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<AbstractShape> arrayList = new ArrayList<AbstractShape>();
                    try {
                        File[] fileArray;
                        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String string) {
                                return string.startsWith("gov.nasa.worldwind.render") && string.endsWith(".xml");
                            }
                        })) {
                            String[] stringArray = file2.getName().split("-");
                            try {
                                Class<?> clazz = Class.forName(stringArray[0]);
                                AbstractShape abstractShape = (AbstractShape)clazz.newInstance();
                                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                                String string = bufferedReader.readLine();
                                abstractShape.restoreState(string);
                                arrayList.add(abstractShape);
                                if (stringArray.length < 2) continue;
                                abstractShape.setValue("gov.nasa.worldwind.avkey.DisplayName", stringArray[1]);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(arrayList){
                            final /* synthetic */ ArrayList val$shapes;
                            {
                                this.val$shapes = arrayList;
                            }

                            @Override
                            public void run() {
                                AbstractShapeBuilderController.this.setAbstractShapes(this.val$shapes);
                                AbstractShapeBuilderController.this.setEnabled(true);
                                AbstractShapeBuilderController.this.getApp().setCursor(null);
                                AbstractShapeBuilderController.this.getApp().getWwd().redraw();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setEnabled(false);
            this.getApp().setCursor(new Cursor(3));
            thread.start();
        }

        protected void doOpenImageFile() {
            int n;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(Configuration.getUserHomeDirectory());
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setMultiSelectionEnabled(true);
                this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Images", ImageIO.getReaderFormatNames()));
            }
            if ((n = this.fileChooser.showOpenDialog(null)) != 0) {
                return;
            }
            File[] fileArray = this.fileChooser.getSelectedFiles();
            this.loadFiles(fileArray);
        }

        protected void loadFiles(final File[] fileArray) {
            this.app.setCursor(Cursor.getPredefinedCursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (File file : fileArray) {
                        AbstractShapeBuilderController.this.loadFile(file);
                    }
                    AbstractShapeBuilderController.this.app.setCursor(null);
                }
            });
            thread.start();
        }

        protected void loadFile(final File file) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = file.getAbsolutePath();
                    AbstractShape abstractShape = null;
                    if (AbstractShapeBuilderController.this.getSelectedEntry() != null) {
                        abstractShape = AbstractShapeBuilderController.this.getSelectedEntry().getShape();
                    }
                    if (string != null && abstractShape != null) {
                        AbstractShapeBuilderController.this.setImageSource(string);
                        AbstractShapeBuilderController.this.view.textureBox.setText(string);
                    }
                }
            });
        }

        protected BufferedImage readImage(File file) {
            try {
                return ImageIO.read(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private void setAbstractShapes(Iterable<? extends AbstractShape> iterable) {
            ArrayList<AbstractShapeEntry> arrayList = new ArrayList<AbstractShapeEntry>(this.getModel().getEntries());
            this.removeEntries(arrayList);
            for (AbstractShape abstractShape : iterable) {
                abstractShape.setAttributes(RigidShapeBuilder.getDefaultAttributes());
                AbstractShapeEntry abstractShapeEntry = new AbstractShapeEntry(abstractShape, RigidShapeBuilder.getEditorFor(abstractShape));
                this.addEntry(abstractShapeEntry);
            }
        }
    }

    protected static class AbstractShapeBuilderPanel
    extends JPanel {
        private JComboBox factoryComboBox;
        private JComboBox editModeComboBox;
        protected JTable entryTable;
        protected JTextField textureBox;
        protected boolean ignoreSelectEvents = false;

        public AbstractShapeBuilderPanel(AbstractShapeBuilderModel abstractShapeBuilderModel, AbstractShapeBuilderController abstractShapeBuilderController) {
            this.initComponents(abstractShapeBuilderModel, abstractShapeBuilderController);
        }

        public int[] getSelectedIndices() {
            return this.entryTable.getSelectedRows();
        }

        public void setSelectedIndices(int[] nArray) {
            this.ignoreSelectEvents = true;
            if (nArray != null && nArray.length != 0) {
                for (int n : nArray) {
                    this.entryTable.setRowSelectionInterval(n, n);
                }
            } else {
                this.entryTable.clearSelection();
            }
            this.ignoreSelectEvents = false;
        }

        public AbstractShapeFactory getSelectedFactory() {
            return (AbstractShapeFactory)this.factoryComboBox.getSelectedItem();
        }

        public void setSelectedFactory(AbstractShapeFactory abstractShapeFactory) {
            this.factoryComboBox.setSelectedItem(abstractShapeFactory);
        }

        public String getSelectedEditMode() {
            return (String)this.editModeComboBox.getSelectedItem();
        }

        public void setSelectedEditMode(String string) {
            this.editModeComboBox.setSelectedItem(string);
        }

        protected void initComponents(AbstractShapeBuilderModel abstractShapeBuilderModel, final AbstractShapeBuilderController abstractShapeBuilderController) {
            JPanel jPanel = new JPanel();
            JComponent jComponent = new JButton("New shape");
            ((AbstractButton)jComponent).setActionCommand(RigidShapeBuilder.NEW_ABSTRACT_SHAPE);
            ((AbstractButton)jComponent).addActionListener(abstractShapeBuilderController);
            jComponent.setToolTipText("Create a new shape centered in the viewport");
            this.factoryComboBox = new JComboBox<AbstractShapeFactory>(defaultAbstractShapeFactories);
            this.factoryComboBox.setEditable(false);
            this.factoryComboBox.setToolTipText("Choose shape type to create");
            final JCheckBox jCheckBox = new JCheckBox("Fit new shapes to viewport");
            jCheckBox.setActionCommand(RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBox.addActionListener(abstractShapeBuilderController);
            jCheckBox.setSelected(abstractShapeBuilderController.isResizeNewShapesToViewport());
            jCheckBox.setAlignmentX(0.0f);
            jCheckBox.setToolTipText("New shapes are sized to fit the geographic viewport");
            JComponent jComponent2 = new JLabel("Edit Mode:");
            this.editModeComboBox = new JComboBox();
            for (EditMode object2 : defaultEditModes) {
                this.editModeComboBox.addItem(object2.getMode());
            }
            this.editModeComboBox.setActionCommand(RigidShapeBuilder.SET_EDIT_MODE);
            this.editModeComboBox.addActionListener(abstractShapeBuilderController);
            this.editModeComboBox.setEditable(false);
            this.editModeComboBox.setToolTipText("Choose edit mode (Ctrl-Z, Ctrl-X, Ctrl-C, Ctrl-V)");
            this.editModeComboBox.setName("Edit Mode");
            final JCheckBox jCheckBox2 = new JCheckBox("Enable shape editing");
            jCheckBox2.setActionCommand(RigidShapeBuilder.ENABLE_EDIT);
            jCheckBox2.addActionListener(abstractShapeBuilderController);
            jCheckBox2.setSelected(abstractShapeBuilderController.isEnableEdit());
            jCheckBox2.setAlignmentX(0.0f);
            jCheckBox2.setToolTipText("Allow modifications to shapes");
            final JCheckBox jCheckBox3 = new JCheckBox("Keep shape above ground");
            jCheckBox3.setActionCommand(RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE);
            jCheckBox3.addActionListener(abstractShapeBuilderController);
            jCheckBox3.setSelected(abstractShapeBuilderController.isAboveGround());
            jCheckBox3.setAlignmentX(0.0f);
            jCheckBox3.setToolTipText("Restrict shape movement to stay above ground");
            Object object3 = Box.createHorizontalBox();
            ((Container)object3).add(jComponent);
            ((Container)object3).add(Box.createHorizontalStrut(5));
            ((Container)object3).add(this.factoryComboBox);
            ((JComponent)object3).setAlignmentX(0.0f);
            JComponent jComponent3 = new JPanel(new GridLayout(0, 1, 0, 5));
            jComponent3.add((Component)object3);
            jComponent3.add(jCheckBox2);
            jComponent3.add(jCheckBox3);
            jComponent3.add(jComponent2);
            jComponent3.add(this.editModeComboBox);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jComponent3, "North");
            jComponent = new JPanel();
            this.entryTable = new JTable(abstractShapeBuilderModel);
            this.entryTable.setColumnSelectionAllowed(false);
            this.entryTable.setRowSelectionAllowed(true);
            this.entryTable.setSelectionMode(0);
            this.entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!AbstractShapeBuilderPanel.this.ignoreSelectEvents) {
                        abstractShapeBuilderController.actionPerformed(new ActionEvent(listSelectionEvent.getSource(), -1, RigidShapeBuilder.SELECTION_CHANGED));
                    }
                }
            });
            this.entryTable.setToolTipText("<html>Click to select<br>Double-Click to rename</html>");
            jComponent2 = new JScrollPane(this.entryTable);
            jComponent2.setPreferredSize(new Dimension(200, 100));
            jComponent.setLayout(new BorderLayout(0, 0));
            jComponent.add((Component)jComponent2, "Center");
            jComponent2 = new JPanel();
            object3 = new JButton("Deselect");
            ((AbstractButton)object3).setActionCommand(RigidShapeBuilder.CLEAR_SELECTION);
            ((AbstractButton)object3).addActionListener(abstractShapeBuilderController);
            ((JComponent)object3).setToolTipText("Clear the selection");
            jComponent3 = new JButton("Delete Selected");
            ((AbstractButton)jComponent3).setActionCommand(RigidShapeBuilder.REMOVE_SELECTED);
            ((AbstractButton)jComponent3).addActionListener(abstractShapeBuilderController);
            jComponent3.setToolTipText("Delete selected shapes");
            JButton jButton = new JButton("Open Image File...");
            jButton.setActionCommand(RigidShapeBuilder.OPEN_IMAGE_FILE);
            jButton.setAlignmentX(0.0f);
            jButton.addActionListener(abstractShapeBuilderController);
            JLabel jLabel = new JLabel("Shape texture:");
            this.textureBox = new JTextField(18);
            this.textureBox.setActionCommand(RigidShapeBuilder.EDIT_TEXTURE);
            this.textureBox.addActionListener(abstractShapeBuilderController);
            this.textureBox.addCaretListener(abstractShapeBuilderController);
            this.textureBox.setToolTipText("Set shape texture");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 5));
            jPanel2.add((Component)object3);
            jPanel2.add(jComponent3);
            jPanel2.add(jLabel);
            jPanel2.add(jButton);
            jPanel2.add(this.textureBox);
            jComponent2.setLayout(new BorderLayout());
            jComponent2.add((Component)jPanel2, "North");
            this.setLayout(new BorderLayout(30, 0));
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.add((Component)jPanel, "West");
            this.add((Component)jComponent, "Center");
            this.add((Component)jComponent2, "East");
            abstractShapeBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBox.setSelected(abstractShapeBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.ENABLE_EDIT) {
                        jCheckBox2.setSelected(abstractShapeBuilderController.isEnableEdit());
                    } else if (propertyChangeEvent.getPropertyName() == RigidShapeBuilder.KEEP_SHAPE_ABOVE_SURFACE) {
                        jCheckBox3.setSelected(abstractShapeBuilderController.isAboveGround());
                    }
                }
            });
        }
    }

    protected static class ExtrudedPolygonFactory
    implements AbstractShapeFactory {
        @Override
        public AbstractShape createShape(WorldWindow worldWindow, boolean bl) {
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon();
            extrudedPolygon.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            extrudedPolygon.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializePolygon(worldWindow, extrudedPolygon, bl);
            return extrudedPolygon;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            ExtrudedPolygonEditor extrudedPolygonEditor = new ExtrudedPolygonEditor();
            abstractShape.setAltitudeMode(extrudedPolygonEditor.getAltitudeMode());
            extrudedPolygonEditor.setShape(abstractShape);
            return extrudedPolygonEditor;
        }

        protected void initializePolygon(WorldWindow worldWindow, ExtrudedPolygon extrudedPolygon, boolean bl) {
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Angle angle = ShapeUtils.getNewShapeHeading(worldWindow, true);
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) : 100000.0;
            List<Position> list = ShapeUtils.createPositionSquareInViewport(worldWindow, position, angle, d);
            extrudedPolygon.setOuterBoundary(list);
            extrudedPolygon.setHeight(d);
            extrudedPolygon.setAltitudeMode(0);
        }

        public String toString() {
            return "Polygon";
        }
    }

    protected static class WedgeFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            Wedge wedge = new Wedge();
            wedge.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            wedge.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, wedge, bl);
            return wedge;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            WedgeEditor wedgeEditor = new WedgeEditor();
            abstractShape.setAltitudeMode(wedgeEditor.getAltitudeMode());
            wedgeEditor.setShape(abstractShape);
            return wedgeEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
            Wedge wedge = (Wedge)rigidShape;
            wedge.setWedgeAngle(Angle.fromDegrees(220.0));
        }

        public String toString() {
            return "Wedge";
        }
    }

    protected static class ConeFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            Cone cone = new Cone();
            cone.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            cone.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, cone, bl);
            return cone;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            ConeEditor coneEditor = new ConeEditor();
            abstractShape.setAltitudeMode(coneEditor.getAltitudeMode());
            coneEditor.setShape(abstractShape);
            return coneEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
        }

        public String toString() {
            return "Cone";
        }
    }

    protected static class PyramidFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            Pyramid pyramid = new Pyramid();
            pyramid.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            pyramid.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, pyramid, bl);
            return pyramid;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            PyramidEditor pyramidEditor = new PyramidEditor();
            abstractShape.setAltitudeMode(pyramidEditor.getAltitudeMode());
            pyramidEditor.setShape(abstractShape);
            return pyramidEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
        }

        public String toString() {
            return "Pyramid";
        }
    }

    protected static class CylinderFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            Cylinder cylinder = new Cylinder();
            cylinder.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, cylinder, bl);
            return cylinder;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            CylinderEditor cylinderEditor = new CylinderEditor();
            abstractShape.setAltitudeMode(cylinderEditor.getAltitudeMode());
            cylinderEditor.setShape(abstractShape);
            return cylinderEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
        }

        public String toString() {
            return "Cylinder";
        }
    }

    protected static class BoxFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            gov.nasa.worldwind.render.Box box = new gov.nasa.worldwind.render.Box();
            box.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            box.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, box, bl);
            return box;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            BoxEditor boxEditor = new BoxEditor();
            abstractShape.setAltitudeMode(boxEditor.getAltitudeMode());
            boxEditor.setShape(abstractShape);
            return boxEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
        }

        public String toString() {
            return "Box";
        }
    }

    protected static class EllipsoidFactory
    implements AbstractShapeFactory {
        @Override
        public RigidShape createShape(WorldWindow worldWindow, boolean bl) {
            Ellipsoid ellipsoid = new Ellipsoid();
            ellipsoid.setAttributes(RigidShapeBuilder.getDefaultAttributes());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.DisplayName", RigidShapeBuilder.getNextName(this.toString()));
            this.initializeShape(worldWindow, ellipsoid, bl);
            return ellipsoid;
        }

        @Override
        public AbstractShapeEditor createEditor(AbstractShape abstractShape) {
            RigidShapeEditor rigidShapeEditor = new RigidShapeEditor();
            abstractShape.setAltitudeMode(rigidShapeEditor.getAltitudeMode());
            rigidShapeEditor.setShape(abstractShape);
            return rigidShapeEditor;
        }

        protected void initializeShape(WorldWindow worldWindow, RigidShape rigidShape, boolean bl) {
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) / 2.0 : 100000.0;
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), d);
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            rigidShape.setCenterPosition(position2);
            rigidShape.setEastWestRadius(d);
            rigidShape.setVerticalRadius(d);
            rigidShape.setNorthSouthRadius(d);
            rigidShape.setHeading(Angle.ZERO);
            rigidShape.setTilt(Angle.ZERO);
            rigidShape.setRoll(Angle.ZERO);
            rigidShape.setAltitudeMode(0);
        }

        public String toString() {
            return "Ellipsoid";
        }
    }

    protected static interface AbstractShapeFactory {
        public AbstractShape createShape(WorldWindow var1, boolean var2);

        public AbstractShapeEditor createEditor(AbstractShape var1);
    }

    protected static class EditMode {
        protected String mode;
        protected int shortcut;

        public EditMode(String string, int n) {
            this.mode = string;
            this.shortcut = n;
        }

        public String getMode() {
            return this.mode;
        }

        public int getShortcut() {
            return this.shortcut;
        }
    }

    protected static class AbstractShapeBuilderModel
    extends AbstractTableModel {
        protected static String[] columnName = new String[]{"Name"};
        protected static Class[] columnClass = new Class[]{String.class};
        protected static String[] columnAttribute = new String[]{"gov.nasa.worldwind.avkey.DisplayName"};
        protected ArrayList<AbstractShapeEntry> entryList = new ArrayList();

        @Override
        public String getColumnName(int n) {
            return columnName[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return columnClass[n];
        }

        @Override
        public int getRowCount() {
            return this.entryList.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractShapeEntry abstractShapeEntry = this.entryList.get(n);
            return abstractShapeEntry.getValue(columnAttribute[n2]);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AbstractShapeEntry abstractShapeEntry = this.entryList.get(n);
            String string = columnAttribute[n2];
            abstractShapeEntry.setValue(string, object);
        }

        public List<AbstractShapeEntry> getEntries() {
            return Collections.unmodifiableList(this.entryList);
        }

        public void setEntries(Iterable<? extends AbstractShapeEntry> iterable) {
            this.entryList.clear();
            if (iterable != null) {
                for (AbstractShapeEntry abstractShapeEntry : iterable) {
                    this.entryList.add(abstractShapeEntry);
                }
            }
            this.fireTableDataChanged();
        }

        public void addEntry(AbstractShapeEntry abstractShapeEntry) {
            this.entryList.add(abstractShapeEntry);
            int n = this.entryList.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void removeEntry(AbstractShapeEntry abstractShapeEntry) {
            int n = this.entryList.indexOf(abstractShapeEntry);
            if (n != -1) {
                this.entryList.remove(abstractShapeEntry);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void removeAllEntries() {
            this.entryList.clear();
            this.fireTableDataChanged();
        }

        public AbstractShapeEntry getEntry(int n) {
            return this.entryList.get(n);
        }

        public AbstractShapeEntry setEntry(int n, AbstractShapeEntry abstractShapeEntry) {
            return this.entryList.set(n, abstractShapeEntry);
        }

        public int getIndexForEntry(AbstractShapeEntry abstractShapeEntry) {
            return this.entryList.indexOf(abstractShapeEntry);
        }
    }

    protected static class AbstractShapeEntry
    extends WWObjectImpl {
        protected AbstractShape shape;
        protected AbstractShapeEditor editor;
        protected ShapeAttributes attributes;
        protected boolean editing = false;
        protected boolean selected = false;

        public AbstractShapeEntry(AbstractShape abstractShape, AbstractShapeEditor abstractShapeEditor) {
            this.shape = abstractShape;
            this.editor = abstractShapeEditor;
            this.attributes = this.shape.getAttributes();
        }

        public boolean isEditing() {
            return this.editing;
        }

        public void setEditing(boolean bl) {
            this.editing = bl;
            this.updateAttributes();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.updateAttributes();
        }

        public String getName() {
            return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }

        public void setName(String string) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }

        public AbstractShape getShape() {
            return this.shape;
        }

        public AbstractShapeEditor getEditor() {
            return this.editor;
        }

        public ShapeAttributes getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null) {
                object = this.shape.getValue(string);
            }
            return object;
        }

        @Override
        public Object setValue(String string, Object object) {
            if (string == "gov.nasa.worldwind.avkey.DisplayName") {
                return this.shape.setValue(string, object);
            }
            return super.setValue(string, object);
        }

        protected void updateAttributes() {
            if (this.isSelected()) {
                this.shape.setAttributes(RigidShapeBuilder.getSelectionAttributes());
            } else {
                this.shape.setAttributes(this.getAttributes());
            }
        }
    }
}

