/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.lineofsight.PointGrid;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class GridOfPoints
extends ApplicationTemplate {
    protected static final int NUM_POINTS_WIDE = 500;
    protected static final int NUM_POINTS_HIGH = 500;

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 40.5);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -120.4);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 2000000.0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialHeading", 27);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 30);
        ApplicationTemplate.start("World Wind Point Grid", AppFrame.class);
    }

    protected static class PositionIterator
    implements Iterator<Position> {
        protected int numWide = 500;
        protected int numHigh = 500;
        protected int w;
        protected int h;
        protected List<Position> corners;
        protected Position sw;
        protected Position se;
        protected Position ne;
        protected Position nw;

        public PositionIterator(List<Position> list, int n, int n2) {
            this.corners = list;
            this.sw = list.get(0);
            this.se = list.get(1);
            this.ne = list.get(2);
            this.nw = list.get(3);
            this.numWide = n;
            this.numHigh = n2;
        }

        @Override
        public boolean hasNext() {
            return this.h < this.numHigh;
        }

        @Override
        public Position next() {
            if (this.h >= this.numHigh) {
                throw new NoSuchElementException("PointGridIterator");
            }
            return this.computeNextPosition();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("PointGridIterator");
        }

        protected Position computeNextPosition() {
            Position position;
            Position position2;
            Position position3;
            if (this.h == 0) {
                position3 = this.sw;
                position2 = this.se;
            } else if (this.h == this.numHigh - 1) {
                position3 = this.nw;
                position2 = this.ne;
            } else {
                double d = (double)this.h / (double)(this.numHigh - 1);
                position3 = Position.interpolate(d, this.sw, this.nw);
                position2 = Position.interpolate(d, this.se, this.ne);
            }
            if (this.w == 0) {
                position = position3;
                ++this.w;
            } else if (this.w == this.numWide - 1) {
                position = position2;
                this.w = ++this.h < this.numHigh ? 0 : this.w + 1;
            } else {
                double d = (double)this.w / (double)(this.numWide - 1);
                position = Position.interpolate(d, position3, position2);
                ++this.w;
            }
            return position;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer layer;
        protected HashMap<Position, Object> positionInfo;

        public AppFrame() {
            super(true, true, false);
            Object object;
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(35.0, -125.0, 10000.0));
            arrayList.add(Position.fromDegrees(35.0, -115.0, 10000.0));
            arrayList.add(Position.fromDegrees(45.0, -115.0, 10000.0));
            arrayList.add(Position.fromDegrees(45.0, -125.0, 10000.0));
            ArrayList<Position> arrayList2 = new ArrayList<Position>(250000);
            this.positionInfo = new HashMap(250000);
            int n = 0;
            PositionIterator positionIterator = new PositionIterator(arrayList, 500, 500);
            while (positionIterator.hasNext()) {
                object = positionIterator.next();
                arrayList2.add((Position)object);
                this.positionInfo.put((Position)object, n++);
            }
            object = new PointGrid(arrayList, arrayList2, 250000);
            PointGrid.Attributes attributes = new PointGrid.Attributes();
            attributes.setPointSize(6.0);
            ((PointGrid)object).setAttributes(attributes);
            this.layer = new RenderableLayer();
            this.layer.addRenderable((Renderable)object);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.layer);
            this.layerPanel.update(this.getWwd());
            this.setToolTipController(new ToolTipController(this.getWwd()){

                @Override
                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getTopObject() instanceof PointGrid) {
                        ((PointGrid)selectEvent.getTopObject()).setValue("gov.nasa.worldwind.avkey.DisplayName", AppFrame.this.positionInfo.get(selectEvent.getTopPickedObject().getPosition()).toString());
                    }
                    super.selected(selectEvent);
                }
            });
        }
    }
}

