/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;

public class OpenGLSupportTest
implements GLEventListener {
    public void init(GLAutoDrawable gLAutoDrawable) {
        int n = 0;
        for (String string : this.getRequiredOglFunctions()) {
            if (gLAutoDrawable.getGL().isFunctionAvailable(string)) continue;
            System.out.println("OpenGL function " + string + " is not available.");
            n = 1;
        }
        for (String string : this.getRequiredOglExtensions()) {
            if (gLAutoDrawable.getGL().isExtensionAvailable(string)) continue;
            System.out.println("OpenGL extension " + string + " is not available.");
            n = 2;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
        if (gLCapabilitiesImmutable.getAlphaBits() != 8 || gLCapabilitiesImmutable.getRedBits() != 8 || gLCapabilitiesImmutable.getGreenBits() != 8 || gLCapabilitiesImmutable.getBlueBits() != 8) {
            System.out.println("Device canvas color depth is inadequate.");
            n = 3;
        }
        if (gLCapabilitiesImmutable.getDepthBits() < 16) {
            System.out.println("Device canvas depth buffer depth is inadequate.");
            n = 4;
        }
        if (!gLCapabilitiesImmutable.getDoubleBuffered()) {
            System.out.println("Device canvas is not double buffered.");
            n = 5;
        }
        System.exit(n);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    protected String[] getRequiredOglFunctions() {
        return new String[]{"glActiveTexture", "glClientActiveTexture"};
    }

    protected String[] getRequiredOglExtensions() {
        return new String[]{"GL_EXT_texture_compression_s3tc"};
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("OpenGL Support Test");
        frame.setSize(200, 200);
        frame.setLayout(new BorderLayout());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getMaxFixedFunc((boolean)true));
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(24);
        gLCapabilities.setDoubleBuffered(true);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        OpenGLSupportTest openGLSupportTest = new OpenGLSupportTest();
        gLCanvas.addGLEventListener((GLEventListener)openGLSupportTest);
        frame.add((Component)gLCanvas, "Center");
        frame.validate();
        frame.setVisible(true);
    }
}

