/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractOnDemandLayerFeature;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.util.Iterator;

public class CoordinatesDisplay
extends AbstractOnDemandLayerFeature {
    public CoordinatesDisplay() {
        this((Registry)null);
    }

    public CoordinatesDisplay(Registry registry) {
        super("Coordinates", "gov.nasa.worldwindx.applications.worldwindow.feature.CoordinatesDisplay", "gov/nasa/worldwindx/applications/worldwindow/images/coordinates-64x64.png", null, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.addToToolBar();
    }

    @Override
    protected Layer createLayer() {
        Layer layer = this.doCreateLayer();
        layer.setPickEnabled(false);
        return layer;
    }

    @Override
    protected void addLayer(LayerPath layerPath) {
        this.controller.addInternalActiveLayer(this.layer);
    }

    @Override
    protected void removeLayer() {
        this.controller.getWWPanel().removeLayer(this.layer);
    }

    protected Layer doCreateLayer() {
        ScreenAnnotation screenAnnotation = new ScreenAnnotation("Dummy Text", new Point(100, 100));
        screenAnnotation.setAlwaysOnTop(true);
        AnnotationAttributes annotationAttributes = screenAnnotation.getAttributes();
        annotationAttributes.setTextColor(Color.WHITE);
        annotationAttributes.setFont(Font.decode("Consolas-Bold-15"));
        annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
        annotationAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        annotationAttributes.setBackgroundColor(Color.BLACK);
        annotationAttributes.setBorderColor(new Color(0.1f, 0.1f, 0.1f, 0.0f));
        annotationAttributes.setBorderWidth(0.0);
        annotationAttributes.setCornerRadius(5);
        annotationAttributes.setInsets(new Insets(10, 0, 0, 10));
        int n = 340;
        int n2 = 200;
        annotationAttributes.setSize(new Dimension(n, n2));
        annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Right");
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        annotationAttributes.setDrawOffset(new Point(-n / 2, -n2));
        CoordAnnotationLayer coordAnnotationLayer = new CoordAnnotationLayer();
        coordAnnotationLayer.setValue("gov.nasa.worldwindx.applications.worldwindow.ScreenLayer", true);
        coordAnnotationLayer.setPickEnabled(false);
        coordAnnotationLayer.addAnnotation(screenAnnotation);
        coordAnnotationLayer.setName(this.getName());
        return coordAnnotationLayer;
    }

    private Position getCurrentPosition(DrawContext drawContext) {
        if (drawContext.getPickedObjects() == null) {
            return null;
        }
        PickedObject pickedObject = drawContext.getPickedObjects().getTerrainObject();
        return pickedObject != null ? pickedObject.getPosition() : null;
    }

    private String formatText(DrawContext drawContext) {
        Object object;
        String string;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Position position = drawContext.getView().getEyePosition();
        if (position != null) {
            object2 = this.controller.getUnits();
            string = ((UnitsFormat)object2).getFormat("UnitsFormat.FormatEyeAltitude");
            object = string;
            if (Math.abs(position.getElevation() * ((UnitsFormat)object2).getLengthUnitsMultiplier()) < 10.0) {
                object = " %,6.3f %s";
                ((UnitsFormat)object2).setFormat("UnitsFormat.FormatEyeAltitude", (String)object);
            }
            stringBuilder.append(this.controller.getUnits().eyeAltitudeNL(position.getElevation()));
            if (!((String)object).equals(string)) {
                ((UnitsFormat)object2).setFormat("UnitsFormat.FormatEyeAltitude", string);
            }
        } else {
            stringBuilder.append("Altitude\n");
        }
        object2 = this.getCurrentPosition(drawContext);
        if (object2 != null) {
            stringBuilder.append(this.controller.getUnits().latitudeNL(((LatLon)object2).getLatitude()));
            stringBuilder.append(this.controller.getUnits().longitudeNL(((LatLon)object2).getLongitude()));
            stringBuilder.append(this.controller.getUnits().terrainHeightNL(((Position)object2).getElevation(), this.controller.getWWd().getSceneController().getVerticalExaggeration()));
        } else {
            stringBuilder.append(this.controller.getUnits().getStringValue("UnitsFormat.LatitudeLabel")).append("\n");
            stringBuilder.append(this.controller.getUnits().getStringValue("UnitsFormat.LongitudeLabel")).append("\n");
            stringBuilder.append(this.controller.getUnits().getStringValue("UnitsFormat.TerrainHeightLabel")).append("\n");
        }
        stringBuilder.append(this.controller.getUnits().pitchNL(this.computePitch(drawContext.getView())));
        stringBuilder.append(this.controller.getUnits().headingNL(this.computeHeading(drawContext.getView())));
        string = this.controller.getUnits().datumNL();
        if (this.controller.getUnits().isShowUTM()) {
            stringBuilder.append(string);
            if (object2 != null) {
                try {
                    object = UTMCoord.fromLatLon(((LatLon)object2).getLatitude(), ((LatLon)object2).getLongitude(), this.controller.getUnits().isShowWGS84() ? null : "NAD27");
                    stringBuilder.append(this.controller.getUnits().utmZoneNL(((UTMCoord)object).getZone()));
                    stringBuilder.append(this.controller.getUnits().utmEastingNL(((UTMCoord)object).getEasting()));
                    stringBuilder.append(this.controller.getUnits().utmNorthingNL(((UTMCoord)object).getNorthing()));
                }
                catch (Exception exception) {
                    stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMZoneLabel") + "\n", new Object[0]));
                    stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMEastingLabel") + "\n", new Object[0]));
                    stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMNorthingLabel") + "\n", new Object[0]));
                }
            } else {
                stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMZoneLabel") + "\n", new Object[0]));
                stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMEastingLabel") + "\n", new Object[0]));
                stringBuilder.append(String.format(this.controller.getUnits().getStringValue("UnitsFormat.UTMNorthingLabel") + "\n", new Object[0]));
            }
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private double computeHeading(View view) {
        if (view == null) {
            return 0.0;
        }
        if (!(view instanceof OrbitView)) {
            return 0.0;
        }
        OrbitView orbitView = (OrbitView)view;
        return orbitView.getHeading().getDegrees();
    }

    private double computePitch(View view) {
        if (view == null) {
            return 0.0;
        }
        if (!(view instanceof OrbitView)) {
            return 0.0;
        }
        OrbitView orbitView = (OrbitView)view;
        return orbitView.getPitch().getDegrees();
    }

    private class CoordAnnotationLayer
    extends AnnotationLayer {
        private CoordAnnotationLayer() {
        }

        @Override
        public void render(DrawContext drawContext) {
            Iterator<Annotation> iterator = this.getAnnotations().iterator();
            Annotation annotation = iterator.next();
            if (annotation != null && annotation instanceof ScreenAnnotation) {
                annotation.setText(CoordinatesDisplay.this.formatText(drawContext));
                Dimension dimension = CoordinatesDisplay.this.controller.getWWPanel().getSize();
                ((ScreenAnnotation)annotation).setScreenPoint(new Point(dimension.width, dimension.height));
            }
            super.render(drawContext);
        }
    }
}

